/*
 * Decompiled with CFR 0.152.
 */
package FrequencyCounter;

import com.phidgets.FrequencyCounterPhidget;
import com.phidgets.PhidgetException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import listeners.FCAttachListener;
import listeners.FCCountListener;
import listeners.FCDetachListener;
import listeners.FCErrorListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class FrequencyCounter
extends JFrame {
    private static String[] runArgs;
    private FrequencyCounterPhidget fc;
    private Hashtable filterTypeHashTable;
    private FCAttachListener attach_listener;
    private FCDetachListener detach_listener;
    private FCErrorListener error_listener;
    private FCCountListener count_listener;
    private JTextField attachedTxt;
    private JComboBox channelCmb;
    private JTextField countTxt;
    private JCheckBox enableChk;
    private JComboBox filterCmb;
    private JPanel frequencyPanel;
    private JTextField frequencyTxt;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JTextField numChannelsTxt;
    private JButton resetTotalTimeAndCountBtn;
    private JTextField serialTxt;
    private JButton setTimeoutBtn;
    private JTextField timeTxt;
    private JTextField timeoutTxt;
    private JTextField totalCountTxt;
    private JTextField totalTimeTxt;
    private JTextField versionTxt;

    public FrequencyCounter() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numChannelsTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.frequencyPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.channelCmb = new JComboBox();
        this.enableChk = new JCheckBox();
        this.filterCmb = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.timeoutTxt = new JTextField();
        this.jLabel9 = new JLabel();
        this.countTxt = new JTextField();
        this.jLabel10 = new JLabel();
        this.timeTxt = new JTextField();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.frequencyTxt = new JTextField();
        this.totalCountTxt = new JTextField();
        this.totalTimeTxt = new JTextField();
        this.setTimeoutBtn = new JButton();
        this.resetTotalTimeAndCountBtn = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("FrequencyCounter-full");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                FrequencyCounter.this.formWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Frequency Counter Info"));
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.attachedTxt.setEditable(false);
        this.jPanel1.add((Component)this.attachedTxt, new AbsoluteConstraints(97, 33, 200, -1));
        this.jLabel1.setText("Attached:");
        this.jPanel1.add((Component)this.jLabel1, new AbsoluteConstraints(43, 36, -1, -1));
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.nameTxt.setPreferredSize(new Dimension(200, 58));
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jPanel1.add((Component)this.jScrollPane1, new AbsoluteConstraints(97, 68, 200, -1));
        this.jLabel2.setText("Name:");
        this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(60, 68, -1, -1));
        this.serialTxt.setEditable(false);
        this.jPanel1.add((Component)this.serialTxt, new AbsoluteConstraints(97, 144, 200, -1));
        this.jLabel3.setText("Serial No:");
        this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(41, 147, -1, -1));
        this.versionTxt.setEditable(false);
        this.jPanel1.add((Component)this.versionTxt, new AbsoluteConstraints(97, 180, 200, -1));
        this.jLabel4.setText("Version:");
        this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(48, 180, -1, -1));
        this.numChannelsTxt.setEditable(false);
        this.jPanel1.add((Component)this.numChannelsTxt, new AbsoluteConstraints(97, 216, 200, -1));
        this.jLabel5.setText("# Channels:");
        this.jPanel1.add((Component)this.jLabel5, new AbsoluteConstraints(30, 220, -1, 20));
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(10, 10, 320, 252));
        this.frequencyPanel.setBorder(BorderFactory.createTitledBorder("Frequency Info"));
        this.frequencyPanel.setLayout(new AbsoluteLayout());
        this.jLabel6.setText("Choose Channel:");
        this.frequencyPanel.add((Component)this.jLabel6, new AbsoluteConstraints(10, 36, -1, -1));
        this.channelCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrequencyCounter.this.channelCmbActionPerformed(evt);
            }
        });
        this.frequencyPanel.add((Component)this.channelCmb, new AbsoluteConstraints(110, 33, 190, -1));
        this.enableChk.setText("Enabled");
        this.enableChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrequencyCounter.this.enableChkActionPerformed(evt);
            }
        });
        this.frequencyPanel.add((Component)this.enableChk, new AbsoluteConstraints(20, 70, -1, -1));
        this.filterCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrequencyCounter.this.filterCmbActionPerformed(evt);
            }
        });
        this.frequencyPanel.add((Component)this.filterCmb, new AbsoluteConstraints(150, 72, 150, -1));
        this.jLabel7.setText("Filter:");
        this.frequencyPanel.add((Component)this.jLabel7, new AbsoluteConstraints(112, 75, -1, -1));
        this.jLabel8.setText("Timeout(ms):");
        this.frequencyPanel.add((Component)this.jLabel8, new AbsoluteConstraints(28, 113, -1, -1));
        this.timeoutTxt.setEditable(false);
        this.frequencyPanel.add((Component)this.timeoutTxt, new AbsoluteConstraints(105, 110, 105, -1));
        this.jLabel9.setText("Count Events");
        this.frequencyPanel.add((Component)this.jLabel9, new AbsoluteConstraints(21, 150, -1, -1));
        this.countTxt.setEditable(false);
        this.frequencyPanel.add((Component)this.countTxt, new AbsoluteConstraints(50, 170, 70, -1));
        this.jLabel10.setText("pulses in ");
        this.frequencyPanel.add((Component)this.jLabel10, new AbsoluteConstraints(125, 173, -1, -1));
        this.timeTxt.setEditable(false);
        this.frequencyPanel.add((Component)this.timeTxt, new AbsoluteConstraints(180, 170, 90, -1));
        this.jLabel11.setText("ms");
        this.frequencyPanel.add((Component)this.jLabel11, new AbsoluteConstraints(280, 173, -1, -1));
        this.jLabel12.setText("Frequency(Hz):");
        this.frequencyPanel.add((Component)this.jLabel12, new AbsoluteConstraints(19, 213, -1, -1));
        this.jLabel13.setText("Total Count:");
        this.frequencyPanel.add((Component)this.jLabel13, new AbsoluteConstraints(33, 253, -1, -1));
        this.jLabel14.setText("Total Time(ms):");
        this.frequencyPanel.add((Component)this.jLabel14, new AbsoluteConstraints(19, 293, -1, -1));
        this.frequencyTxt.setEditable(false);
        this.frequencyPanel.add((Component)this.frequencyTxt, new AbsoluteConstraints(110, 210, 187, -1));
        this.totalCountTxt.setEditable(false);
        this.frequencyPanel.add((Component)this.totalCountTxt, new AbsoluteConstraints(110, 250, 187, -1));
        this.totalTimeTxt.setEditable(false);
        this.frequencyPanel.add((Component)this.totalTimeTxt, new AbsoluteConstraints(110, 290, 187, -1));
        this.setTimeoutBtn.setText("setTimeout");
        this.setTimeoutBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrequencyCounter.this.setTimeoutBtnActionPerformed(evt);
            }
        });
        this.frequencyPanel.add((Component)this.setTimeoutBtn, new AbsoluteConstraints(215, 109, -1, -1));
        this.resetTotalTimeAndCountBtn.setText("reset Total Count and Total Time");
        this.resetTotalTimeAndCountBtn.setAlignmentY(0.0f);
        this.resetTotalTimeAndCountBtn.setMargin(new Insets(2, 4, 2, 4));
        this.resetTotalTimeAndCountBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrequencyCounter.this.resetTotalTimeAndCountBtnActionPerformed(evt);
            }
        });
        this.frequencyPanel.add((Component)this.resetTotalTimeAndCountBtn, new AbsoluteConstraints(55, 325, 210, -1));
        this.getContentPane().add((Component)this.frequencyPanel, new AbsoluteConstraints(10, 263, 320, 360));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.setSize(357, 311);
        this.attachedTxt.setText("false");
        this.frequencyPanel.setVisible(false);
        this.frequencyPanel.setEnabled(false);
        this.channelCmb.setVisible(false);
        this.channelCmb.setEnabled(false);
        this.filterCmb.setVisible(false);
        this.filterCmb.setEnabled(false);
        this.filterTypeHashTable = new Hashtable();
        this.filterTypeHashTable.put("Zero-Crossing", 1);
        this.filterTypeHashTable.put("Logic-Level", 2);
        this.enableChk.setVisible(false);
        this.enableChk.setEnabled(false);
        this.timeoutTxt.setVisible(false);
        this.timeoutTxt.setEnabled(false);
        this.setTimeoutBtn.setEnabled(false);
        this.setTimeoutBtn.setVisible(false);
        this.countTxt.setVisible(false);
        this.countTxt.setEnabled(false);
        this.timeTxt.setVisible(false);
        this.timeTxt.setEnabled(false);
        this.frequencyTxt.setVisible(false);
        this.frequencyTxt.setEnabled(false);
        this.totalCountTxt.setVisible(false);
        this.totalCountTxt.setEnabled(false);
        this.totalTimeTxt.setVisible(false);
        this.totalTimeTxt.setEnabled(false);
        this.resetTotalTimeAndCountBtn.setEnabled(false);
        this.resetTotalTimeAndCountBtn.setVisible(false);
        try {
            this.fc = new FrequencyCounterPhidget();
            this.attach_listener = new FCAttachListener(this, this.frequencyPanel, this.channelCmb, this.filterCmb, this.filterTypeHashTable, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numChannelsTxt, this.enableChk, this.timeoutTxt, this.setTimeoutBtn, this.countTxt, this.timeTxt, this.frequencyTxt, this.totalCountTxt, this.totalTimeTxt, this.resetTotalTimeAndCountBtn);
            this.detach_listener = new FCDetachListener(this, this.frequencyPanel, this.channelCmb, this.filterCmb, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numChannelsTxt, this.enableChk, this.timeoutTxt, this.setTimeoutBtn, this.countTxt, this.timeTxt, this.frequencyTxt, this.totalCountTxt, this.totalTimeTxt, this.resetTotalTimeAndCountBtn);
            this.error_listener = new FCErrorListener(this);
            this.count_listener = new FCCountListener(this.channelCmb, this.countTxt, this.timeTxt, this.frequencyTxt, this.totalCountTxt, this.totalTimeTxt);
            this.fc.addAttachListener(this.attach_listener);
            this.fc.addDetachListener(this.detach_listener);
            this.fc.addErrorListener(this.error_listener);
            this.fc.addFrequencyCounterCountListener(this.count_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.fc.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                this.fc.open(Integer.parseInt(runArgs[0]));
            } else {
                this.fc.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void channelCmbActionPerformed(ActionEvent evt) {
        this.reset();
        try {
            if (this.fc.isAttached() && this.fc.getEnabled((Integer)this.channelCmb.getSelectedItem())) {
                this.enableChk.setSelected(true);
                this.filterCmb.setEnabled(true);
                this.setFilterCmb();
                this.setTimeoutBtn.setEnabled(true);
                this.timeoutTxt.setEditable(true);
                this.timeoutTxt.setText(Integer.toString(this.fc.getTimeout((Integer)this.channelCmb.getSelectedItem()) / 1000));
                this.resetTotalTimeAndCountBtn.setEnabled(true);
            } else {
                this.enableChk.setSelected(false);
                this.timeoutTxt.setEditable(false);
                this.setTimeoutBtn.setEnabled(false);
                this.filterCmb.setEnabled(false);
                this.resetTotalTimeAndCountBtn.setEnabled(false);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void filterCmbActionPerformed(ActionEvent evt) {
        this.reset();
        int index = (Integer)this.channelCmb.getSelectedItem();
        try {
            if (this.fc.isAttached() && this.fc.getEnabled(index)) {
                int value = (Integer)this.filterTypeHashTable.get(this.filterCmb.getSelectedItem());
                this.fc.setFilter(index, value);
                this.timeoutTxt.setText(Integer.toString(this.fc.getTimeout((Integer)this.channelCmb.getSelectedItem()) / 1000));
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void setTimeoutBtnActionPerformed(ActionEvent evt) {
        try {
            this.fc.setTimeout((Integer)this.channelCmb.getSelectedItem(), Integer.parseInt(this.timeoutTxt.getText()) * 1000);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void enableChkActionPerformed(ActionEvent evt) {
        this.reset();
        try {
            this.fc.setEnabled((Integer)this.channelCmb.getSelectedItem(), this.enableChk.isSelected());
            if (this.enableChk.isSelected()) {
                this.filterCmb.setEnabled(true);
                this.setFilterCmb();
                this.setTimeoutBtn.setEnabled(true);
                this.timeoutTxt.setEditable(true);
                this.timeoutTxt.setText(Integer.toString(this.fc.getTimeout((Integer)this.channelCmb.getSelectedItem()) / 1000));
                this.resetTotalTimeAndCountBtn.setEnabled(true);
            } else {
                this.filterCmb.setEnabled(false);
                this.timeoutTxt.setEditable(false);
                this.setTimeoutBtn.setEnabled(false);
                this.resetTotalTimeAndCountBtn.setEnabled(false);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void resetTotalTimeAndCountBtnActionPerformed(ActionEvent evt) {
        try {
            this.fc.reset((Integer)this.channelCmb.getSelectedItem());
            this.timeTxt.setText("");
            this.countTxt.setText("");
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void setFilterCmb() {
        int index = (Integer)this.channelCmb.getSelectedItem();
        Enumeration eKeys = this.filterTypeHashTable.keys();
        try {
            int element = this.fc.getFilter(index);
            while (eKeys.hasMoreElements()) {
                Object currKey = eKeys.nextElement();
                if ((Integer)this.filterTypeHashTable.get(currKey) != element) continue;
                this.filterCmb.setSelectedItem(currKey);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void reset() {
        this.timeoutTxt.setText("");
        this.countTxt.setText("");
        this.timeTxt.setText("");
        this.frequencyTxt.setText("");
        this.totalCountTxt.setText("");
        this.totalTimeTxt.setText("");
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new FrequencyCounter().setVisible(true);
            }
        });
    }
}

