/*
 * Decompiled with CFR 0.152.
 */
package TemperatureSensor;

import com.phidgets.PhidgetException;
import com.phidgets.TemperatureSensorPhidget;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.TempSensorAttachListener;
import listeners.TempSensorDetachListener;
import listeners.TempSensorErrorListener;
import listeners.TempSensorTemperatureChangeListener;
import org.jdesktop.layout.GroupLayout;

public class TemperatureSensor
extends JFrame {
    private static String[] runArgs;
    private TemperatureSensorPhidget tempSensor;
    private TempSensorAttachListener attach_listener;
    private TempSensorDetachListener detach_listener;
    private TempSensorErrorListener error_listener;
    private TempSensorTemperatureChangeListener change_listener;
    private JLabel ambientRngLbl;
    private JTextField attachedTxt;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JTextField numTCTxt;
    private JTextField onBoardTxt;
    private JTextField potTxt;
    private JLabel potentialRngLbl;
    private JSlider sensitivityScrl;
    private JTextField sensitivityTxt;
    private JTextField serialTxt;
    private JTextField tcTempTxt;
    private JLabel thermoRngLbl;
    private JComboBox thermoTypeCmb;
    private JTextField versionTxt;

    public TemperatureSensor() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numTCTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.tcTempTxt = new JTextField();
        this.potTxt = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.sensitivityTxt = new JTextField();
        this.sensitivityScrl = new JSlider();
        this.onBoardTxt = new JTextField();
        this.jLabel9 = new JLabel();
        this.thermoRngLbl = new JLabel();
        this.jLabel10 = new JLabel();
        this.thermoTypeCmb = new JComboBox();
        this.potentialRngLbl = new JLabel();
        this.ambientRngLbl = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("TemperatureSensor - full");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                TemperatureSensor.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                TemperatureSensor.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Device Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        this.numTCTxt.setEditable(false);
        this.jLabel5.setText("Thermocouples:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(31, 31, 31).add(jPanel1Layout.createParallelGroup(2).add(this.jLabel2).add(this.jLabel1).add(this.jLabel3).add(this.jLabel4).add(this.jLabel5)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.numTCTxt).add(1, this.versionTxt).add(1, this.serialTxt).add(1, this.attachedTxt).add(1, this.jScrollPane1, -2, -1, -2)).addContainerGap(27, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(15, 15, 15).add(this.jScrollPane1, -2, -1, -2).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numTCTxt, -2, -1, -2).add(this.jLabel5))).add(jPanel1Layout.createSequentialGroup().add(31, 31, 31).add(this.jLabel2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Sensor Data"));
        this.jLabel6.setText("Thermocouple Temperature:");
        this.tcTempTxt.setEditable(false);
        this.potTxt.setEditable(false);
        this.jLabel7.setText("Potential(milliVolts):");
        this.jLabel8.setText("Sensitivity:");
        this.sensitivityTxt.setEditable(false);
        this.sensitivityScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TemperatureSensor.this.sensitivityScrlStateChanged(evt);
            }
        });
        this.onBoardTxt.setEditable(false);
        this.jLabel9.setText("Ambient Temperature:");
        this.thermoRngLbl.setText("()");
        this.jLabel10.setText("Thermocouple Type:");
        this.thermoTypeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"K-Type", "J-Type", "E-Type", "T-Type"}));
        this.thermoTypeCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemperatureSensor.this.thermoTypeCmbActionPerformed(evt);
            }
        });
        this.potentialRngLbl.setText("()");
        this.ambientRngLbl.setText("()");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.jLabel10)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(10, 10, 10).add(this.thermoRngLbl)).add(this.jLabel6)))).addPreferredGap(0)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.jLabel8).addPreferredGap(0).add(this.sensitivityTxt, -1, 51, Short.MAX_VALUE).add(32, 32, 32)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(10, 10, 10).add(this.potentialRngLbl)).add(this.jLabel7)).add(47, 47, 47))).add(jPanel2Layout.createParallelGroup(1).add(this.potTxt, -1, 142, Short.MAX_VALUE).add(2, this.sensitivityScrl, -1, 142, Short.MAX_VALUE).add(2, this.thermoTypeCmb, 0, 142, Short.MAX_VALUE).add(this.tcTempTxt, -1, 142, Short.MAX_VALUE))).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(10, 10, 10).add(this.ambientRngLbl)).add(jPanel2Layout.createSequentialGroup().add(this.jLabel9).add(32, 32, 32).add(this.onBoardTxt, -1, 142, Short.MAX_VALUE))))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel6).add(this.tcTempTxt, -2, -1, -2)).addPreferredGap(0).add(this.thermoRngLbl).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel10).add(this.thermoTypeCmb, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel7).add(this.potTxt, -2, -1, -2)).addPreferredGap(0).add(this.potentialRngLbl).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel9).add(this.onBoardTxt, -2, -1, -2)).addPreferredGap(0).add(this.ambientRngLbl).addPreferredGap(0, 13, Short.MAX_VALUE).add(jPanel2Layout.createParallelGroup(2).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel8).add(this.sensitivityTxt, -2, -1, -2)).add(this.sensitivityScrl, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, this.jPanel1, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.sensitivityScrl.setEnabled(false);
        this.sensitivityScrl.setMaximum(200);
        this.sensitivityScrl.setMinimum(0);
        this.thermoTypeCmb.setEnabled(false);
        try {
            this.tempSensor = new TemperatureSensorPhidget();
            this.attach_listener = new TempSensorAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numTCTxt, this.sensitivityScrl, this.potTxt, this.potentialRngLbl, this.tcTempTxt, this.thermoRngLbl, this.sensitivityTxt, this.onBoardTxt, this.ambientRngLbl, this.thermoTypeCmb);
            this.detach_listener = new TempSensorDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numTCTxt, this.sensitivityScrl, this.potTxt, this.potentialRngLbl, this.tcTempTxt, this.thermoRngLbl, this.sensitivityTxt, this.onBoardTxt, this.ambientRngLbl, this.thermoTypeCmb);
            this.error_listener = new TempSensorErrorListener(this);
            this.change_listener = new TempSensorTemperatureChangeListener(this, this.potTxt, this.tcTempTxt, this.onBoardTxt);
            this.tempSensor.addAttachListener(this.attach_listener);
            this.tempSensor.addDetachListener(this.detach_listener);
            this.tempSensor.addErrorListener(this.error_listener);
            this.tempSensor.addTemperatureChangeListener(this.change_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.tempSensor.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.tempSensor.open(Integer.parseInt(runArgs[0]));
            } else {
                this.tempSensor.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void sensitivityScrlStateChanged(ChangeEvent evt) {
        if (this.sensitivityScrl.isEnabled()) {
            try {
                this.tempSensor.setTemperatureChangeTrigger(0, (double)this.sensitivityScrl.getValue() / 100.0);
                this.sensitivityTxt.setText(Double.toString((double)this.sensitivityScrl.getValue() / 100.0));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.tempSensor.removeTemperatureChangeListener(this.change_listener);
            this.tempSensor.removeErrorListener(this.error_listener);
            this.tempSensor.removeDetachListener(this.detach_listener);
            this.tempSensor.removeAttachListener(this.attach_listener);
            this.tempSensor.close();
            this.tempSensor = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void thermoTypeCmbActionPerformed(ActionEvent evt) {
        try {
            if (this.thermoTypeCmb.getSelectedItem().equals("K-Type")) {
                this.tempSensor.setThermocoupleType(0, 1);
            } else if (this.thermoTypeCmb.getSelectedItem().equals("J-Type")) {
                this.tempSensor.setThermocoupleType(0, 2);
            } else if (this.thermoTypeCmb.getSelectedItem().equals("E-Type")) {
                this.tempSensor.setThermocoupleType(0, 3);
            } else if (this.thermoTypeCmb.getSelectedItem().equals("T-Type")) {
                this.tempSensor.setThermocoupleType(0, 4);
            }
            this.thermoRngLbl.setText("(" + this.tempSensor.getTemperatureMin(0) + "\u00b0C - " + this.tempSensor.getTemperatureMax(0) + "\u00b0C)");
        }
        catch (PhidgetException ex) {
            this.thermoTypeCmb.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TemperatureSensor().setVisible(true);
            }
        });
    }
}

