/*
 * Decompiled with CFR 0.152.
 */
package MotorControl;

import com.phidgets.MotorControlPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.BackEMFUpdateListener;
import com.phidgets.event.CurrentUpdateListener;
import com.phidgets.event.DetachListener;
import com.phidgets.event.EncoderPositionChangeListener;
import com.phidgets.event.ErrorListener;
import com.phidgets.event.InputChangeListener;
import com.phidgets.event.MotorVelocityChangeListener;
import com.phidgets.event.SensorUpdateListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.MCAttachListener;
import listeners.MCBackEMFUpdateListener;
import listeners.MCCurrentUpdateListener;
import listeners.MCDetachListener;
import listeners.MCEncoderPositionChangeListener;
import listeners.MCErrorListener;
import listeners.MCInputChangeListener;
import listeners.MCSensorUpdateListener;
import listeners.MCVelocityChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class MotorControl
extends JFrame {
    private static String[] runArgs;
    private MotorControlPhidget mc;
    private MCAttachListener attach_listener;
    private MCDetachListener detach_listener;
    private MCErrorListener error_listener;
    private MCCurrentUpdateListener current_listener;
    private MCInputChangeListener input_listener;
    private MCVelocityChangeListener velocity_listener;
    private MCBackEMFUpdateListener backEMF_listener;
    private MCSensorUpdateListener sensor_listener;
    private MCEncoderPositionChangeListener encoder_listener;
    private JCheckBox[] inputArray;
    private JLabel[] sensorLabel;
    private JTextField[] sensorArray;
    private JLabel[] encoderLabel;
    private JTextField[] encoderArray;
    private JPanel inputPanel;
    private JPanel sensorPanel;
    private JPanel encoderPanel;
    private JSlider accelScrl;
    private JTextField accelTxt;
    private JTextField attachedTxt;
    private JCheckBox backEMFChk;
    private JTextField backEMFTxt;
    private JSlider brakeScrl;
    private JTextField brakeTxt;
    private JTextField currentTxt;
    private JTextField encoderTxt0;
    private JCheckBox in0Chk;
    private JCheckBox in1Chk;
    private JCheckBox in2Chk;
    private JCheckBox in3Chk;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JSlider maxVelScrl;
    private JTextField maxVelTxt;
    private JComboBox motorCmb;
    private JTextArea nameTxt;
    private JTextField numEncodersTxt;
    private JTextField numInTxt;
    private JTextField numMotorsTxt;
    private JTextField numSensorsTxt;
    private JCheckBox ratiometricChk;
    private JTextField sensorValTxt0;
    private JTextField sensorValTxt1;
    private JTextField serialTxt;
    private JTextField supplyVoltageTxt;
    private JTextField tarVelTxt;
    private JTextField versionTxt;

    public MotorControl() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numMotorsTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.numInTxt = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.numEncodersTxt = new JTextField();
        this.numSensorsTxt = new JTextField();
        this.jPanel2 = new JPanel();
        this.motorCmb = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.tarVelTxt = new JTextField();
        this.maxVelTxt = new JTextField();
        this.accelTxt = new JTextField();
        this.currentTxt = new JTextField();
        this.maxVelScrl = new JSlider();
        this.accelScrl = new JSlider();
        this.jLabel16 = new JLabel();
        this.brakeTxt = new JTextField();
        this.backEMFChk = new JCheckBox();
        this.jLabel17 = new JLabel();
        this.backEMFTxt = new JTextField();
        this.jLabel18 = new JLabel();
        this.supplyVoltageTxt = new JTextField();
        this.jLabel19 = new JLabel();
        this.brakeScrl = new JSlider();
        this.jPanel3 = new JPanel();
        this.in0Chk = new JCheckBox();
        this.in1Chk = new JCheckBox();
        this.in2Chk = new JCheckBox();
        this.in3Chk = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jLabel20 = new JLabel();
        this.sensorValTxt0 = new JTextField();
        this.jLabel21 = new JLabel();
        this.sensorValTxt1 = new JTextField();
        this.ratiometricChk = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jLabel22 = new JLabel();
        this.encoderTxt0 = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setTitle("MotorControl - full");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                MotorControl.this.formWindowClosed(evt);
            }

            public void windowClosing(WindowEvent evt) {
                MotorControl.this.formWindowClosing(evt);
            }

            public void windowOpened(WindowEvent evt) {
                MotorControl.this.formWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("MotorControl Info"));
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.attachedTxt.setEditable(false);
        this.jPanel1.add((Component)this.attachedTxt, new AbsoluteConstraints(97, 33, 200, -1));
        this.jLabel1.setText("Attached:");
        this.jPanel1.add((Component)this.jLabel1, new AbsoluteConstraints(43, 36, -1, -1));
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.nameTxt.setPreferredSize(new Dimension(200, 58));
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jPanel1.add((Component)this.jScrollPane1, new AbsoluteConstraints(97, 68, 200, -1));
        this.jLabel2.setText("Name:");
        this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(60, 68, -1, -1));
        this.serialTxt.setEditable(false);
        this.jPanel1.add((Component)this.serialTxt, new AbsoluteConstraints(97, 144, 200, -1));
        this.jLabel3.setText("Serial No:");
        this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(41, 147, -1, -1));
        this.versionTxt.setEditable(false);
        this.jPanel1.add((Component)this.versionTxt, new AbsoluteConstraints(97, 180, 200, -1));
        this.jLabel4.setText("Version:");
        this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(48, 180, -1, -1));
        this.numMotorsTxt.setEditable(false);
        this.jPanel1.add((Component)this.numMotorsTxt, new AbsoluteConstraints(97, 216, 65, -1));
        this.jLabel5.setText("Motors:");
        this.jPanel1.add((Component)this.jLabel5, new AbsoluteConstraints(52, 216, -1, -1));
        this.numInTxt.setEditable(false);
        this.jPanel1.add((Component)this.numInTxt, new AbsoluteConstraints(97, 252, 65, -1));
        this.jLabel13.setText("Inputs:");
        this.jPanel1.add((Component)this.jLabel13, new AbsoluteConstraints(54, 252, -1, -1));
        this.jLabel14.setText("Encoders:");
        this.jPanel1.add((Component)this.jLabel14, new AbsoluteConstraints(171, 216, -1, -1));
        this.jLabel15.setText("Sensors:");
        this.jPanel1.add((Component)this.jLabel15, new AbsoluteConstraints(178, 252, -1, -1));
        this.numEncodersTxt.setEditable(false);
        this.jPanel1.add((Component)this.numEncodersTxt, new AbsoluteConstraints(232, 216, 65, -1));
        this.numSensorsTxt.setEditable(false);
        this.jPanel1.add((Component)this.numSensorsTxt, new AbsoluteConstraints(232, 250, 65, -1));
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(10, 11, 330, 290));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Motor Data"));
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.motorCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MotorControl.this.motorCmbActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.motorCmb, new AbsoluteConstraints(107, 30, 190, -1));
        this.jLabel6.setText("Choose Motor:");
        this.jPanel2.add((Component)this.jLabel6, new AbsoluteConstraints(20, 33, -1, -1));
        this.jLabel7.setText("Target Velocity:");
        this.jPanel2.add((Component)this.jLabel7, new AbsoluteConstraints(14, 73, 90, -1));
        this.jLabel8.setText("Current Velocity:");
        this.jPanel2.add((Component)this.jLabel8, new AbsoluteConstraints(9, 110, -1, -1));
        this.jLabel9.setText("Acceleration:");
        this.jPanel2.add((Component)this.jLabel9, new AbsoluteConstraints(28, 140, -1, -1));
        this.jLabel10.setText("Current:");
        this.jPanel2.add((Component)this.jLabel10, new AbsoluteConstraints(170, 73, -1, -1));
        this.jLabel11.setText(" Velocity:");
        this.jPanel2.add((Component)this.jLabel11, new AbsoluteConstraints(53, 214, -1, -1));
        this.jLabel12.setText(" Acceleration:");
        this.jPanel2.add((Component)this.jLabel12, new AbsoluteConstraints(27, 249, -1, -1));
        this.tarVelTxt.setEditable(false);
        this.jPanel2.add((Component)this.tarVelTxt, new AbsoluteConstraints(107, 70, 60, -1));
        this.maxVelTxt.setEditable(false);
        this.jPanel2.add((Component)this.maxVelTxt, new AbsoluteConstraints(107, 105, 60, -1));
        this.accelTxt.setEditable(false);
        this.jPanel2.add((Component)this.accelTxt, new AbsoluteConstraints(107, 141, 60, -1));
        this.currentTxt.setEditable(false);
        this.jPanel2.add((Component)this.currentTxt, new AbsoluteConstraints(220, 70, 75, -1));
        this.maxVelScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MotorControl.this.maxVelScrlStateChanged(evt);
            }
        });
        this.jPanel2.add((Component)this.maxVelScrl, new AbsoluteConstraints(107, 213, 190, -1));
        this.accelScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MotorControl.this.accelScrlStateChanged(evt);
            }
        });
        this.jPanel2.add((Component)this.accelScrl, new AbsoluteConstraints(107, 249, 190, -1));
        this.jLabel16.setText("Braking:");
        this.jPanel2.add((Component)this.jLabel16, new AbsoluteConstraints(56, 180, -1, -1));
        this.brakeTxt.setEditable(false);
        this.jPanel2.add((Component)this.brakeTxt, new AbsoluteConstraints(107, 180, 60, -1));
        this.backEMFChk.setText("Back EMF Sensing");
        this.backEMFChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MotorControl.this.backEMFChkActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.backEMFChk, new AbsoluteConstraints(175, 105, -1, -1));
        this.jLabel17.setText("Back EMF:");
        this.jPanel2.add((Component)this.jLabel17, new AbsoluteConstraints(180, 141, -1, -1));
        this.backEMFTxt.setEditable(false);
        this.jPanel2.add((Component)this.backEMFTxt, new AbsoluteConstraints(240, 141, 56, -1));
        this.jLabel18.setText("Supply Voltage:");
        this.jPanel2.add((Component)this.jLabel18, new AbsoluteConstraints(170, 180, -1, -1));
        this.supplyVoltageTxt.setEditable(false);
        this.supplyVoltageTxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MotorControl.this.supplyVoltageTxtActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.supplyVoltageTxt, new AbsoluteConstraints(260, 180, 36, -1));
        this.jLabel19.setText(" Braking:");
        this.jPanel2.add((Component)this.jLabel19, new AbsoluteConstraints(53, 285, -1, -1));
        this.brakeScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MotorControl.this.brakeScrlStateChanged(evt);
            }
        });
        this.jPanel2.add((Component)this.brakeScrl, new AbsoluteConstraints(107, 285, 190, -1));
        this.getContentPane().add((Component)this.jPanel2, new AbsoluteConstraints(10, 300, 330, 320));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Input Data"));
        this.in0Chk.setText("Input 0");
        this.in0Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in0Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in1Chk.setText("Input 1");
        this.in1Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in1Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in1Chk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MotorControl.this.in1ChkActionPerformed(evt);
            }
        });
        this.in2Chk.setText("Input 2");
        this.in2Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in2Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in3Chk.setText("Input 3");
        this.in3Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in3Chk.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(40, 40, 40).add(this.in0Chk).addPreferredGap(0).add(this.in1Chk).addPreferredGap(0).add(this.in2Chk).addPreferredGap(0).add(this.in3Chk).addContainerGap(44, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(3).add(this.in0Chk).add(this.in1Chk).add(this.in2Chk).add(this.in3Chk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel3, new AbsoluteConstraints(10, 620, 330, 60));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Sensor Data"));
        this.jPanel4.setLayout(new AbsoluteLayout());
        this.jLabel20.setText("0");
        this.jPanel4.add((Component)this.jLabel20, new AbsoluteConstraints(15, 35, -1, -1));
        this.sensorValTxt0.setEditable(false);
        this.jPanel4.add((Component)this.sensorValTxt0, new AbsoluteConstraints(30, 32, 60, -1));
        this.jLabel21.setText("1");
        this.jPanel4.add((Component)this.jLabel21, new AbsoluteConstraints(100, 35, -1, -1));
        this.sensorValTxt1.setEditable(false);
        this.jPanel4.add((Component)this.sensorValTxt1, new AbsoluteConstraints(120, 32, 60, -1));
        this.ratiometricChk.setText("Ratiometric");
        this.ratiometricChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MotorControl.this.ratiometricChkActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.ratiometricChk, new AbsoluteConstraints(200, 32, -1, -1));
        this.getContentPane().add((Component)this.jPanel4, new AbsoluteConstraints(10, 760, 330, 70));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Encoder Data"));
        this.jPanel5.setLayout(new AbsoluteLayout());
        this.jLabel22.setText("Position:");
        this.jPanel5.add((Component)this.jLabel22, new AbsoluteConstraints(18, 36, -1, -1));
        this.encoderTxt0.setEditable(false);
        this.jPanel5.add((Component)this.encoderTxt0, new AbsoluteConstraints(63, 33, 60, -1));
        this.getContentPane().add((Component)this.jPanel5, new AbsoluteConstraints(10, 690, 330, 70));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        int i;
        this.setSize(357, 670);
        this.inputArray = new JCheckBox[4];
        this.inputArray[0] = this.in0Chk;
        this.inputArray[1] = this.in1Chk;
        this.inputArray[2] = this.in2Chk;
        this.inputArray[3] = this.in3Chk;
        this.inputPanel = this.jPanel3;
        this.inputPanel.setVisible(false);
        for (i = 0; i < 4; ++i) {
            this.inputArray[i].setVisible(false);
            this.inputArray[i].setEnabled(false);
        }
        this.sensorPanel = this.jPanel4;
        this.sensorPanel.setVisible(false);
        this.sensorLabel = new JLabel[2];
        this.sensorLabel[0] = this.jLabel20;
        this.sensorLabel[1] = this.jLabel21;
        this.sensorArray = new JTextField[2];
        this.sensorArray[0] = this.sensorValTxt0;
        this.sensorArray[1] = this.sensorValTxt1;
        for (i = 0; i < 2; ++i) {
            this.sensorLabel[i].setVisible(false);
            this.sensorArray[i].setVisible(false);
            this.sensorArray[i].setEnabled(false);
        }
        this.ratiometricChk.setVisible(false);
        this.ratiometricChk.setEnabled(false);
        this.encoderPanel = this.jPanel5;
        this.encoderPanel.setVisible(false);
        this.encoderLabel = new JLabel[1];
        this.encoderLabel[0] = this.jLabel22;
        this.encoderArray = new JTextField[1];
        this.encoderArray[0] = this.encoderTxt0;
        for (i = 0; i < 1; ++i) {
            this.encoderLabel[i].setVisible(false);
            this.encoderArray[i].setVisible(false);
            this.encoderArray[i].setEnabled(false);
        }
        this.motorCmb.setEnabled(false);
        this.maxVelScrl.setEnabled(false);
        this.accelScrl.setEnabled(false);
        this.jLabel16.setEnabled(false);
        this.brakeTxt.setEnabled(false);
        this.jLabel19.setEnabled(false);
        this.brakeScrl.setEnabled(false);
        this.jLabel10.setEnabled(false);
        this.currentTxt.setEnabled(false);
        this.backEMFChk.setEnabled(false);
        this.jLabel17.setEnabled(false);
        this.backEMFTxt.setEnabled(false);
        this.jLabel18.setEnabled(false);
        this.supplyVoltageTxt.setEnabled(false);
        try {
            this.mc = new MotorControlPhidget();
            this.attach_listener = new MCAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numMotorsTxt, this.numInTxt, this.numEncodersTxt, this.numSensorsTxt, this.tarVelTxt, this.maxVelTxt, this.accelTxt, this.jLabel10, this.currentTxt, this.motorCmb, this.maxVelScrl, this.accelScrl, this.brakeScrl, this.inputArray, this.brakeTxt, this.jLabel16, this.supplyVoltageTxt, this.jLabel18, this.backEMFChk, this.backEMFTxt, this.jLabel17, this.sensorLabel, this.sensorArray, this.encoderLabel, this.encoderArray, this.jLabel19, this.inputPanel, this.sensorPanel, this.encoderPanel, this.ratiometricChk);
            this.detach_listener = new MCDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numMotorsTxt, this.numInTxt, this.numEncodersTxt, this.numSensorsTxt, this.tarVelTxt, this.maxVelTxt, this.accelTxt, this.jLabel10, this.currentTxt, this.motorCmb, this.maxVelScrl, this.accelScrl, this.brakeScrl, this.inputArray, this.brakeTxt, this.jLabel16, this.supplyVoltageTxt, this.jLabel18, this.backEMFChk, this.backEMFTxt, this.jLabel17, this.sensorLabel, this.sensorArray, this.encoderLabel, this.encoderArray, this.jLabel19, this.inputPanel, this.sensorPanel, this.encoderPanel, this.ratiometricChk);
            this.error_listener = new MCErrorListener(this);
            this.current_listener = new MCCurrentUpdateListener(this.currentTxt, this.motorCmb);
            this.input_listener = new MCInputChangeListener(this.inputArray);
            this.velocity_listener = new MCVelocityChangeListener(this.mc, this, this.maxVelTxt, this.motorCmb);
            this.backEMF_listener = new MCBackEMFUpdateListener(this.backEMFTxt, this.backEMFChk, this.motorCmb);
            this.sensor_listener = new MCSensorUpdateListener(this.sensorArray, this.motorCmb);
            this.encoder_listener = new MCEncoderPositionChangeListener(this.encoderArray, this.motorCmb);
            this.mc.addAttachListener((AttachListener)this.attach_listener);
            this.mc.addDetachListener((DetachListener)this.detach_listener);
            this.mc.addErrorListener((ErrorListener)this.error_listener);
            this.mc.addCurrentUpdateListener((CurrentUpdateListener)this.current_listener);
            this.mc.addInputChangeListener((InputChangeListener)this.input_listener);
            this.mc.addMotorVelocityChangeListener((MotorVelocityChangeListener)this.velocity_listener);
            this.mc.addBackEMFUpdateListener((BackEMFUpdateListener)this.backEMF_listener);
            this.mc.addSensorUpdateListener((SensorUpdateListener)this.sensor_listener);
            this.mc.addEncoderPositionChangeListener((EncoderPositionChangeListener)this.encoder_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.mc.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                this.mc.open(Integer.parseInt(runArgs[0]));
            } else {
                this.mc.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void motorCmbActionPerformed(ActionEvent evt) {
        if (this.motorCmb.isEnabled()) {
            try {
                this.maxVelScrl.setValue((int)this.mc.getVelocity(((Integer)this.motorCmb.getSelectedItem()).intValue()));
                this.tarVelTxt.setText(Integer.toString(this.maxVelScrl.getValue()));
                this.maxVelTxt.setText(Integer.toString(this.maxVelScrl.getValue()));
            }
            catch (PhidgetException ex) {
                this.maxVelScrl.setValue(0);
                this.tarVelTxt.setText("");
                this.maxVelTxt.setText(Integer.toString(this.maxVelScrl.getValue()));
            }
            try {
                this.accelScrl.setValue((int)this.mc.getAcceleration(((Integer)this.motorCmb.getSelectedItem()).intValue()));
                this.accelTxt.setText(Double.toString(this.mc.getAcceleration(((Integer)this.motorCmb.getSelectedItem()).intValue())));
            }
            catch (PhidgetException e) {
                this.accelScrl.setValue(this.accelScrl.getMinimum());
                this.accelTxt.setText(Integer.toString(this.accelScrl.getValue()));
            }
            if (this.currentTxt.isEnabled()) {
                try {
                    this.currentTxt.setText(Double.toString(this.mc.getCurrent(((Integer)this.motorCmb.getSelectedItem()).intValue())));
                }
                catch (PhidgetException e) {
                    this.currentTxt.setText("");
                }
            }
            if (this.backEMFChk.isEnabled()) {
                try {
                    this.backEMFChk.setSelected(this.mc.getBackEMFSensingState(((Integer)this.motorCmb.getSelectedItem()).intValue()));
                    if (this.backEMFChk.isSelected()) {
                        this.backEMFTxt.setText(Double.toString(((Integer)this.motorCmb.getSelectedItem()).intValue()));
                    }
                }
                catch (PhidgetException e) {
                    this.backEMFChk.setSelected(false);
                    this.backEMFTxt.setText("Unknown");
                }
            }
            if (this.brakeTxt.isEnabled()) {
                try {
                    this.brakeTxt.setText(Double.toString(this.mc.getBraking(((Integer)this.motorCmb.getSelectedItem()).intValue())));
                    this.brakeScrl.setValue((int)this.mc.getBraking(((Integer)this.motorCmb.getSelectedItem()).intValue()));
                }
                catch (PhidgetException e) {
                    this.brakeTxt.setText("");
                    this.brakeScrl.setValue(this.brakeScrl.getMinimum());
                }
            }
            if (this.supplyVoltageTxt.isEnabled()) {
                try {
                    this.supplyVoltageTxt.setText(Double.toString(this.mc.getSupplyVoltage()));
                }
                catch (PhidgetException e) {
                    this.supplyVoltageTxt.setText("");
                }
            }
        }
    }

    private void maxVelScrlStateChanged(ChangeEvent evt) {
        if (this.maxVelScrl.isEnabled()) {
            try {
                this.mc.setVelocity(((Integer)this.motorCmb.getSelectedItem()).intValue(), (double)this.maxVelScrl.getValue());
                this.tarVelTxt.setText(Integer.toString(this.maxVelScrl.getValue()));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
                this.attachedTxt.setText("false");
                this.nameTxt.setText("");
                this.serialTxt.setText("");
                this.versionTxt.setText("");
                this.numMotorsTxt.setText("");
                this.numInTxt.setText("");
                this.tarVelTxt.setText("");
                this.accelTxt.setText("");
                this.jLabel10.setVisible(false);
                this.currentTxt.setText("");
                this.currentTxt.setVisible(false);
                this.motorCmb.setSelectedIndex(0);
                this.motorCmb.removeAllItems();
                this.motorCmb.setEnabled(false);
                for (int i = 0; i < 4; ++i) {
                    this.inputArray[i].setVisible(false);
                }
                this.maxVelScrl.setEnabled(false);
                this.accelScrl.setEnabled(false);
            }
        }
    }

    private void accelScrlStateChanged(ChangeEvent evt) {
        if (this.accelScrl.isEnabled()) {
            try {
                this.mc.setAcceleration(((Integer)this.motorCmb.getSelectedItem()).intValue(), (double)this.accelScrl.getValue());
                this.accelTxt.setText(Integer.toString(this.accelScrl.getValue()));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
                this.attachedTxt.setText("false");
                this.nameTxt.setText("");
                this.serialTxt.setText("");
                this.versionTxt.setText("");
                this.numMotorsTxt.setText("");
                this.numInTxt.setText("");
                this.tarVelTxt.setText("");
                this.accelTxt.setText("");
                this.jLabel10.setVisible(false);
                this.currentTxt.setText("");
                this.currentTxt.setVisible(false);
                this.motorCmb.setSelectedIndex(0);
                this.motorCmb.removeAllItems();
                this.motorCmb.setEnabled(false);
                for (int i = 0; i < 4; ++i) {
                    this.inputArray[i].setVisible(false);
                }
                this.maxVelScrl.setEnabled(false);
                this.accelScrl.setEnabled(false);
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            this.mc.removeMotorVelocityChangeListener((MotorVelocityChangeListener)this.velocity_listener);
            this.mc.removeInputChangeListener((InputChangeListener)this.input_listener);
            this.mc.removeCurrentUpdateListener((CurrentUpdateListener)this.current_listener);
            this.mc.removeErrorListener((ErrorListener)this.error_listener);
            this.mc.removeDetachListener((DetachListener)this.detach_listener);
            this.mc.removeAttachListener((AttachListener)this.attach_listener);
            this.mc.removeBackEMFUpdateListener((BackEMFUpdateListener)this.backEMF_listener);
            this.mc.removeSensorUpdateListener((SensorUpdateListener)this.sensor_listener);
            this.mc.removeEncoderPositionChangeListener((EncoderPositionChangeListener)this.encoder_listener);
            for (int i = 0; i < this.mc.getMotorCount(); ++i) {
                this.mc.setVelocity(i, 0.0);
            }
            this.mc.close();
            this.mc = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void brakeScrlStateChanged(ChangeEvent evt) {
        if (this.brakeScrl.isEnabled()) {
            try {
                this.mc.setBraking(((Integer)this.motorCmb.getSelectedItem()).intValue(), (double)this.brakeScrl.getValue());
                this.brakeTxt.setText(Integer.toString(this.brakeScrl.getValue()));
            }
            catch (PhidgetException phidgetException) {
                // empty catch block
            }
        }
    }

    private void backEMFChkStateChanged(ChangeEvent evt) {
    }

    private void backEMFChkActionPerformed(ActionEvent evt) {
        JCheckBox outputChk = (JCheckBox)evt.getSource();
        try {
            if (outputChk.isEnabled()) {
                this.mc.setBackEMFSensingState(0, this.backEMFChk.isSelected());
                if (!this.backEMFChk.isSelected()) {
                    this.backEMFTxt.setText("Unknown");
                }
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void supplyVoltageTxtActionPerformed(ActionEvent evt) {
    }

    private void ratiometricChkActionPerformed(ActionEvent evt) {
        JCheckBox chk = (JCheckBox)evt.getSource();
        try {
            if (chk.isEnabled()) {
                this.mc.setRatiometric(this.ratiometricChk.isSelected());
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void in1ChkActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MotorControl().setVisible(true);
            }
        });
    }
}

