/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class MagFieldGraphPanel
extends JPanel {
    private BufferedImage buffImage = null;
    private double boundsWidth;
    private double boundsHeight;
    private double circleDiameter;
    private double circleRadius;
    private double xCenter;
    private double yCenter;
    private double xOld;
    private double yOld;
    private double xOut;
    private double yOut;
    private double zOut;
    private boolean compassAxesExist = false;
    private boolean Exist = false;
    private Ellipse2D.Double oneGCircle;

    public MagFieldGraphPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Magnetic Field Vector"));
        this.setPreferredSize(new Dimension(317, 317));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.buffImage == null) {
            this.buffImage = (BufferedImage)this.createImage((int)(this.getBounds().getWidth() - 2.0), (int)(this.getBounds().getHeight() - 2.0));
            this.boundsWidth = this.buffImage.getWidth();
            this.boundsHeight = this.buffImage.getHeight();
            this.xCenter = this.boundsWidth / 2.0;
            this.yCenter = this.boundsHeight / 2.0;
            this.xOld = this.xCenter;
            this.yOld = this.yCenter;
            this.circleDiameter = this.boundsWidth / 2.0;
            this.circleRadius = this.circleDiameter / 2.0;
            this.oneGCircle = new Ellipse2D.Double(this.xCenter - this.circleRadius, this.yCenter - this.circleRadius, this.circleDiameter, this.circleDiameter);
        }
        Graphics2D g2d = (Graphics2D)g;
        Graphics2D drawer = this.buffImage.createGraphics();
        RenderingHints drawerHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        drawerHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        drawer.setRenderingHints(drawerHints);
        drawer.clearRect(0, 0, (int)this.boundsWidth, (int)this.boundsHeight);
        drawer.setColor(Color.BLUE);
        drawer.draw(this.oneGCircle);
        this.xOld = this.xCenter + this.xOut * this.circleRadius;
        this.yOld = this.yCenter + this.yOut * this.circleRadius;
        drawer.setColor(Color.BLACK);
        drawer.draw(new Line2D.Double(this.xCenter, this.yCenter, this.xOld, this.yOld));
        if (this.compassAxesExist) {
            if (this.zOut > 0.0) {
                drawer.setColor(Color.RED);
                drawer.draw(new Ellipse2D.Double(this.xCenter - this.circleRadius * this.zOut, this.yCenter - this.circleRadius * this.zOut, this.circleDiameter * this.zOut, this.circleDiameter * this.zOut));
            } else {
                drawer.setColor(Color.GREEN);
                drawer.draw(new Ellipse2D.Double(this.xCenter - this.circleRadius * -this.zOut, this.yCenter - this.circleRadius * -this.zOut, this.circleDiameter * -this.zOut, this.circleDiameter * -this.zOut));
            }
        }
        g2d.drawImage(this.buffImage, null, 1, 1);
    }

    public double getXOut() {
        return this.xOut;
    }

    public void setXOut(double xOut) {
        this.xOut = xOut;
    }

    public double getYOut() {
        return this.yOut;
    }

    public void setYOut(double yOut) {
        this.yOut = yOut;
    }

    public double getZOut() {
        return this.zOut;
    }

    public void setZOut(double zOut) {
        this.zOut = zOut;
    }

    public boolean isCompassAxesExist() {
        return this.compassAxesExist;
    }

    public void setCompassAxesExist(boolean compassAxesExist) {
        this.compassAxesExist = compassAxesExist;
    }

    public boolean isExist() {
        return this.Exist;
    }

    public void setExist(boolean Exist) {
        this.Exist = Exist;
    }
}

