/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class GyroGraphPanel
extends JPanel {
    private BufferedImage buffImage = null;
    private double boundsWidth;
    private double boundsHeight;
    private double[] circleDiameter = new double[]{0.0, 0.0, 0.0};
    private double[] circleRadius = new double[]{0.0, 0.0, 0.0};
    private double xCenter;
    private double yCenter;
    private double xOld;
    private double yOld;
    private double xOut;
    private double yOut;
    private double zOut;
    private boolean Exist = false;
    private Ellipse2D.Double[] oneGCircle = new Ellipse2D.Double[]{new Ellipse2D.Double(), new Ellipse2D.Double(), new Ellipse2D.Double()};
    private Color[] circlePen = new Color[]{Color.WHITE, Color.WHITE, Color.WHITE};

    public GyroGraphPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Gyroscope Headings"));
        this.setPreferredSize(new Dimension(317, 317));
    }

    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        if (this.buffImage == null) {
            this.buffImage = (BufferedImage)this.createImage((int)(this.getBounds().getWidth() - 2.0), (int)(this.getBounds().getHeight() - 2.0));
            this.boundsWidth = this.buffImage.getWidth();
            this.boundsHeight = this.buffImage.getHeight();
            this.xCenter = this.boundsWidth / 2.0;
            this.yCenter = this.boundsHeight / 2.0;
            this.circlePen[0] = Color.RED;
            this.circlePen[1] = Color.GREEN;
            this.circlePen[2] = Color.BLUE;
            this.circleDiameter[0] = this.boundsHeight / 1.5;
            this.circleDiameter[1] = this.boundsHeight / 1.6;
            this.circleDiameter[2] = this.boundsHeight / 1.714;
            for (i = 0; i < 3; ++i) {
                this.circleRadius[i] = this.circleDiameter[i] / 2.0;
                this.oneGCircle[i] = new Ellipse2D.Double(this.xCenter - this.circleRadius[i], this.yCenter - this.circleRadius[i], this.circleDiameter[i], this.circleDiameter[i]);
            }
        }
        Graphics2D g2d = (Graphics2D)g;
        Graphics2D drawer = this.buffImage.createGraphics();
        RenderingHints drawerHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        drawerHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        drawer.setRenderingHints(drawerHints);
        drawer.clearRect(0, 0, (int)this.boundsWidth, (int)this.boundsHeight);
        for (i = 0; i < 3; ++i) {
            drawer.setColor(Color.BLACK);
            drawer.draw(this.oneGCircle[i]);
        }
        drawer.setColor(Color.RED);
        drawer.draw(new Ellipse2D.Double(this.circleRadius[0] * Math.cos(this.xOut * (Math.PI / 180)) + this.xCenter - 2.0, -this.circleRadius[0] * Math.sin(this.xOut * (Math.PI / 180)) + this.yCenter - 2.0, 4.0, 4.0));
        drawer.fillOval((int)(this.circleRadius[0] * Math.cos(this.xOut * (Math.PI / 180)) + this.xCenter - 2.0), (int)(-this.circleRadius[0] * Math.sin(this.xOut * (Math.PI / 180)) + this.yCenter - 2.0), 4, 4);
        drawer.setColor(Color.GREEN);
        drawer.draw(new Ellipse2D.Double(this.circleRadius[1] * Math.cos(this.yOut * (Math.PI / 180)) + this.xCenter - 2.0, -this.circleRadius[1] * Math.sin(this.yOut * (Math.PI / 180)) + this.yCenter - 2.0, 4.0, 4.0));
        drawer.fillOval((int)(this.circleRadius[1] * Math.cos(this.yOut * (Math.PI / 180)) + this.xCenter - 2.0), (int)(-this.circleRadius[1] * Math.sin(this.yOut * (Math.PI / 180)) + this.yCenter - 2.0), 4, 4);
        drawer.setColor(Color.BLUE);
        drawer.draw(new Ellipse2D.Double(this.circleRadius[2] * Math.cos(this.zOut * (Math.PI / 180)) + this.xCenter - 2.0, -this.circleRadius[2] * Math.sin(this.zOut * (Math.PI / 180)) + this.yCenter - 2.0, 4.0, 4.0));
        drawer.fillOval((int)(this.circleRadius[2] * Math.cos(this.zOut * (Math.PI / 180)) + this.xCenter - 2.0), (int)(-this.circleRadius[2] * Math.sin(this.zOut * (Math.PI / 180)) + this.yCenter - 2.0), 4, 4);
        g2d.drawImage(this.buffImage, null, 1, 1);
    }

    public double getXOut() {
        return this.xOut;
    }

    public void setXOut(double xOut) {
        this.xOut = xOut;
    }

    public double getYOut() {
        return this.yOut;
    }

    public void setYOut(double yOut) {
        this.yOut = yOut;
    }

    public double getZOut() {
        return this.zOut;
    }

    public void setZOut(double zOut) {
        this.zOut = zOut;
    }

    public boolean isExist() {
        return this.Exist;
    }

    public void setExist(boolean Exist) {
        this.Exist = Exist;
    }
}

