/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class CompassBearingGraphPanel
extends JPanel {
    private BufferedImage buffImage = null;
    private double boundsWidth;
    private double boundsHeight;
    private double circleDiameter;
    private double circleRadius;
    private double xCenter;
    private double yCenter;
    private double xOld;
    private double yOld;
    private double xOut;
    private double yOut;
    private double zOut;
    private double compassBearing;
    private boolean compassAxesExist = false;
    private boolean Exist = false;
    private Ellipse2D.Double oneGCircle;

    public CompassBearingGraphPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Compass Bearing"));
        this.setPreferredSize(new Dimension(317, 317));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.buffImage == null) {
            this.buffImage = (BufferedImage)this.createImage((int)(this.getBounds().getWidth() - 2.0), (int)(this.getBounds().getHeight() - 2.0));
            this.boundsWidth = this.buffImage.getWidth();
            this.boundsHeight = this.buffImage.getHeight();
            this.xCenter = this.boundsWidth / 2.0;
            this.yCenter = this.boundsHeight / 2.0;
            this.circleDiameter = this.boundsWidth / 2.0;
            this.circleRadius = this.circleDiameter / 2.0;
            this.oneGCircle = new Ellipse2D.Double(this.xCenter - this.circleRadius, this.yCenter - this.circleRadius, this.circleDiameter, this.circleDiameter);
        }
        Graphics2D g2d = (Graphics2D)g;
        Graphics2D drawer = this.buffImage.createGraphics();
        RenderingHints drawerHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        drawerHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        drawer.setRenderingHints(drawerHints);
        drawer.clearRect(0, 0, (int)this.boundsWidth, (int)this.boundsHeight);
        drawer.setColor(Color.BLACK);
        drawer.draw(this.oneGCircle);
        drawer.drawString("N", (int)(this.xCenter - 4.0), (int)(this.yCenter - this.circleRadius - 6.0));
        drawer.drawString("E", (int)this.xCenter + (int)(this.circleRadius + 6.0), (int)(this.yCenter + 4.0));
        drawer.drawString("S", (int)(this.xCenter - 4.0), (int)(this.yCenter + this.circleRadius + 16.0));
        drawer.drawString("W", (int)(this.xCenter - this.circleRadius - 16.0), (int)(this.yCenter + 6.0));
        for (int i = 0; i < 360; i += 10) {
            int tickSize = 4;
            if (i == 0 || i == 90 || i == 180 || i == 270) {
                tickSize = 72;
            }
            drawer.draw(new Line2D.Double((this.circleRadius + (double)tickSize) * Math.cos((double)i * (Math.PI / 180)) + this.xCenter, -(this.circleRadius + (double)tickSize) * Math.sin((double)i * (Math.PI / 180)) + this.yCenter, (this.circleRadius - (double)tickSize) * Math.cos((double)i * (Math.PI / 180)) + this.xCenter, -(this.circleRadius - (double)tickSize) * Math.sin((double)i * (Math.PI / 180)) + this.yCenter));
        }
        drawer.setColor(Color.RED);
        drawer.draw(new Ellipse2D.Double(this.circleRadius * Math.cos((-this.compassBearing + 90.0) * (Math.PI / 180)) + this.xCenter - 2.0, -this.circleRadius * Math.sin((-this.compassBearing + 90.0) * (Math.PI / 180)) + this.yCenter - 2.0, 4.0, 4.0));
        drawer.fillOval((int)(this.circleRadius * Math.cos((-this.compassBearing + 90.0) * (Math.PI / 180)) + this.xCenter - 2.0), (int)(-this.circleRadius * Math.sin((-this.compassBearing + 90.0) * (Math.PI / 180)) + this.yCenter - 2.0), 4, 4);
        g2d.drawImage(this.buffImage, null, 1, 1);
    }

    public double getCompassBearing() {
        return this.compassBearing;
    }

    public void setCompassBearing(double compassBearing) {
        this.compassBearing = compassBearing;
    }

    public boolean isExist() {
        return this.Exist;
    }

    public void setExist(boolean Exist) {
        this.Exist = Exist;
    }
}

