/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.TextLCDPhidget;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import misc.TextFieldLimiter;

public class LCDAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField dispTxt1;
    private JTextField dispTxt2;
    private JTextField dispTxt3;
    private JTextField dispTxt4;
    private JCheckBox backlightChk;
    private JCheckBox cursorChk;
    private JCheckBox blinkChk;
    private JCheckBox customChk;
    private JSlider contrastSlide;
    private JSlider brightnessSlide;
    private JComboBox screenCmb;
    private JComboBox screenSizeCmb;
    private JButton initializeBtn;
    private Hashtable screenSizeHashTable;

    public LCDAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField dispTxt1, JTextField dispTxt2, JTextField dispTxt3, JTextField dispTxt4, JCheckBox backlightChk, JCheckBox cursorChk, JCheckBox blinkChk, JCheckBox customChk, JSlider contrastSlide, JSlider brightnessSlide, JComboBox screenCmb, JComboBox screenSizeCmb, JButton initializeBtn, Hashtable screenSizeHashTable) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.dispTxt1 = dispTxt1;
        this.dispTxt2 = dispTxt2;
        this.dispTxt3 = dispTxt3;
        this.dispTxt4 = dispTxt4;
        this.backlightChk = backlightChk;
        this.cursorChk = cursorChk;
        this.blinkChk = blinkChk;
        this.customChk = customChk;
        this.contrastSlide = contrastSlide;
        this.brightnessSlide = brightnessSlide;
        this.screenCmb = screenCmb;
        this.screenSizeCmb = screenSizeCmb;
        this.initializeBtn = initializeBtn;
        this.screenSizeHashTable = screenSizeHashTable;
    }

    public void attached(AttachEvent ae) {
        try {
            TextLCDPhidget attached = (TextLCDPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            if (attached.getDeviceID() == 61) {
                this.dispTxt1.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                this.dispTxt1.setEnabled(true);
                this.dispTxt1.setEditable(true);
                this.dispTxt2.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                this.dispTxt2.setEnabled(true);
                this.dispTxt2.setEditable(true);
                this.dispTxt3.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                this.dispTxt3.setEnabled(true);
                this.dispTxt3.setEditable(true);
                this.dispTxt4.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                this.dispTxt4.setEnabled(true);
                this.dispTxt4.setEditable(true);
                this.screenCmb.setEnabled(true);
                for (int i = 0; i < attached.getScreenCount(); ++i) {
                    this.screenCmb.addItem(new Integer(i));
                }
                this.screenCmb.setSelectedItem(0);
                this.screenSizeCmb.setEnabled(true);
                TreeSet sortedKeys = new TreeSet(this.screenSizeHashTable.keySet());
                for (String sortedKey : sortedKeys) {
                    this.screenSizeCmb.addItem(sortedKey);
                }
                this.screenSizeCmb.setSelectedItem("Unknown");
                this.brightnessSlide.setEnabled(true);
                this.brightnessSlide.setMaximum(255);
                this.brightnessSlide.setMinimum(0);
                this.brightnessSlide.setValue(attached.getBrightness());
            } else {
                this.dispTxt1.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                this.dispTxt1.setEnabled(true);
                this.dispTxt1.setEditable(true);
                this.dispTxt2.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                this.dispTxt2.setEnabled(true);
                this.dispTxt2.setEditable(true);
            }
            if (attached.getDeviceID() == 381 && attached.getDeviceVersion() >= 200) {
                this.brightnessSlide.setEnabled(true);
                this.brightnessSlide.setMaximum(255);
                this.brightnessSlide.setMinimum(0);
                this.brightnessSlide.setValue(attached.getBrightness());
            }
            this.backlightChk.setEnabled(true);
            try {
                this.backlightChk.setSelected(attached.getBacklight());
            }
            catch (PhidgetException backlightE) {
                // empty catch block
            }
            this.cursorChk.setEnabled(true);
            this.blinkChk.setEnabled(true);
            try {
                this.cursorChk.setSelected(attached.getCursor());
                this.blinkChk.setSelected(attached.getCursorBlink());
            }
            catch (PhidgetException cursorE) {
                // empty catch block
            }
            this.customChk.setEnabled(true);
            this.contrastSlide.setEnabled(true);
            this.contrastSlide.setMaximum(255);
            this.contrastSlide.setMinimum(0);
            this.contrastSlide.setValue(attached.getContrast());
            this.initializeBtn.setEnabled(true);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

