/*
 * Decompiled with CFR 0.152.
 */
package TextLCD;

import com.phidgets.PhidgetException;
import com.phidgets.TextLCDPhidget;
import com.phidgets.event.AttachListener;
import com.phidgets.event.DetachListener;
import com.phidgets.event.ErrorListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.LCDAttachListener;
import listeners.LCDDetachListener;
import listeners.LCDErrorListener;
import misc.TextFieldLimiter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class TextLCD
extends JFrame {
    private static String[] runArgs;
    private TextLCDPhidget lcd;
    private Hashtable screenSizeHashTable;
    private final int maxColumnSize = 40;
    private int currScreen;
    private String[][] textOriginals = new String[40][40];
    private LCDAttachListener attach_listener;
    private LCDDetachListener detach_listener;
    private LCDErrorListener error_listener;
    private JTextField attachedTxt;
    private JCheckBox backlightChk;
    private JCheckBox blinkChk;
    private JSlider brightnessSlide;
    private JSlider contrastSlide;
    private JCheckBox cursorChk;
    private JCheckBox customChk;
    private JTextField dispTxt1;
    private JTextField dispTxt2;
    private JTextField dispTxt3;
    private JTextField dispTxt4;
    private JButton initializeBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JComboBox screenCmb;
    private JComboBox screenSizeCmb;
    private JTextField serialTxt;
    private JTextField versionTxt;

    public TextLCD() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.attachedTxt = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.serialTxt = new JTextField();
        this.versionTxt = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.dispTxt1 = new JTextField();
        this.dispTxt2 = new JTextField();
        this.initializeBtn = new JButton();
        this.backlightChk = new JCheckBox();
        this.cursorChk = new JCheckBox();
        this.blinkChk = new JCheckBox();
        this.customChk = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.contrastSlide = new JSlider();
        this.jLabel7 = new JLabel();
        this.brightnessSlide = new JSlider();
        this.jLabel8 = new JLabel();
        this.screenCmb = new JComboBox();
        this.screenSizeCmb = new JComboBox();
        this.jLabel9 = new JLabel();
        this.dispTxt3 = new JTextField();
        this.dispTxt4 = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setTitle("TextLCD - full");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                TextLCD.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                TextLCD.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Device Info"));
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel1.setText("Attached:");
        this.jPanel1.add((Component)this.jLabel1, new AbsoluteConstraints(18, 36, -1, -1));
        this.jLabel2.setText("Name:");
        this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(18, 61, -1, -1));
        this.jLabel3.setText("Serial No:");
        this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(18, 138, -1, -1));
        this.jLabel4.setText("Version:");
        this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(18, 164, -1, -1));
        this.attachedTxt.setEditable(false);
        this.jPanel1.add((Component)this.attachedTxt, new AbsoluteConstraints(72, 33, 172, -1));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextArea.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(2);
        this.nameTxt.setTabSize(2);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jPanel1.add((Component)this.jScrollPane1, new AbsoluteConstraints(72, 61, 172, 63));
        this.serialTxt.setEditable(false);
        this.jPanel1.add((Component)this.serialTxt, new AbsoluteConstraints(72, 135, 172, -1));
        this.versionTxt.setEditable(false);
        this.jPanel1.add((Component)this.versionTxt, new AbsoluteConstraints(72, 161, 172, -1));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("LCD Control"));
        this.jPanel2.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel5.setText("Display Text:");
        this.jPanel2.add((Component)this.jLabel5, new AbsoluteConstraints(20, 107, -1, -1));
        this.dispTxt1.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                TextLCD.this.dispTxt1KeyReleased(evt);
            }
        });
        this.jPanel2.add((Component)this.dispTxt1, new AbsoluteConstraints(50, 140, 190, -1));
        this.dispTxt2.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                TextLCD.this.dispTxt2KeyReleased(evt);
            }
        });
        this.jPanel2.add((Component)this.dispTxt2, new AbsoluteConstraints(50, 170, 190, -1));
        this.initializeBtn.setText("Initialize");
        this.initializeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.initializeBtnActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.initializeBtn, new AbsoluteConstraints(160, 104, -1, -1));
        this.backlightChk.setText("Backlight");
        this.backlightChk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.backlightChk.setMargin(new Insets(0, 0, 0, 0));
        this.backlightChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.backlightChkActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.backlightChk, new AbsoluteConstraints(50, 260, -1, -1));
        this.cursorChk.setText("Cursor");
        this.cursorChk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cursorChk.setMargin(new Insets(0, 0, 0, 0));
        this.cursorChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.cursorChkActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.cursorChk, new AbsoluteConstraints(50, 290, -1, -1));
        this.blinkChk.setText("Cursor Blink");
        this.blinkChk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.blinkChk.setMargin(new Insets(0, 0, 0, 0));
        this.blinkChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.blinkChkActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.blinkChk, new AbsoluteConstraints(120, 260, -1, -1));
        this.customChk.setText("Custom Characters");
        this.customChk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.customChk.setMargin(new Insets(0, 0, 0, 0));
        this.customChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.customChkActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.customChk, new AbsoluteConstraints(120, 290, -1, -1));
        this.jLabel6.setText("Contrast:");
        this.jPanel2.add((Component)this.jLabel6, new AbsoluteConstraints(20, 320, -1, -1));
        this.contrastSlide.setPaintTicks(true);
        this.contrastSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TextLCD.this.contrastSlideStateChanged(evt);
            }
        });
        this.jPanel2.add((Component)this.contrastSlide, new AbsoluteConstraints(50, 340, 190, -1));
        this.jLabel7.setText("Brightness:");
        this.jPanel2.add((Component)this.jLabel7, new AbsoluteConstraints(20, 380, -1, -1));
        this.brightnessSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TextLCD.this.brightnessSlideStateChanged(evt);
            }
        });
        this.jPanel2.add((Component)this.brightnessSlide, new AbsoluteConstraints(50, 400, 190, -1));
        this.jLabel8.setText("Screen:");
        this.jPanel2.add((Component)this.jLabel8, new AbsoluteConstraints(20, 42, -1, -1));
        this.screenCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.screenCmbActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.screenCmb, new AbsoluteConstraints(100, 40, 140, -1));
        this.screenSizeCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.screenSizeCmbActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.screenSizeCmb, new AbsoluteConstraints(100, 70, 140, -1));
        this.jLabel9.setText("Screen Size:");
        this.jPanel2.add((Component)this.jLabel9, new AbsoluteConstraints(20, 72, -1, -1));
        this.dispTxt3.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                TextLCD.this.dispTxt3KeyReleased(evt);
            }
        });
        this.jPanel2.add((Component)this.dispTxt3, new AbsoluteConstraints(50, 200, 190, -1));
        this.dispTxt4.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                TextLCD.this.dispTxt4KeyReleased(evt);
            }
        });
        this.jPanel2.add((Component)this.dispTxt4, new AbsoluteConstraints(50, 230, 190, -1));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(2, this.jPanel2, -1, 262, Short.MAX_VALUE).add(2, this.jPanel1, -1, 262, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, 193, -2).addPreferredGap(0).add(this.jPanel2, -2, 433, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        try {
            this.lcd = new TextLCDPhidget();
            this.screenSizeHashTable = new Hashtable();
            this.screenSizeHashTable.put("None", 1);
            this.screenSizeHashTable.put("1x16", 4);
            this.screenSizeHashTable.put("1x40", 10);
            this.screenSizeHashTable.put("1x8", 2);
            this.screenSizeHashTable.put("2x16", 5);
            this.screenSizeHashTable.put("2x20", 7);
            this.screenSizeHashTable.put("2x24", 9);
            this.screenSizeHashTable.put("2x40", 11);
            this.screenSizeHashTable.put("2x8", 3);
            this.screenSizeHashTable.put("4x16", 6);
            this.screenSizeHashTable.put("4x20", 8);
            this.screenSizeHashTable.put("4x40", 12);
            this.screenSizeHashTable.put("Unknown", 13);
            this.dispTxt1.setEnabled(false);
            this.dispTxt2.setEnabled(false);
            this.dispTxt3.setEnabled(false);
            this.dispTxt4.setEnabled(false);
            this.dispTxt1.setEditable(false);
            this.dispTxt2.setEditable(false);
            this.dispTxt3.setEditable(false);
            this.dispTxt4.setEditable(false);
            this.backlightChk.setEnabled(false);
            this.cursorChk.setEnabled(false);
            this.blinkChk.setEnabled(false);
            this.customChk.setEnabled(false);
            this.contrastSlide.setEnabled(false);
            this.brightnessSlide.setEnabled(false);
            this.screenCmb.setEnabled(false);
            this.screenSizeCmb.setEnabled(false);
            this.initializeBtn.setEnabled(false);
            this.attach_listener = new LCDAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.dispTxt1, this.dispTxt2, this.dispTxt3, this.dispTxt4, this.backlightChk, this.cursorChk, this.blinkChk, this.customChk, this.contrastSlide, this.brightnessSlide, this.screenCmb, this.screenSizeCmb, this.initializeBtn, this.screenSizeHashTable);
            this.detach_listener = new LCDDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.dispTxt1, this.dispTxt2, this.dispTxt3, this.dispTxt4, this.backlightChk, this.cursorChk, this.blinkChk, this.customChk, this.contrastSlide, this.brightnessSlide, this.screenCmb, this.screenSizeCmb, this.initializeBtn);
            this.error_listener = new LCDErrorListener(this);
            this.lcd.addAttachListener((AttachListener)this.attach_listener);
            this.lcd.addDetachListener((DetachListener)this.detach_listener);
            this.lcd.addErrorListener((ErrorListener)this.error_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.lcd.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.lcd.open(Integer.parseInt(runArgs[0]));
            } else {
                this.lcd.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.lcd.removeAttachListener((AttachListener)this.attach_listener);
            this.lcd.removeDetachListener((DetachListener)this.detach_listener);
            this.lcd.removeErrorListener((ErrorListener)this.error_listener);
            this.lcd.close();
            this.lcd = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void contrastSlideStateChanged(ChangeEvent evt) {
        try {
            this.lcd.setContrast(this.contrastSlide.getValue());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void customChkActionPerformed(ActionEvent evt) {
        if (this.customChk.isEnabled()) {
            try {
                this.lcd.setDisplayString(0, "Custom Chars");
                this.lcd.setCustomCharacter(8, 949247, 536);
                this.lcd.setCustomCharacter(9, 1015791, 17180);
                this.lcd.setCustomCharacter(10, 1048039, 549790);
                this.lcd.setCustomCharacter(11, 1031395, 816095);
                this.lcd.setCustomCharacter(12, 498785, 949247);
                this.lcd.setCustomCharacter(13, 232480, 1015791);
                this.lcd.setCustomCharacter(14, 99328, 1048039);
                this.lcd.setDisplayString(1, "\b\t\n\u000b\f\r\u000e");
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
            }
        } else {
            try {
                this.lcd.setDisplayString(0, "");
                this.lcd.setDisplayString(1, "");
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
            }
        }
    }

    private void blinkChkActionPerformed(ActionEvent evt) {
        try {
            this.lcd.setCursorBlink(this.blinkChk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void cursorChkActionPerformed(ActionEvent evt) {
        try {
            this.lcd.setCursor(this.cursorChk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void backlightChkActionPerformed(ActionEvent evt) {
        try {
            this.lcd.setBacklight(this.backlightChk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void initializeBtnActionPerformed(ActionEvent evt) {
        this.clearTextFields();
        try {
            if (this.lcd.getDeviceID() == 61) {
                this.lcd.initialize();
            } else {
                this.lcd.setDisplayString(0, "");
                this.lcd.setDisplayString(1, "");
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void dispTxt2KeyReleased(KeyEvent evt) {
        try {
            this.lcd.setDisplayString(1, this.dispTxt2.getText());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void dispTxt1KeyReleased(KeyEvent evt) {
        try {
            this.lcd.setDisplayString(0, this.dispTxt1.getText());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void screenCmbActionPerformed(ActionEvent evt) {
        block6: {
            try {
                if (!this.lcd.isAttached()) break block6;
                int index = (Integer)this.screenCmb.getSelectedItem();
                this.textOriginals[this.currScreen][0] = this.dispTxt1.getText();
                this.textOriginals[this.currScreen][1] = this.dispTxt2.getText();
                this.textOriginals[this.currScreen][2] = this.dispTxt3.getText();
                this.textOriginals[this.currScreen][3] = this.dispTxt4.getText();
                this.currScreen = index;
                this.dispTxt1.setText(this.textOriginals[index][0]);
                this.dispTxt2.setText(this.textOriginals[index][1]);
                this.dispTxt3.setText(this.textOriginals[index][2]);
                this.dispTxt4.setText(this.textOriginals[index][3]);
                this.lcd.setScreen(index);
                this.setScreenSizeCmb();
                this.backlightChk.setSelected(this.lcd.getBacklight());
                try {
                    this.blinkChk.setSelected(this.lcd.getCursorBlink());
                    this.cursorChk.setSelected(this.lcd.getCursor());
                }
                catch (PhidgetException cursorE) {
                    // empty catch block
                }
                this.contrastSlide.setValue(this.lcd.getContrast());
                try {
                    this.brightnessSlide.setValue(this.lcd.getContrast());
                }
                catch (PhidgetException brightnessE) {}
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void screenSizeCmbActionPerformed(ActionEvent evt) {
        String index = (String)this.screenSizeCmb.getSelectedItem();
        try {
            if (this.lcd.isAttached()) {
                int value = (Integer)this.screenSizeHashTable.get(this.screenSizeCmb.getSelectedItem());
                if (value == 13) {
                    this.setAllTextFieldProperties(0);
                } else {
                    this.lcd.setScreenSize(value);
                    this.setRowEnables();
                }
            }
        }
        catch (PhidgetException phidgetException) {
            // empty catch block
        }
    }

    private void dispTxt3KeyReleased(KeyEvent evt) {
        try {
            this.lcd.setDisplayString(2, this.dispTxt3.getText());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void dispTxt4KeyReleased(KeyEvent evt) {
        try {
            this.lcd.setDisplayString(3, this.dispTxt4.getText());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void brightnessSlideStateChanged(ChangeEvent evt) {
        try {
            this.lcd.setBrightness(this.brightnessSlide.getValue());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void setRowEnables() {
        try {
            int rows = this.lcd.getRowCount();
            this.setAllTextFieldProperties(rows);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void clearTextFields() {
        this.dispTxt1.setText("");
        this.dispTxt2.setText("");
        this.dispTxt3.setText("");
        this.dispTxt4.setText("");
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.textOriginals[i][j] = "";
            }
        }
    }

    private void setFieldProperties(JTextField dispTxt, boolean state) {
        String tempText = dispTxt.getText();
        dispTxt.setEditable(state);
        dispTxt.setEnabled(state);
        try {
            dispTxt.setDocument(new TextFieldLimiter(this.lcd.getColumnCount()));
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
        dispTxt.setText(tempText);
    }

    private void setAllTextFieldProperties(int rows) {
        switch (rows) {
            case 1: {
                this.setFieldProperties(this.dispTxt1, true);
                this.setFieldProperties(this.dispTxt2, false);
                this.setFieldProperties(this.dispTxt3, false);
                this.setFieldProperties(this.dispTxt4, false);
                break;
            }
            case 2: {
                this.setFieldProperties(this.dispTxt1, true);
                this.setFieldProperties(this.dispTxt2, true);
                this.setFieldProperties(this.dispTxt3, false);
                this.setFieldProperties(this.dispTxt4, false);
                break;
            }
            case 3: {
                this.setFieldProperties(this.dispTxt1, true);
                this.setFieldProperties(this.dispTxt2, true);
                this.setFieldProperties(this.dispTxt3, true);
                this.setFieldProperties(this.dispTxt4, false);
                break;
            }
            case 4: {
                this.setFieldProperties(this.dispTxt1, true);
                this.setFieldProperties(this.dispTxt2, true);
                this.setFieldProperties(this.dispTxt3, true);
                this.setFieldProperties(this.dispTxt4, true);
                break;
            }
            default: {
                this.setFieldProperties(this.dispTxt1, false);
                this.setFieldProperties(this.dispTxt2, false);
                this.setFieldProperties(this.dispTxt3, false);
                this.setFieldProperties(this.dispTxt4, false);
            }
        }
    }

    private void setScreenSizeCmb() {
        Enumeration eKeys = this.screenSizeHashTable.keys();
        try {
            int element = this.lcd.getScreenSize();
            while (eKeys.hasMoreElements()) {
                Object currKey = eKeys.nextElement();
                if ((Integer)this.screenSizeHashTable.get(currKey) != element) continue;
                this.screenSizeCmb.setSelectedItem(currKey);
            }
        }
        catch (PhidgetException ex) {
            this.screenSizeCmb.setSelectedItem("Unknown");
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TextLCD().setVisible(true);
            }
        });
    }
}

