/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.BridgePhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class BAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JPanel bridgeDataPanel;
    private JComboBox bridgeCmb;
    private JComboBox gainCmb;
    private Hashtable gains;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numBridgesTxt;
    private JCheckBox enableChk;
    private JTextField bridgeValueTxt;
    private JSlider dataRateSld;
    private JTextField dataRateTxt;
    private JTextField timeTxt;
    private JTextField frequencyTxt;
    private JTextField totalCountTxt;
    private JTextField totalTimeTxt;

    public BAttachListener(JFrame appFrame, JPanel bridgeDataPanel, JComboBox bridgeCmb, JComboBox gainCmb, Hashtable gains, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numBridgesTxt, JCheckBox enableChk, JTextField bridgeValueTxt, JSlider dataRateSld, JTextField dataRateTxt) {
        this.appFrame = appFrame;
        this.bridgeDataPanel = bridgeDataPanel;
        this.bridgeCmb = bridgeCmb;
        this.gainCmb = gainCmb;
        this.gains = gains;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numBridgesTxt = numBridgesTxt;
        this.enableChk = enableChk;
        this.bridgeValueTxt = bridgeValueTxt;
        this.dataRateSld = dataRateSld;
        this.dataRateTxt = dataRateTxt;
    }

    public void attached(AttachEvent an) {
        try {
            this.appFrame.setSize(357, 480);
            BridgePhidget attached = (BridgePhidget)an.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numBridgesTxt.setText(Integer.toString(attached.getInputCount()));
            this.bridgeDataPanel.setEnabled(true);
            this.bridgeDataPanel.setVisible(true);
            this.bridgeCmb.setEnabled(true);
            this.bridgeCmb.setVisible(true);
            for (int i = 0; i < attached.getInputCount(); ++i) {
                this.bridgeCmb.addItem(new Integer(i));
            }
            this.gainCmb.setEnabled(true);
            this.gainCmb.setVisible(true);
            TreeSet sortedKeys = new TreeSet(this.gains.keySet());
            for (Integer sortedKey : sortedKeys) {
                this.gainCmb.addItem(sortedKey);
            }
            this.enableChk.setEnabled(true);
            this.enableChk.setVisible(true);
            this.bridgeValueTxt.setEnabled(true);
            this.bridgeValueTxt.setVisible(true);
            this.dataRateTxt.setEnabled(true);
            this.dataRateTxt.setVisible(true);
            this.dataRateSld.setEnabled(true);
            this.dataRateSld.setVisible(true);
            this.dataRateSld.setMinimum(attached.getDataRateMax() / 8);
            this.dataRateSld.setMaximum(attached.getDataRateMin() / 8);
            this.enableChk.setSelected(attached.getEnabled(0));
            if (this.enableChk.isSelected()) {
                this.dataRateSld.setValue(attached.getDataRate() / 8);
                this.dataRateTxt.setText(Integer.toString(attached.getDataRate()));
            } else {
                this.gainCmb.setEnabled(false);
                this.dataRateSld.setEnabled(false);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

