/*
 * Decompiled with CFR 0.152.
 */
package Bridge;

import com.phidgets.BridgePhidget;
import com.phidgets.PhidgetException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.BAttachListener;
import listeners.BBridgeDataListener;
import listeners.BDetachListener;
import listeners.BErrorListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class Bridge
extends JFrame {
    private static String[] runArgs;
    private BridgePhidget bridge;
    private Hashtable gainHashTable;
    private BAttachListener attach_listener;
    private BDetachListener detach_listener;
    private BErrorListener error_listener;
    private BBridgeDataListener bridgeData_listener;
    private JTextField attachedTxt;
    private JComboBox bridgeCmb;
    private JPanel bridgeDataPanel;
    private JTextField bridgeValueTxt;
    private JSlider dataRateSld;
    private JTextField dataRateTxt;
    private JCheckBox enableChk;
    private JComboBox gainCmb;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JTextField numBridgesTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;

    public Bridge() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numBridgesTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.bridgeDataPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.bridgeCmb = new JComboBox();
        this.enableChk = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.gainCmb = new JComboBox();
        this.jLabel8 = new JLabel();
        this.bridgeValueTxt = new JTextField();
        this.jLabel10 = new JLabel();
        this.dataRateSld = new JSlider();
        this.dataRateTxt = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setTitle("Bridge-full");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                Bridge.this.formWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Bridge Info"));
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.attachedTxt.setEditable(false);
        this.jPanel1.add((Component)this.attachedTxt, new AbsoluteConstraints(97, 33, 200, -1));
        this.jLabel1.setText("Attached:");
        this.jPanel1.add((Component)this.jLabel1, new AbsoluteConstraints(43, 36, -1, -1));
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.nameTxt.setPreferredSize(new Dimension(200, 58));
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jPanel1.add((Component)this.jScrollPane1, new AbsoluteConstraints(97, 68, 200, -1));
        this.jLabel2.setText("Name:");
        this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(60, 68, -1, -1));
        this.serialTxt.setEditable(false);
        this.jPanel1.add((Component)this.serialTxt, new AbsoluteConstraints(97, 144, 200, -1));
        this.jLabel3.setText("Serial No:");
        this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(41, 147, -1, -1));
        this.versionTxt.setEditable(false);
        this.jPanel1.add((Component)this.versionTxt, new AbsoluteConstraints(97, 180, 200, -1));
        this.jLabel4.setText("Version:");
        this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(48, 180, -1, -1));
        this.numBridgesTxt.setEditable(false);
        this.jPanel1.add((Component)this.numBridgesTxt, new AbsoluteConstraints(97, 216, 200, -1));
        this.jLabel5.setText("# Bridges:");
        this.jPanel1.add((Component)this.jLabel5, new AbsoluteConstraints(36, 220, -1, 20));
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(10, 0, 320, 252));
        this.bridgeDataPanel.setBorder(BorderFactory.createTitledBorder("Bridge Data"));
        this.jLabel6.setText("Choose Bridge:");
        this.bridgeCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Bridge.this.bridgeCmbActionPerformed(evt);
            }
        });
        this.enableChk.setText("Enabled");
        this.enableChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Bridge.this.enableChkActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Gain:");
        this.gainCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Bridge.this.gainCmbActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Bridge Value(mV/V):");
        this.bridgeValueTxt.setEditable(false);
        this.jLabel10.setText("Data Rate:");
        this.dataRateSld.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Bridge.this.dataRateSldStateChanged(evt);
            }
        });
        this.dataRateTxt.setEditable(false);
        GroupLayout bridgeDataPanelLayout = new GroupLayout(this.bridgeDataPanel);
        this.bridgeDataPanel.setLayout(bridgeDataPanelLayout);
        bridgeDataPanelLayout.setHorizontalGroup(bridgeDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bridgeDataPanelLayout.createSequentialGroup().addGroup(bridgeDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bridgeDataPanelLayout.createSequentialGroup().addGap(42, 42, 42).addComponent(this.jLabel10).addGap(7, 7, 7).addComponent(this.dataRateSld, -2, 130, -2).addGap(10, 10, 10).addComponent(this.dataRateTxt, -2, 40, -2)).addGroup(bridgeDataPanelLayout.createSequentialGroup().addGap(42, 42, 42).addGroup(bridgeDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bridgeDataPanelLayout.createSequentialGroup().addComponent(this.enableChk).addGap(0, 0, 0).addGroup(bridgeDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bridgeDataPanelLayout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.jLabel8)).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bridgeValueTxt, -1, 59, Short.MAX_VALUE)).addComponent(this.jLabel6))).addGroup(bridgeDataPanelLayout.createSequentialGroup().addGap(86, 86, 86).addGroup(bridgeDataPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.bridgeCmb, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.gainCmb, GroupLayout.Alignment.LEADING, 0, 177, Short.MAX_VALUE)))).addGap(22, 22, 22)));
        bridgeDataPanelLayout.setVerticalGroup(bridgeDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bridgeDataPanelLayout.createSequentialGroup().addGroup(bridgeDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bridgeDataPanelLayout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jLabel6).addGap(11, 11, 11).addComponent(this.gainCmb, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bridgeDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bridgeDataPanelLayout.createSequentialGroup().addGroup(bridgeDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bridgeDataPanelLayout.createSequentialGroup().addComponent(this.enableChk).addGap(4, 4, 4).addComponent(this.jLabel8)).addComponent(this.bridgeValueTxt, -2, -1, -2)).addGap(16, 16, 16).addGroup(bridgeDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bridgeDataPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel10)).addComponent(this.dataRateSld, -2, -1, -2).addComponent(this.dataRateTxt, -2, -1, -2))).addGroup(bridgeDataPanelLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLabel7)))).addGroup(bridgeDataPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.bridgeCmb, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.bridgeDataPanel, new AbsoluteConstraints(10, 255, 320, 180));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.setSize(357, 295);
        this.attachedTxt.setText("false");
        this.bridgeDataPanel.setVisible(false);
        this.bridgeDataPanel.setEnabled(false);
        this.bridgeCmb.setVisible(false);
        this.bridgeCmb.setEnabled(false);
        this.gainCmb.setVisible(false);
        this.gainCmb.setEnabled(false);
        this.gainHashTable = new Hashtable();
        this.gainHashTable.put(1, 1);
        this.gainHashTable.put(8, 2);
        this.gainHashTable.put(16, 3);
        this.gainHashTable.put(32, 4);
        this.gainHashTable.put(64, 5);
        this.gainHashTable.put(128, 6);
        this.enableChk.setVisible(false);
        this.enableChk.setEnabled(false);
        this.bridgeValueTxt.setVisible(false);
        this.bridgeValueTxt.setEnabled(false);
        this.dataRateTxt.setVisible(false);
        this.dataRateTxt.setEnabled(false);
        this.dataRateSld.setVisible(false);
        this.dataRateSld.setEnabled(false);
        try {
            this.bridge = new BridgePhidget();
            this.attach_listener = new BAttachListener(this, this.bridgeDataPanel, this.bridgeCmb, this.gainCmb, this.gainHashTable, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numBridgesTxt, this.enableChk, this.bridgeValueTxt, this.dataRateSld, this.dataRateTxt);
            this.detach_listener = new BDetachListener(this, this.bridgeDataPanel, this.bridgeCmb, this.gainCmb, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numBridgesTxt, this.enableChk, this.bridgeValueTxt, this.dataRateSld, this.dataRateTxt);
            this.error_listener = new BErrorListener(this);
            this.bridgeData_listener = new BBridgeDataListener(this.bridgeCmb, this.bridgeValueTxt);
            this.bridge.addAttachListener(this.attach_listener);
            this.bridge.addDetachListener(this.detach_listener);
            this.bridge.addErrorListener(this.error_listener);
            this.bridge.addBridgeDataListener(this.bridgeData_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.bridge.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                this.bridge.open(Integer.parseInt(runArgs[0]));
            } else {
                this.bridge.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void enableChkActionPerformed(ActionEvent evt) {
        int index = (Integer)this.bridgeCmb.getSelectedItem();
        try {
            this.bridge.setEnabled((Integer)this.bridgeCmb.getSelectedItem(), this.enableChk.isSelected());
            try {
                Thread.sleep(80L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (this.enableChk.isSelected()) {
                this.bridgeValueTxt.setEnabled(true);
                this.gainCmb.setEnabled(true);
                this.setGainCmb();
                this.dataRateSld.setEnabled(true);
                this.dataRateTxt.setText(Integer.toString(this.bridge.getDataRate()));
            } else {
                this.bridgeValueTxt.setText("");
                this.gainCmb.setEnabled(false);
                this.dataRateSld.setEnabled(false);
                this.dataRateTxt.setText("");
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void gainCmbActionPerformed(ActionEvent evt) {
        this.bridgeValueTxt.setText("");
        int index = (Integer)this.bridgeCmb.getSelectedItem();
        try {
            if (this.bridge.isAttached() && this.bridge.getEnabled(index)) {
                int value = (Integer)this.gainHashTable.get(this.gainCmb.getSelectedItem());
                this.bridge.setGain(index, value);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void dataRateSldStateChanged(ChangeEvent evt) {
        if (this.dataRateSld.isEnabled()) {
            try {
                this.bridge.setDataRate(this.dataRateSld.getValue() * 8);
                this.dataRateTxt.setText(Integer.toString(this.dataRateSld.getValue() * 8));
            }
            catch (PhidgetException phidgetException) {
                // empty catch block
            }
        }
    }

    private void bridgeCmbActionPerformed(ActionEvent evt) {
        this.bridgeValueTxt.setText("");
        int index = (Integer)this.bridgeCmb.getSelectedItem();
        try {
            if (this.bridge.isAttached() && this.bridge.getEnabled(index)) {
                this.enableChk.setSelected(true);
                this.gainCmb.setEnabled(true);
                this.dataRateSld.setEnabled(true);
                this.dataRateTxt.setText(Integer.toString(this.bridge.getDataRate()));
                this.setGainCmb();
            } else {
                this.enableChk.setSelected(false);
                this.gainCmb.setEnabled(false);
                this.dataRateSld.setEnabled(false);
                this.dataRateTxt.setText("");
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void setGainCmb() {
        int index = (Integer)this.bridgeCmb.getSelectedItem();
        Enumeration eKeys = this.gainHashTable.keys();
        try {
            int element = this.bridge.getGain(index);
            while (eKeys.hasMoreElements()) {
                Object currKey = eKeys.nextElement();
                if ((Integer)this.gainHashTable.get(currKey) != element) continue;
                this.gainCmb.setSelectedItem(currKey);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Bridge().setVisible(true);
            }
        });
    }
}

