/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.GPSPositionChangeEvent;
import com.phidgets.event.GPSPositionChangeListener;
import com.phidgets.event.GPSPositionFixStatusChangeEvent;
import com.phidgets.event.GPSPositionFixStatusChangeListener;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;

public final class GPSPhidget
extends Phidget {
    private LinkedList gpsPositionFixStatusChangeListeners = new LinkedList();
    private long nativeGPSPositionFixStatusChangeHandler = 0L;
    private LinkedList gpsPositionChangeListeners = new LinkedList();
    private long nativeGPSPositionChangeHandler = 0L;

    public GPSPhidget() throws PhidgetException {
        super(GPSPhidget.create());
    }

    private static native long create() throws PhidgetException;

    public native double getLatitude() throws PhidgetException;

    public native double getLongitude() throws PhidgetException;

    public native double getAltitude() throws PhidgetException;

    public native double getHeading() throws PhidgetException;

    public native double getVelocity() throws PhidgetException;

    public native Calendar getDateAndTime() throws PhidgetException;

    public native boolean getPositionFixStatus() throws PhidgetException;

    private final void enableDeviceSpecificEvents(boolean bl) {
        this.enableGPSPositionFixStatusChangeEvents(bl && this.gpsPositionFixStatusChangeListeners.size() > 0);
        this.enableGPSPositionChangeEvents(bl && this.gpsPositionChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGPSPositionFixStatusChangeListener(GPSPositionFixStatusChangeListener gPSPositionFixStatusChangeListener) {
        LinkedList linkedList = this.gpsPositionFixStatusChangeListeners;
        synchronized (linkedList) {
            this.gpsPositionFixStatusChangeListeners.add(gPSPositionFixStatusChangeListener);
            this.enableGPSPositionFixStatusChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeGPSPositionFixStatusChangeListener(GPSPositionFixStatusChangeListener gPSPositionFixStatusChangeListener) {
        LinkedList linkedList = this.gpsPositionFixStatusChangeListeners;
        synchronized (linkedList) {
            this.gpsPositionFixStatusChangeListeners.remove(gPSPositionFixStatusChangeListener);
            this.enableGPSPositionFixStatusChangeEvents(this.gpsPositionFixStatusChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGPSPositionFixStatusChange(GPSPositionFixStatusChangeEvent gPSPositionFixStatusChangeEvent) {
        LinkedList linkedList = this.gpsPositionFixStatusChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.gpsPositionFixStatusChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((GPSPositionFixStatusChangeListener)iterator.next()).gpsPositionFixStatusChanged(gPSPositionFixStatusChangeEvent);
            }
        }
    }

    private native void enableGPSPositionFixStatusChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGPSPositionChangeListener(GPSPositionChangeListener gPSPositionChangeListener) {
        LinkedList linkedList = this.gpsPositionChangeListeners;
        synchronized (linkedList) {
            this.gpsPositionChangeListeners.add(gPSPositionChangeListener);
            this.enableGPSPositionChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeGPSPositionChangeListener(GPSPositionChangeListener gPSPositionChangeListener) {
        LinkedList linkedList = this.gpsPositionChangeListeners;
        synchronized (linkedList) {
            this.gpsPositionChangeListeners.remove(gPSPositionChangeListener);
            this.enableGPSPositionChangeEvents(this.gpsPositionChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGPSPositionChange(GPSPositionChangeEvent gPSPositionChangeEvent) {
        LinkedList linkedList = this.gpsPositionChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.gpsPositionChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((GPSPositionChangeListener)iterator.next()).gpsPositionChanged(gPSPositionChangeEvent);
            }
        }
    }

    private native void enableGPSPositionChangeEvents(boolean var1);
}

