/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.LEDPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LEDAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numLEDTxt;
    private JComboBox ledCmb;
    private JSlider ledBrightScrl;
    private JComboBox voltageCmb;
    private JComboBox currentLimitCmb;
    private JLabel voltageLbl;
    private JLabel currentLimitLbl;

    public LEDAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numLEDTxt, JComboBox ledCmb, JSlider ledBrightScrl, JComboBox voltageCmb, JComboBox currentLimitCmb, JLabel voltageLbl, JLabel currentLimitLbl) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numLEDTxt = numLEDTxt;
        this.ledCmb = ledCmb;
        this.ledBrightScrl = ledBrightScrl;
        this.voltageCmb = voltageCmb;
        this.currentLimitCmb = currentLimitCmb;
        this.voltageLbl = voltageLbl;
        this.currentLimitLbl = currentLimitLbl;
    }

    public void attached(AttachEvent ae) {
        try {
            LEDPhidget attached = (LEDPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numLEDTxt.setText(Integer.toString(attached.getLEDCount()));
            for (int i = 0; i < attached.getLEDCount(); ++i) {
                this.ledCmb.addItem(new Integer(i));
            }
            this.ledCmb.setSelectedIndex(0);
            this.ledCmb.setEnabled(true);
            this.ledBrightScrl.setValue(0);
            this.ledBrightScrl.setEnabled(true);
            try {
                int voltage = attached.getVoltage();
                switch (voltage) {
                    case 1: {
                        this.voltageCmb.setSelectedItem("1.7V");
                        break;
                    }
                    case 2: {
                        this.voltageCmb.setSelectedItem("2.75V");
                        break;
                    }
                    case 3: {
                        this.voltageCmb.setSelectedItem("3.9V");
                        break;
                    }
                    case 4: {
                        this.voltageCmb.setSelectedItem("5.0V");
                    }
                }
                this.voltageLbl.setVisible(true);
                this.voltageCmb.setEnabled(true);
                this.voltageCmb.setVisible(true);
            }
            catch (PhidgetException ex1) {
                this.voltageLbl.setVisible(false);
                this.voltageCmb.setEnabled(false);
                this.voltageCmb.setVisible(false);
            }
            try {
                int currentLimit = attached.getCurrentLimit();
                switch (currentLimit) {
                    case 1: {
                        this.currentLimitCmb.setSelectedItem("20mA");
                        break;
                    }
                    case 2: {
                        this.currentLimitCmb.setSelectedItem("40mA");
                        break;
                    }
                    case 3: {
                        this.currentLimitCmb.setSelectedItem("60mA");
                        break;
                    }
                    case 4: {
                        this.currentLimitCmb.setSelectedItem("80mA");
                    }
                }
                this.currentLimitLbl.setVisible(true);
                this.currentLimitCmb.setEnabled(true);
                this.currentLimitCmb.setVisible(true);
            }
            catch (PhidgetException ex2) {
                this.currentLimitLbl.setVisible(false);
                this.currentLimitCmb.setEnabled(false);
                this.currentLimitCmb.setVisible(false);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

