/*
 * Decompiled with CFR 0.152.
 */
package AdvancedServo;

import com.phidgets.AdvancedServoPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.CurrentChangeListener;
import com.phidgets.event.DetachListener;
import com.phidgets.event.ErrorListener;
import com.phidgets.event.ServoPositionChangeListener;
import com.phidgets.event.ServoVelocityChangeListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.AdvServoAttachListener;
import listeners.AdvServoCurrentListener;
import listeners.AdvServoDetachListener;
import listeners.AdvServoErrorListener;
import listeners.AdvServoPositionListener;
import listeners.AdvServoVelocityListener;
import org.jdesktop.layout.GroupLayout;

public class AdvancedServo
extends JFrame {
    private static String[] runArgs;
    private Hashtable servoTypes;
    private AdvancedServoPhidget advServo;
    private AdvServoAttachListener attach_listener;
    private AdvServoDetachListener detach_listener;
    private AdvServoErrorListener error_listener;
    private AdvServoCurrentListener current_listener;
    private AdvServoPositionListener position_listener;
    private AdvServoVelocityListener velocity_listener;
    private JSlider accelScrl;
    private JTextField accelTxt;
    private JTextField actPosTxt;
    private JTextField actVelTxt;
    private JTextField attachedTxt;
    private JTextField currentTxt;
    private JCheckBox engagedChk;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSlider maxPosScrl;
    private JTextField maxPosTxt;
    private JSlider minPosScrl;
    private JTextField minPosTxt;
    private JTextArea nameTxt;
    private JTextField numServosTxt;
    private JSlider posScrl;
    private JCheckBox rampingChk;
    private JTextField serialTxt;
    private JComboBox servoCmb;
    private JComboBox servoTypeCmb;
    private JCheckBox stoppedChk;
    private JTextField targetPosTxt;
    private JTextField targetVelTxt;
    private JSlider velScrl;
    private JTextField versionTxt;

    public AdvancedServo() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numServosTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.servoCmb = new JComboBox();
        this.actVelTxt = new JTextField();
        this.jLabel7 = new JLabel();
        this.actPosTxt = new JTextField();
        this.jLabel8 = new JLabel();
        this.currentTxt = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.posScrl = new JSlider();
        this.targetPosTxt = new JTextField();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.velScrl = new JSlider();
        this.targetVelTxt = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.accelScrl = new JSlider();
        this.accelTxt = new JTextField();
        this.jLabel15 = new JLabel();
        this.engagedChk = new JCheckBox();
        this.rampingChk = new JCheckBox();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.maxPosScrl = new JSlider();
        this.maxPosTxt = new JTextField();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.minPosScrl = new JSlider();
        this.minPosTxt = new JTextField();
        this.stoppedChk = new JCheckBox();
        this.servoTypeCmb = new JComboBox();
        this.jLabel20 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("AdvancedServo - full");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                AdvancedServo.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                AdvancedServo.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("AdvancedServo Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        this.numServosTxt.setEditable(false);
        this.jLabel5.setText("Servos:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(35, 35, 35).add(jPanel1Layout.createParallelGroup(2).add(this.jLabel1).add(this.jLabel2).add(this.jLabel4).add(this.jLabel3).add(this.jLabel5)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.numServosTxt).add(1, this.versionTxt).add(1, this.serialTxt).add(1, this.attachedTxt).add(1, this.jScrollPane1)).addContainerGap(64, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jScrollPane1, -2, -1, -2).add(this.jLabel2)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numServosTxt, -2, -1, -2).add(this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Servo Data"));
        this.jLabel6.setText("Choose Servo:");
        this.servoCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdvancedServo.this.servoCmbActionPerformed(evt);
            }
        });
        this.actVelTxt.setEditable(false);
        this.jLabel7.setText("Actual Velocity:");
        this.actPosTxt.setEditable(false);
        this.jLabel8.setText("Actual Position:");
        this.currentTxt.setEditable(false);
        this.jLabel9.setText("Current:");
        this.jLabel10.setText("Set Target Position:");
        this.posScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AdvancedServo.this.posScrlStateChanged(evt);
            }
        });
        this.targetPosTxt.setEditable(false);
        this.jLabel11.setText("Target Position:");
        this.jLabel12.setText("Set Velocity:");
        this.velScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AdvancedServo.this.velScrlStateChanged(evt);
            }
        });
        this.targetVelTxt.setEditable(false);
        this.jLabel13.setText("Target Velocity:");
        this.jLabel14.setText("Set Acceleration:");
        this.accelScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AdvancedServo.this.accelScrlStateChanged(evt);
            }
        });
        this.accelTxt.setEditable(false);
        this.jLabel15.setText("Acceleration:");
        this.engagedChk.setText("Engaged");
        this.engagedChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdvancedServo.this.engagedChkActionPerformed(evt);
            }
        });
        this.rampingChk.setText("Speed Ramping");
        this.rampingChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdvancedServo.this.rampingChkActionPerformed(evt);
            }
        });
        this.jLabel16.setText("Set Max Position:");
        this.jLabel17.setText("Max Position:");
        this.maxPosScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AdvancedServo.this.maxPosScrlStateChanged(evt);
            }
        });
        this.maxPosTxt.setEditable(false);
        this.jLabel18.setText("Set Min Position:");
        this.jLabel19.setText("Min Position:");
        this.minPosScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AdvancedServo.this.minPosScrlStateChanged(evt);
            }
        });
        this.minPosTxt.setEditable(false);
        this.stoppedChk.setText("Stopped");
        this.stoppedChk.setEnabled(false);
        this.servoTypeCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdvancedServo.this.servoTypeCmbActionPerformed(evt);
            }
        });
        this.jLabel20.setText("Choose Type:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(this.jLabel6).add(this.jLabel7).add(this.jLabel8).add(this.jLabel9).add(this.engagedChk).add(this.jLabel20)).add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(85, 85, 85).add(jPanel2Layout.createParallelGroup(2, false).add(1, this.currentTxt).add(1, this.actPosTxt).add(1, this.actVelTxt).add(1, this.servoCmb, 0, 140, Short.MAX_VALUE).add(1, this.servoTypeCmb, 0, -1, Short.MAX_VALUE))).add(jPanel2Layout.createSequentialGroup().add(28, 28, 28).add(this.rampingChk).add(33, 33, 33).add(this.stoppedChk)))).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(2, false).add(1, this.minPosScrl, 0, 0, Short.MAX_VALUE).add(1, this.accelScrl, 0, 0, Short.MAX_VALUE).add(1, this.posScrl, -1, 155, Short.MAX_VALUE).add(1, this.jLabel10).add(1, this.jLabel12).add(1, this.velScrl, 0, 0, Short.MAX_VALUE).add(1, this.jLabel14).add(1, this.jLabel16).add(1, this.jLabel18).add(1, this.maxPosScrl, 0, 0, Short.MAX_VALUE)).add(41, 41, 41).add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createParallelGroup(1, false).add(this.jLabel17).add(this.jLabel15).add(this.jLabel13).add(2, this.targetVelTxt).add(this.jLabel11).add(this.targetPosTxt, -1, 103, Short.MAX_VALUE).add(this.accelTxt).add(this.maxPosTxt)).add(this.jLabel19).add(2, this.minPosTxt, -2, 102, -2)).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel6).add(this.servoCmb, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.servoTypeCmb, -2, -1, -2).add(this.jLabel20)).addPreferredGap(0, -1, Short.MAX_VALUE).add(jPanel2Layout.createParallelGroup(3).add(this.actVelTxt, -2, -1, -2).add(this.jLabel7)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.actPosTxt, -2, -1, -2).add(this.jLabel8)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.currentTxt, -2, -1, -2).add(this.jLabel9)).add(18, 18, 18).add(jPanel2Layout.createParallelGroup(3).add(this.engagedChk).add(this.rampingChk).add(this.stoppedChk)).add(12, 12, 12).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel10).add(this.jLabel11)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.posScrl, -2, -1, -2).add(this.targetPosTxt, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel12).add(this.jLabel13)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.targetVelTxt, -2, -1, -2).add(this.velScrl, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel14).add(this.jLabel15)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.accelScrl, -2, -1, -2).add(this.accelTxt, -2, -1, -2)).addPreferredGap(1).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel16).add(this.jLabel17)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.maxPosTxt, -2, -1, -2).add(this.maxPosScrl, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel18).add(this.jLabel19)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.minPosScrl, -2, -1, -2).add(this.minPosTxt, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, this.jPanel1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.jPanel1, this.jPanel2}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.servoTypes = new Hashtable();
        this.servoTypes.put("DEFAULT", 1);
        this.servoTypes.put("RAW_us_MODE", 2);
        this.servoTypes.put("HITEC_HS322HD", 3);
        this.servoTypes.put("HITEC_HS5245MG", 4);
        this.servoTypes.put("HITEC_805BB", 5);
        this.servoTypes.put("HITEC_HS422", 6);
        this.servoTypes.put("TOWERPRO_MG90", 7);
        this.servoTypes.put("HITEC_HSR1425CR", 8);
        this.servoTypes.put("HITEC_HS785HB", 9);
        this.servoTypes.put("HITEC_HS485HB", 10);
        this.servoTypes.put("HITEC_HS645MG", 11);
        this.servoTypes.put("HITEC_815BB", 12);
        this.maxPosScrl.setEnabled(false);
        this.minPosScrl.setEnabled(false);
        this.posScrl.setEnabled(false);
        this.velScrl.setEnabled(false);
        this.accelScrl.setEnabled(false);
        this.servoCmb.setEnabled(false);
        this.servoTypeCmb.setEnabled(false);
        this.engagedChk.setEnabled(false);
        this.rampingChk.setEnabled(false);
        try {
            this.advServo = new AdvancedServoPhidget();
            this.attach_listener = new AdvServoAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numServosTxt, this.servoCmb, this.servoTypeCmb, this.actVelTxt, this.actPosTxt, this.currentTxt, this.posScrl, this.targetPosTxt, this.velScrl, this.targetVelTxt, this.accelScrl, this.accelTxt, this.engagedChk, this.rampingChk, this.maxPosScrl, this.maxPosTxt, this.minPosScrl, this.minPosTxt, this.stoppedChk, this.servoTypes);
            this.detach_listener = new AdvServoDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numServosTxt, this.servoCmb, this.servoTypeCmb, this.actVelTxt, this.actPosTxt, this.currentTxt, this.posScrl, this.targetPosTxt, this.velScrl, this.targetVelTxt, this.accelScrl, this.accelTxt, this.engagedChk, this.rampingChk, this.maxPosScrl, this.maxPosTxt, this.minPosScrl, this.minPosTxt, this.stoppedChk);
            this.error_listener = new AdvServoErrorListener(this);
            this.current_listener = new AdvServoCurrentListener(this.servoCmb, this.currentTxt);
            this.position_listener = new AdvServoPositionListener(this, this.servoCmb, this.engagedChk, this.actPosTxt, this.stoppedChk);
            this.velocity_listener = new AdvServoVelocityListener(this.servoCmb, this.actVelTxt);
            this.advServo.addAttachListener((AttachListener)this.attach_listener);
            this.advServo.addDetachListener((DetachListener)this.detach_listener);
            this.advServo.addErrorListener((ErrorListener)this.error_listener);
            this.advServo.addCurrentChangeListener((CurrentChangeListener)this.current_listener);
            this.advServo.addServoPositionChangeListener((ServoPositionChangeListener)this.position_listener);
            this.advServo.addServoVelocityChangeListener((ServoVelocityChangeListener)this.velocity_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.advServo.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.advServo.open(Integer.parseInt(runArgs[0]));
            } else {
                this.advServo.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void servoCmbActionPerformed(ActionEvent evt) {
        if (this.servoCmb.isEnabled()) {
            this.initAllValues();
        }
    }

    private void posScrlStateChanged(ChangeEvent evt) {
        if (this.posScrl.isEnabled()) {
            try {
                int selectedMotor = (Integer)this.servoCmb.getSelectedItem();
                double value = (double)this.posScrl.getValue() / 128.0;
                if (value < this.advServo.getPositionMin(selectedMotor)) {
                    value = this.advServo.getPositionMin(selectedMotor);
                } else if (value > this.advServo.getPositionMax(selectedMotor)) {
                    value = this.advServo.getPositionMax(selectedMotor);
                }
                this.advServo.setPosition(selectedMotor, value);
                this.targetPosTxt.setText(Double.toString(value));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void velScrlStateChanged(ChangeEvent evt) {
        if (this.velScrl.isEnabled()) {
            try {
                int selectedMotor = (Integer)this.servoCmb.getSelectedItem();
                double value = this.velScrl.getValue();
                if (value < this.advServo.getVelocityMin(selectedMotor)) {
                    value = this.advServo.getVelocityMin(selectedMotor);
                } else if (value > this.advServo.getVelocityMax(selectedMotor)) {
                    value = this.advServo.getVelocityMax(selectedMotor);
                }
                this.advServo.setVelocityLimit(selectedMotor, value);
                this.targetVelTxt.setText(Double.toString(value));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void accelScrlStateChanged(ChangeEvent evt) {
        if (this.accelScrl.isEnabled()) {
            try {
                int selectedMotor = (Integer)this.servoCmb.getSelectedItem();
                double value = this.accelScrl.getValue();
                if (value < this.advServo.getAccelerationMin(selectedMotor)) {
                    value = this.advServo.getAccelerationMin(selectedMotor);
                } else if (value > this.advServo.getAccelerationMax(selectedMotor)) {
                    value = this.advServo.getAccelerationMax(selectedMotor);
                }
                this.advServo.setAcceleration(selectedMotor, value);
                this.accelTxt.setText(Double.toString(value));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.advServo.removeServoVelocityChangeListener((ServoVelocityChangeListener)this.velocity_listener);
            this.advServo.removeServoPositionChangeListener((ServoPositionChangeListener)this.position_listener);
            this.advServo.removeCurrentChangeListener((CurrentChangeListener)this.current_listener);
            this.advServo.removeErrorListener((ErrorListener)this.error_listener);
            this.advServo.removeDetachListener((DetachListener)this.detach_listener);
            this.advServo.removeAttachListener((AttachListener)this.attach_listener);
            this.advServo.close();
            this.advServo = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void rampingChkActionPerformed(ActionEvent evt) {
        if (this.rampingChk.isEnabled()) {
            try {
                this.advServo.setSpeedRampingOn(((Integer)this.servoCmb.getSelectedItem()).intValue(), this.rampingChk.isSelected());
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void engagedChkActionPerformed(ActionEvent evt) {
        if (this.engagedChk.isEnabled()) {
            try {
                this.advServo.setEngaged(((Integer)this.servoCmb.getSelectedItem()).intValue(), this.engagedChk.isSelected());
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void maxPosScrlStateChanged(ChangeEvent evt) {
        if (this.maxPosScrl.isEnabled()) {
            try {
                int selectedMotor = (Integer)this.servoCmb.getSelectedItem();
                double value = this.maxPosScrl.getValue();
                if (value < this.advServo.getPositionMin(selectedMotor)) {
                    value = this.advServo.getPositionMin(selectedMotor);
                } else if (value > this.advServo.getPositionMax(selectedMotor)) {
                    value = this.advServo.getPositionMax(selectedMotor);
                }
                this.advServo.setPositionMax(selectedMotor, value);
                this.maxPosTxt.setText(Integer.toString(this.maxPosScrl.getValue()));
                this.posScrl.setMaximum((int)value * 128);
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void minPosScrlStateChanged(ChangeEvent evt) {
        if (this.minPosScrl.isEnabled()) {
            try {
                int selectedMotor = (Integer)this.servoCmb.getSelectedItem();
                double value = this.minPosScrl.getValue();
                if (value < this.advServo.getPositionMin(selectedMotor)) {
                    value = this.advServo.getPositionMin(selectedMotor);
                } else if (value > this.advServo.getPositionMax(selectedMotor)) {
                    value = this.advServo.getPositionMax(selectedMotor);
                }
                this.advServo.setPositionMin(selectedMotor, value);
                this.minPosTxt.setText(Integer.toString(this.minPosScrl.getValue()));
                this.posScrl.setMinimum((int)value * 128);
            }
            catch (PhidgetException ex) {
                Logger.getLogger(AdvancedServo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void servoTypeCmbActionPerformed(ActionEvent evt) {
        if (this.servoTypeCmb.isEnabled()) {
            try {
                int index = this.servoCmb.getSelectedIndex();
                if (Integer.valueOf(this.advServo.getServoType(index)) != this.servoTypes.get(this.servoTypeCmb.getSelectedItem())) {
                    this.advServo.setServoType(index, ((Integer)this.servoTypes.get(this.servoTypeCmb.getSelectedItem())).intValue());
                    this.initAllValues();
                }
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void initAllValues() {
        int index = (Integer)this.servoCmb.getSelectedItem();
        try {
            this.engagedChk.setSelected(this.advServo.getEngaged(index));
            this.rampingChk.setSelected(this.advServo.getSpeedRampingOn(index));
            this.maxPosScrl.setMaximum((int)this.advServo.getPositionMax(index));
            this.maxPosScrl.setMinimum((int)this.advServo.getPositionMin(index));
            this.maxPosScrl.setValue((int)this.advServo.getPositionMax(index));
            this.maxPosTxt.setText(Double.toString(this.advServo.getPositionMax(index)));
            this.minPosScrl.setMaximum((int)this.advServo.getPositionMax(index));
            this.minPosScrl.setMinimum((int)this.advServo.getPositionMin(index));
            this.minPosScrl.setValue((int)this.advServo.getPositionMin(index));
            this.minPosTxt.setText(Double.toString(this.advServo.getPositionMin(index)));
            this.posScrl.setMaximum((int)this.advServo.getPositionMax(index) * 128);
            this.posScrl.setMinimum((int)this.advServo.getPositionMin(index) * 128);
            if (this.advServo.getEngaged(index)) {
                try {
                    this.posScrl.setValueIsAdjusting(true);
                    this.posScrl.setValue((int)this.advServo.getPosition(index) * 128);
                    this.posScrl.setValueIsAdjusting(false);
                }
                catch (PhidgetException ex) {
                    // empty catch block
                }
                this.targetPosTxt.setText(Double.toString(this.advServo.getPosition(0) * 128.0));
                this.actPosTxt.setText(Double.toString(this.advServo.getPosition(0) * 128.0));
            } else {
                this.posScrl.setValueIsAdjusting(true);
                this.posScrl.setValue(this.minPosScrl.getValue() * 128);
                this.posScrl.setValueIsAdjusting(false);
                this.targetPosTxt.setText(Integer.toString(this.posScrl.getValue()));
                this.actPosTxt.setText("Unknown");
            }
            this.currentTxt.setText(Double.toString(this.advServo.getCurrent(index)));
            this.actVelTxt.setText(Double.toString(this.advServo.getVelocity(index)));
            this.velScrl.setMinimum((int)this.advServo.getVelocityMin(index));
            this.velScrl.setMaximum((int)this.advServo.getVelocityMax(index));
            this.velScrl.setValueIsAdjusting(true);
            this.velScrl.setValue((int)this.advServo.getVelocityLimit(index));
            this.velScrl.setValueIsAdjusting(false);
            this.targetVelTxt.setText(Double.toString(this.advServo.getVelocityLimit(index)));
            this.accelScrl.setMinimum((int)this.advServo.getAccelerationMin(index));
            this.accelScrl.setMaximum((int)this.advServo.getAccelerationMax(index));
            try {
                this.accelScrl.setValueIsAdjusting(true);
                this.accelScrl.setValue((int)this.advServo.getAcceleration(index));
                this.accelScrl.setValueIsAdjusting(false);
                this.accelTxt.setText(Double.toString(this.advServo.getAcceleration(index)));
            }
            catch (PhidgetException ex) {
                this.accelTxt.setText("Unknown");
            }
            this.maxPosTxt.setText(Double.toString(this.advServo.getPositionMax(index)));
            this.minPosTxt.setText(Double.toString(this.advServo.getPositionMin(index)));
            this.stoppedChk.setSelected(this.advServo.getStopped(index));
            Enumeration e = this.servoTypes.keys();
            while (e.hasMoreElements()) {
                String selectedType = (String)e.nextElement();
                if (((Integer)this.servoTypes.get(selectedType)).intValue() != this.advServo.getServoType(index)) continue;
                this.servoTypeCmb.setSelectedItem(selectedType);
            }
        }
        catch (PhidgetException ex) {
            this.engagedChk.setSelected(false);
            this.actPosTxt.setText("Unknown");
            this.actVelTxt.setText("Unknown");
            this.currentTxt.setText("Unknown");
            try {
                this.posScrl.setMaximum((int)this.advServo.getPositionMax(0) * 128);
                this.posScrl.setMinimum((int)this.advServo.getPositionMin(0) * 128);
                this.posScrl.setValueIsAdjusting(true);
                this.posScrl.setValue((int)this.advServo.getPositionMin(0) * 128);
                this.posScrl.setValueIsAdjusting(false);
                this.velScrl.setValueIsAdjusting(true);
                this.velScrl.setValue((int)this.advServo.getVelocityMin(index));
                this.velScrl.setValueIsAdjusting(false);
                this.accelScrl.setValueIsAdjusting(true);
                this.accelScrl.setValue((int)this.advServo.getAccelerationMin(index));
                this.accelScrl.setValueIsAdjusting(false);
                this.targetPosTxt.setText(Integer.toString(this.posScrl.getValue()));
                this.targetVelTxt.setText(Integer.toString(this.velScrl.getValue()));
                this.accelTxt.setText(Integer.toString(this.accelScrl.getValue()));
            }
            catch (PhidgetException ex2) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new AdvancedServo().setVisible(true);
            }
        });
    }
}

