/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.StepperPhidget;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class StepperAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numMotorsTxt;
    private JComboBox motorCmb;
    private JTextField velLimitTxt;
    private JTextField velActualTxt;
    private JTextField accelTxt;
    private JTextField posTargetTxt;
    private JTextField posActualTxt;
    private JTextField currentLimitTxt;
    private JTextField currentActualTxt;
    private JSlider velLimitScrl;
    private JSlider accelScrl;
    private JSlider targetPosScrl;
    private JSlider currentPosScrl;
    private JSlider currentLimitScrl;
    private JCheckBox[] inputArray;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel18;
    private JCheckBox engagedChk;
    private JCheckBox stoppedChk;

    public StepperAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numMotorsTxt, JComboBox motorCmb, JTextField velLimitTxt, JTextField velActualTxt, JTextField accelTxt, JTextField posTargetTxt, JTextField posActualTxt, JTextField currentLimitTxt, JTextField currentActualTxt, JSlider velLimitScrl, JSlider accelScrl, JSlider targetPosScrl, JSlider currentPosScrl, JSlider currentLimitScrl, JCheckBox[] inputArray, JLabel jLabel11, JLabel jLabel12, JLabel jLabel18, JCheckBox engagedChk, JCheckBox stoppedChk) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numMotorsTxt = numMotorsTxt;
        this.motorCmb = motorCmb;
        this.velLimitTxt = velLimitTxt;
        this.velActualTxt = velActualTxt;
        this.accelTxt = accelTxt;
        this.posTargetTxt = posTargetTxt;
        this.posActualTxt = posActualTxt;
        this.currentLimitTxt = currentLimitTxt;
        this.currentActualTxt = currentActualTxt;
        this.engagedChk = engagedChk;
        this.stoppedChk = stoppedChk;
        this.velLimitScrl = velLimitScrl;
        this.accelScrl = accelScrl;
        this.targetPosScrl = targetPosScrl;
        this.currentPosScrl = currentPosScrl;
        this.currentLimitScrl = currentLimitScrl;
        this.inputArray = inputArray;
        this.jLabel11 = jLabel11;
        this.jLabel12 = jLabel12;
        this.jLabel18 = jLabel18;
    }

    public void attached(AttachEvent ae) {
        try {
            int i;
            StepperPhidget attached = (StepperPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numMotorsTxt.setText(Integer.toString(attached.getMotorCount()));
            this.velLimitScrl.setMaximum((int)attached.getVelocityMax(0));
            this.velLimitScrl.setMinimum((int)attached.getVelocityMin(0));
            this.velLimitScrl.setMajorTickSpacing((int)attached.getVelocityMax(0) / 64);
            this.accelScrl.setMaximum((int)attached.getAccelerationMax(0));
            this.accelScrl.setMinimum((int)attached.getAccelerationMin(0));
            this.accelScrl.setMajorTickSpacing((int)attached.getAccelerationMin(0) * 4);
            this.targetPosScrl.setMaximum(20000);
            this.targetPosScrl.setMinimum(-20000);
            this.targetPosScrl.setMajorTickSpacing(1000);
            this.targetPosScrl.setMinorTickSpacing(100);
            this.currentPosScrl.setMaximum(20000);
            this.currentPosScrl.setMinimum(-20000);
            this.currentPosScrl.setMajorTickSpacing(1000);
            this.currentPosScrl.setMinorTickSpacing(100);
            for (i = 0; i < attached.getMotorCount(); ++i) {
                this.motorCmb.addItem(new Integer(i));
            }
            this.motorCmb.setSelectedIndex(0);
            this.velLimitScrl.setValueIsAdjusting(true);
            this.velLimitScrl.setValue(this.velLimitScrl.getMinimum());
            this.velLimitScrl.setValueIsAdjusting(false);
            this.velLimitScrl.setEnabled(true);
            this.accelScrl.setValueIsAdjusting(true);
            this.accelScrl.setValue(this.accelScrl.getMinimum());
            this.accelScrl.setValueIsAdjusting(false);
            this.accelScrl.setEnabled(true);
            this.targetPosScrl.setValueIsAdjusting(true);
            this.targetPosScrl.setValue(0);
            this.targetPosScrl.setValueIsAdjusting(false);
            this.targetPosScrl.setEnabled(true);
            this.currentPosScrl.setValueIsAdjusting(true);
            this.currentPosScrl.setValue(0);
            this.currentPosScrl.setValueIsAdjusting(false);
            this.currentPosScrl.setEnabled(true);
            this.engagedChk.setEnabled(true);
            this.motorCmb.setEnabled(true);
            if (attached.getDeviceName().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0) {
                this.jLabel12.setVisible(true);
                this.currentLimitTxt.setVisible(true);
                this.jLabel18.setVisible(true);
                this.currentActualTxt.setVisible(true);
                this.jLabel11.setVisible(true);
                this.currentLimitScrl.setMaximum((int)(attached.getCurrentMax(0) * 100.0));
                this.currentLimitScrl.setMinimum((int)(attached.getCurrentMin(0) * 100.0));
                this.currentLimitScrl.setMajorTickSpacing(5);
                this.currentLimitScrl.setVisible(true);
                this.currentLimitScrl.setEnabled(true);
                for (i = 0; i < attached.getInputCount(); ++i) {
                    this.inputArray[i].setVisible(true);
                }
            } else {
                this.jLabel12.setVisible(false);
                this.currentLimitTxt.setVisible(false);
                this.jLabel18.setVisible(false);
                this.currentActualTxt.setVisible(false);
                this.jLabel11.setVisible(false);
                this.currentLimitScrl.setVisible(false);
                this.currentLimitScrl.setEnabled(false);
                for (i = 0; i < 4; ++i) {
                    this.inputArray[i].setVisible(false);
                }
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

