/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.MotorControlPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MCAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numMotorsTxt;
    private JTextField numInTxt;
    private JTextField currVelTxt;
    private JTextField maxVelTxt;
    private JTextField accelTxt;
    private JTextField currentTxt;
    private JComboBox motorCmb;
    private JSlider maxVelScrl;
    private JSlider accelScrl;
    private JCheckBox[] inputArray;
    private JLabel jLabel10;

    public MCAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numMotorsTxt, JTextField numInTxt, JTextField currVelTxt, JTextField maxVelTxt, JTextField accelTxt, JLabel jLabel10, JTextField currentTxt, JComboBox motorCmb, JSlider maxVelScrl, JSlider accelScrl, JCheckBox[] inputArray) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numMotorsTxt = numMotorsTxt;
        this.numInTxt = numInTxt;
        this.currVelTxt = currVelTxt;
        this.maxVelTxt = maxVelTxt;
        this.accelTxt = accelTxt;
        this.jLabel10 = jLabel10;
        this.currentTxt = currentTxt;
        this.motorCmb = motorCmb;
        this.maxVelScrl = maxVelScrl;
        this.accelScrl = accelScrl;
        this.inputArray = inputArray;
    }

    public void attached(AttachEvent ae) {
        try {
            int i;
            MotorControlPhidget attached = (MotorControlPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numMotorsTxt.setText(Integer.toString(attached.getMotorCount()));
            this.numInTxt.setText(Integer.toString(attached.getInputCount()));
            this.accelScrl.setMaximum((int)attached.getAccelerationMax(0));
            this.accelScrl.setMinimum((int)attached.getAccelerationMin(0) + 1);
            this.accelScrl.setValue((int)attached.getAccelerationMin(0));
            for (i = 0; i < attached.getMotorCount(); ++i) {
                this.motorCmb.addItem(new Integer(i));
            }
            this.motorCmb.setSelectedIndex(0);
            this.motorCmb.setEnabled(true);
            for (i = 0; i < attached.getInputCount(); ++i) {
                this.inputArray[i].setVisible(true);
            }
            if (attached.getDeviceName().compareTo("Phidget Low Voltage Motor Controller 2-motor 4-input") == 0) {
                this.jLabel10.setVisible(false);
                this.currentTxt.setVisible(false);
            } else {
                this.jLabel10.setVisible(true);
                this.currentTxt.setVisible(true);
            }
            this.maxVelScrl.setEnabled(true);
            this.accelScrl.setEnabled(true);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

