/*
 * Decompiled with CFR 0.152.
 */
package MotorControl;

import com.phidgets.MotorControlPhidget;
import com.phidgets.PhidgetException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.MCAttachListener;
import listeners.MCCurrentChangeListener;
import listeners.MCDetachListener;
import listeners.MCErrorListener;
import listeners.MCInputChangeListener;
import listeners.MCVelocityChangeListener;
import org.jdesktop.layout.GroupLayout;

public class MotorControl
extends JFrame {
    private static String[] runArgs;
    private MotorControlPhidget mc;
    private MCAttachListener attach_listener;
    private MCDetachListener detach_listener;
    private MCErrorListener error_listener;
    private MCCurrentChangeListener current_listener;
    private MCInputChangeListener input_listener;
    private MCVelocityChangeListener velocity_listener;
    private JCheckBox[] inputArray;
    private JSlider accelScrl;
    private JTextField accelTxt;
    private JTextField attachedTxt;
    private JTextField currVelTxt;
    private JTextField currentTxt;
    private JCheckBox in0Chk;
    private JCheckBox in1Chk;
    private JCheckBox in2Chk;
    private JCheckBox in3Chk;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSlider maxVelScrl;
    private JTextField maxVelTxt;
    private JComboBox motorCmb;
    private JTextArea nameTxt;
    private JTextField numInTxt;
    private JTextField numMotorsTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;

    public MotorControl() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numMotorsTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.numInTxt = new JTextField();
        this.jLabel13 = new JLabel();
        this.jPanel2 = new JPanel();
        this.motorCmb = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.currVelTxt = new JTextField();
        this.maxVelTxt = new JTextField();
        this.accelTxt = new JTextField();
        this.currentTxt = new JTextField();
        this.maxVelScrl = new JSlider();
        this.accelScrl = new JSlider();
        this.jPanel3 = new JPanel();
        this.in0Chk = new JCheckBox();
        this.in1Chk = new JCheckBox();
        this.in2Chk = new JCheckBox();
        this.in3Chk = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("MotorControl - full");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                MotorControl.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                MotorControl.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("MotorControl Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setFont(new Font("Tahoma", 0, 11));
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        this.numMotorsTxt.setEditable(false);
        this.jLabel5.setText("Motors:");
        this.numInTxt.setEditable(false);
        this.jLabel13.setText("Inputs:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(35, 35, 35).add(jPanel1Layout.createParallelGroup(2).add(this.jLabel1).add(this.jLabel2).add(this.jLabel4).add(this.jLabel3).add(this.jLabel5).add(this.jLabel13)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.numInTxt).add(1, this.numMotorsTxt).add(1, this.versionTxt).add(1, this.serialTxt).add(1, this.attachedTxt).add(1, this.jScrollPane1)).addContainerGap(54, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jScrollPane1, -2, -1, -2).add(this.jLabel2)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numMotorsTxt, -2, -1, -2).add(this.jLabel5)).add(19, 19, 19).add(jPanel1Layout.createParallelGroup(3).add(this.numInTxt, -2, -1, -2).add(this.jLabel13)).addContainerGap(24, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Motor Data"));
        this.motorCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MotorControl.this.motorCmbActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Choose Motor:");
        this.jLabel7.setText("Current Velocity:");
        this.jLabel8.setText("Maximum Velocity:");
        this.jLabel9.setText("Acceleration:");
        this.jLabel10.setText("Current:");
        this.jLabel11.setText("Set Maximum Velocity:");
        this.jLabel12.setText("Set Acceleration:");
        this.currVelTxt.setEditable(false);
        this.maxVelTxt.setEditable(false);
        this.accelTxt.setEditable(false);
        this.currentTxt.setEditable(false);
        this.maxVelScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MotorControl.this.maxVelScrlStateChanged(evt);
            }
        });
        this.accelScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MotorControl.this.accelScrlStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.jLabel11).add(47, 47, 47).add(jPanel2Layout.createParallelGroup(1).add(this.accelScrl, -2, 134, -2).add(this.jLabel12))).add(jPanel2Layout.createParallelGroup(2, false).add(1, jPanel2Layout.createSequentialGroup().add(7, 7, 7).add(jPanel2Layout.createParallelGroup(2).add(this.jLabel6).add(this.jLabel7)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.motorCmb, 0, 165, Short.MAX_VALUE).add(this.currVelTxt, -1, 165, Short.MAX_VALUE))).add(1, jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(2).add(this.jLabel9).add(this.jLabel8).add(this.jLabel10)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.currentTxt, -1, 165, Short.MAX_VALUE).add(this.maxVelTxt, -1, 163, Short.MAX_VALUE).add(this.accelTxt, -1, 165, Short.MAX_VALUE))))).add(95, 95, 95)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.maxVelScrl, -2, 134, -2).addContainerGap(249, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.accelTxt, this.currVelTxt, this.currentTxt, this.maxVelTxt, this.motorCmb}, 1);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel6).add(this.motorCmb, -2, -1, -2)).add(15, 15, 15).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel7).add(this.currVelTxt, -2, -1, -2)).add(14, 14, 14).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel8).add(this.maxVelTxt, -2, -1, -2)).add(14, 14, 14).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel9).add(this.accelTxt, -2, -1, -2)).add(15, 15, 15).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel10).add(this.currentTxt, -2, -1, -2)).add(22, 22, 22).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel11).add(this.jLabel12)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.maxVelScrl, -2, -1, -2).add(this.accelScrl, -2, -1, -2)).addContainerGap(21, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Input Data"));
        this.in0Chk.setText("Input 0");
        this.in0Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in0Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in1Chk.setText("Input 1");
        this.in1Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in1Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in2Chk.setText("Input 2");
        this.in2Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in2Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in3Chk.setText("Input 3");
        this.in3Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in3Chk.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(40, 40, 40).add(this.in0Chk).addPreferredGap(0).add(this.in1Chk).addPreferredGap(0).add(this.in2Chk).addPreferredGap(0).add(this.in3Chk).addContainerGap(39, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(3).add(this.in0Chk).add(this.in1Chk).add(this.in2Chk).add(this.in3Chk)).addContainerGap(23, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2, false).add(1, this.jPanel3, -2, -1, -2).add(1, this.jPanel1, -2, -1, -2).add(1, this.jPanel2, -2, 321, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.jPanel1, this.jPanel2, this.jPanel3}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addPreferredGap(0).add(this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.inputArray = new JCheckBox[4];
        this.inputArray[0] = this.in0Chk;
        this.inputArray[1] = this.in1Chk;
        this.inputArray[2] = this.in2Chk;
        this.inputArray[3] = this.in3Chk;
        for (int i = 0; i < 4; ++i) {
            this.inputArray[i].setVisible(false);
            this.inputArray[i].setEnabled(false);
        }
        this.motorCmb.setEnabled(false);
        this.maxVelScrl.setEnabled(false);
        this.accelScrl.setEnabled(false);
        this.maxVelScrl.setMaximum(100);
        this.maxVelScrl.setMinimum(-100);
        this.jLabel10.setVisible(false);
        this.currentTxt.setVisible(false);
        try {
            this.mc = new MotorControlPhidget();
            this.attach_listener = new MCAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numMotorsTxt, this.numInTxt, this.currVelTxt, this.maxVelTxt, this.accelTxt, this.jLabel10, this.currentTxt, this.motorCmb, this.maxVelScrl, this.accelScrl, this.inputArray);
            this.detach_listener = new MCDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numMotorsTxt, this.numInTxt, this.currVelTxt, this.maxVelTxt, this.accelTxt, this.jLabel10, this.currentTxt, this.motorCmb, this.maxVelScrl, this.accelScrl, this.inputArray);
            this.error_listener = new MCErrorListener(this);
            this.current_listener = new MCCurrentChangeListener(this.currentTxt, this.motorCmb);
            this.input_listener = new MCInputChangeListener(this.inputArray);
            this.velocity_listener = new MCVelocityChangeListener(this.mc, this, this.currVelTxt, this.motorCmb);
            this.mc.addAttachListener(this.attach_listener);
            this.mc.addDetachListener(this.detach_listener);
            this.mc.addErrorListener(this.error_listener);
            this.mc.addCurrentChangeListener(this.current_listener);
            this.mc.addInputChangeListener(this.input_listener);
            this.mc.addMotorVelocityChangeListener(this.velocity_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.mc.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                this.mc.open(Integer.parseInt(runArgs[0]));
            } else {
                this.mc.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void motorCmbActionPerformed(ActionEvent evt) {
        if (this.motorCmb.isEnabled()) {
            try {
                this.maxVelScrl.setValue((int)this.mc.getVelocity((Integer)this.motorCmb.getSelectedItem()));
                this.maxVelTxt.setText(Integer.toString(this.maxVelScrl.getValue()));
            }
            catch (PhidgetException ex) {
                this.maxVelScrl.setValue(0);
                this.maxVelTxt.setText(Integer.toString(this.maxVelScrl.getValue()));
            }
            try {
                this.accelScrl.setValue((int)this.mc.getAcceleration((Integer)this.motorCmb.getSelectedItem()));
                this.accelTxt.setText(Double.toString(this.mc.getAcceleration((Integer)this.motorCmb.getSelectedItem())));
            }
            catch (PhidgetException e) {
                this.accelScrl.setValue(this.accelScrl.getMinimum());
                this.accelTxt.setText(Integer.toString(this.accelScrl.getValue()));
            }
        }
    }

    private void maxVelScrlStateChanged(ChangeEvent evt) {
        if (this.maxVelScrl.isEnabled()) {
            try {
                this.mc.setVelocity((Integer)this.motorCmb.getSelectedItem(), this.maxVelScrl.getValue());
                this.maxVelTxt.setText(Integer.toString(this.maxVelScrl.getValue()));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
                this.attachedTxt.setText("false");
                this.nameTxt.setText("");
                this.serialTxt.setText("");
                this.versionTxt.setText("");
                this.numMotorsTxt.setText("");
                this.numInTxt.setText("");
                this.currVelTxt.setText("");
                this.maxVelTxt.setText("");
                this.accelTxt.setText("");
                this.jLabel10.setVisible(false);
                this.currentTxt.setText("");
                this.currentTxt.setVisible(false);
                this.motorCmb.setSelectedIndex(0);
                this.motorCmb.removeAllItems();
                this.motorCmb.setEnabled(false);
                for (int i = 0; i < 4; ++i) {
                    this.inputArray[i].setVisible(false);
                }
                this.maxVelScrl.setEnabled(false);
                this.accelScrl.setEnabled(false);
            }
        }
    }

    private void accelScrlStateChanged(ChangeEvent evt) {
        if (this.accelScrl.isEnabled()) {
            try {
                this.mc.setAcceleration((Integer)this.motorCmb.getSelectedItem(), this.accelScrl.getValue());
                this.accelTxt.setText(Integer.toString(this.accelScrl.getValue()));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
                this.attachedTxt.setText("false");
                this.nameTxt.setText("");
                this.serialTxt.setText("");
                this.versionTxt.setText("");
                this.numMotorsTxt.setText("");
                this.numInTxt.setText("");
                this.currVelTxt.setText("");
                this.maxVelTxt.setText("");
                this.accelTxt.setText("");
                this.jLabel10.setVisible(false);
                this.currentTxt.setText("");
                this.currentTxt.setVisible(false);
                this.motorCmb.setSelectedIndex(0);
                this.motorCmb.removeAllItems();
                this.motorCmb.setEnabled(false);
                for (int i = 0; i < 4; ++i) {
                    this.inputArray[i].setVisible(false);
                }
                this.maxVelScrl.setEnabled(false);
                this.accelScrl.setEnabled(false);
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.mc.removeMotorVelocityChangeListener(this.velocity_listener);
            this.mc.removeInputChangeListener(this.input_listener);
            this.mc.removeCurrentChangeListener(this.current_listener);
            this.mc.removeErrorListener(this.error_listener);
            this.mc.removeDetachListener(this.detach_listener);
            this.mc.removeAttachListener(this.attach_listener);
            for (int i = 0; i < this.mc.getMotorCount(); ++i) {
                this.mc.setVelocity(i, 0.0);
            }
            this.mc.close();
            this.mc = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MotorControl().setVisible(true);
            }
        });
    }
}

