/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.PhidgetException;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import com.phidgets.event.DetachEvent;
import com.phidgets.event.DetachListener;
import com.phidgets.event.ErrorEvent;
import com.phidgets.event.ErrorListener;
import com.phidgets.event.ServerConnectEvent;
import com.phidgets.event.ServerConnectListener;
import com.phidgets.event.ServerDisconnectEvent;
import com.phidgets.event.ServerDisconnectListener;
import java.util.Iterator;
import java.util.LinkedList;

public class Phidget {
    private long handle = 0L;
    public static final int PHIDGET_LOG_CRITICAL = 1;
    public static final int PHIDGET_LOG_ERROR = 2;
    public static final int PHIDGET_LOG_WARNING = 3;
    public static final int PHIDGET_LOG_DEBUG = 4;
    public static final int PHIDGET_LOG_INFO = 5;
    public static final int PHIDGET_LOG_VERBOSE = 6;
    public static final int PHIDID_NOTHING = 1;
    public static final int PHIDID_ACCELEROMETER_2AXIS = 113;
    public static final int PHIDID_ACCELEROMETER_3AXIS = 126;
    public static final int PHIDID_ADVANCEDSERVO_8MOTOR = 58;
    public static final int PHIDID_BIPOLAR_STEPPER_1MOTOR = 123;
    public static final int PHIDID_ENCODER_1ENCODER_1INPUT = 75;
    public static final int PHIDID_ENCODER_HS_1ENCODER = 128;
    public static final int PHIDID_INTERFACEKIT_0_0_4 = 64;
    public static final int PHIDID_INTERFACEKIT_0_0_8 = 129;
    public static final int PHIDID_INTERFACEKIT_0_16_16 = 68;
    public static final int PHIDID_INTERFACEKIT_8_8_8 = 69;
    public static final int PHIDID_INTERFACEKIT_8_8_8_w_LCD = 125;
    public static final int PHIDID_LED_64 = 74;
    public static final int PHIDID_LINEAR_TOUCH = 118;
    public static final int PHIDID_MOTORCONTROL_HC_2MOTOR = 89;
    public static final int PHIDID_MOTORCONTROL_LV_2MOTOR_4INPUT = 88;
    public static final int PHIDID_PHSENSOR = 116;
    public static final int PHIDID_RFID_2OUTPUT = 49;
    public static final int PHIDID_ROTARY_TOUCH = 119;
    public static final int PHIDID_SERVO_1MOTOR = 57;
    public static final int PHIDID_TEMPERATURESENSOR = 112;
    public static final int PHIDID_TEXTLCD_2x20_w_8_8_8 = 381;
    public static final int PHIDID_UNIPOLAR_STEPPER_4MOTOR = 122;
    public static final int PHIDID_INTERFACEKIT_0_8_8_w_LCD = 83;
    public static final int PHIDID_INTERFACEKIT_4_8_8 = 4;
    public static final int PHIDID_RFID = 48;
    public static final int PHIDID_SERVO_1MOTOR_OLD = 2;
    public static final int PHIDID_SERVO_4MOTOR = 56;
    public static final int PHIDID_SERVO_4MOTOR_OLD = 3;
    public static final int PHIDID_TEXTLCD_2x20 = 82;
    public static final int PHIDID_TEXTLCD_2x20_w_0_8_8 = 339;
    public static final int PHIDID_TEXTLED_1x8 = 73;
    public static final int PHIDID_TEXTLED_4x8 = 72;
    public static final int PHIDID_WEIGHTSENSOR = 114;
    public static final int PHIDCLASS_NOTHING = 1;
    public static final int PHIDCLASS_ACCELEROMETER = 2;
    public static final int PHIDCLASS_ADVANCEDSERVO = 3;
    public static final int PHIDCLASS_ENCODER = 4;
    public static final int PHIDCLASS_INTERFACEKIT = 7;
    public static final int PHIDCLASS_LED = 8;
    public static final int PHIDCLASS_MOTORCONTROL = 9;
    public static final int PHIDCLASS_PHSENSOR = 10;
    public static final int PHIDCLASS_RFID = 11;
    public static final int PHIDCLASS_SERVO = 12;
    public static final int PHIDCLASS_STEPPER = 13;
    public static final int PHIDCLASS_TEMPERATURESENSOR = 14;
    public static final int PHIDCLASS_TEXTLCD = 15;
    public static final int PHIDCLASS_TEXTLED = 16;
    public static final int PHIDCLASS_WEIGHTSENSOR = 17;
    private LinkedList attachListeners = new LinkedList();
    private long nativeAttachHandler = 0L;
    private LinkedList errorListeners = new LinkedList();
    private long nativeErrorHandler = 0L;
    private LinkedList detachListeners = new LinkedList();
    private long nativeDetachHandler = 0L;
    private LinkedList serverConnectListeners = new LinkedList();
    private long nativeServerConnectHandler = 0L;
    private LinkedList serverDisconnectListeners = new LinkedList();
    private long nativeServerDisconnectHandler = 0L;

    public Phidget(long l) {
        this.handle = l;
    }

    private final long getHandle() {
        return this.handle;
    }

    public static final native String getLibraryVersion();

    private static final native void nativeEnableLogging(int var0, String var1);

    public static final void enableLogging(int n, String string) {
        Phidget.nativeEnableLogging(n, string);
    }

    public static final native void disableLogging();

    private static final native void nativeLog(int var0, String var1, String var2);

    public static final void log(int n, String string, String string2) {
        Phidget.nativeLog(n, string, string2);
    }

    public final native int getDeviceID() throws PhidgetException;

    public final native int getDeviceClass() throws PhidgetException;

    public final native int getSerialNumber() throws PhidgetException;

    public final native int getDeviceVersion() throws PhidgetException;

    public final native String getDeviceType() throws PhidgetException;

    public final native String getDeviceName() throws PhidgetException;

    public final native boolean isAttached() throws PhidgetException;

    public final native boolean isAttachedToServer() throws PhidgetException;

    public final native String getDeviceLabel() throws PhidgetException;

    public final native void setDeviceLabel(String var1) throws PhidgetException;

    public final native String getServerAddress() throws PhidgetException;

    public final native String getServerID() throws PhidgetException;

    public final native int getServerPort() throws PhidgetException;

    private final native void nativeClose() throws PhidgetException;

    private final native void nativeDelete() throws PhidgetException;

    private final native void nativeOpen(int var1) throws PhidgetException;

    private final native void nativeOpenRemote(int var1, String var2, String var3) throws PhidgetException;

    private final native void nativeOpenRemoteIP(int var1, String var2, int var3, String var4) throws PhidgetException;

    public final void open(int n) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpen(n);
    }

    public final void open(int n, String string, int n2) throws PhidgetException {
        this.open(n, string, n2, "");
    }

    public final void open(int n, String string, int n2, String string2) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpenRemoteIP(n, string, n2, string2);
    }

    public final void open(int n, String string) throws PhidgetException {
        this.open(n, string, "");
    }

    public final void open(int n, String string, String string2) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpenRemote(n, string, string2);
    }

    public final void openAny() throws PhidgetException {
        this.open(-1);
    }

    public final void openAny(String string, int n) throws PhidgetException {
        this.open(-1, string, n, "");
    }

    public final void openAny(String string, int n, String string2) throws PhidgetException {
        this.open(-1, string, n, string2);
    }

    public final void openAny(String string) throws PhidgetException {
        this.open(-1, string, "");
    }

    public final void openAny(String string, String string2) throws PhidgetException {
        this.open(-1, string, string2);
    }

    public final void close() throws PhidgetException {
        this.enableEvents(false);
        this.nativeClose();
    }

    private void enableEvents(boolean bl) {
        this.enableAttachEvents(bl && this.attachListeners.size() > 0);
        this.enableDetachEvents(bl && this.detachListeners.size() > 0);
        this.enableErrorEvents(bl && this.errorListeners.size() > 0);
        this.enableServerConnectEvents(bl && this.serverConnectListeners.size() > 0);
        this.enableServerDisconnectEvents(bl && this.serverDisconnectListeners.size() > 0);
        this.enableDeviceSpecificEvents(bl);
    }

    public final native void waitForAttachment(int var1) throws PhidgetException;

    public final void waitForAttachment() throws PhidgetException {
        this.waitForAttachment(0);
    }

    private void enableDeviceSpecificEvents(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAttachListener(AttachListener attachListener) {
        LinkedList linkedList = this.attachListeners;
        synchronized (linkedList) {
            this.attachListeners.add(attachListener);
            this.enableAttachEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAttachListener(AttachListener attachListener) {
        LinkedList linkedList = this.attachListeners;
        synchronized (linkedList) {
            this.attachListeners.remove(attachListener);
            this.enableAttachEvents(this.attachListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAttach(AttachEvent attachEvent) {
        LinkedList linkedList = this.attachListeners;
        synchronized (linkedList) {
            Iterator iterator = this.attachListeners.iterator();
            while (iterator.hasNext()) {
                ((AttachListener)iterator.next()).attached(attachEvent);
            }
        }
    }

    private native void enableAttachEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addErrorListener(ErrorListener errorListener) {
        LinkedList linkedList = this.errorListeners;
        synchronized (linkedList) {
            this.errorListeners.add(errorListener);
            this.enableErrorEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeErrorListener(ErrorListener errorListener) {
        LinkedList linkedList = this.errorListeners;
        synchronized (linkedList) {
            this.errorListeners.remove(errorListener);
            this.enableErrorEvents(this.errorListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireError(ErrorEvent errorEvent) {
        LinkedList linkedList = this.errorListeners;
        synchronized (linkedList) {
            Iterator iterator = this.errorListeners.iterator();
            while (iterator.hasNext()) {
                ((ErrorListener)iterator.next()).error(errorEvent);
            }
        }
    }

    private native void enableErrorEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDetachListener(DetachListener detachListener) {
        LinkedList linkedList = this.detachListeners;
        synchronized (linkedList) {
            this.detachListeners.add(detachListener);
            this.enableDetachEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDetachListener(DetachListener detachListener) {
        LinkedList linkedList = this.detachListeners;
        synchronized (linkedList) {
            this.detachListeners.remove(detachListener);
            this.enableDetachEvents(this.detachListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDetach(DetachEvent detachEvent) {
        LinkedList linkedList = this.detachListeners;
        synchronized (linkedList) {
            Iterator iterator = this.detachListeners.iterator();
            while (iterator.hasNext()) {
                ((DetachListener)iterator.next()).detached(detachEvent);
            }
        }
    }

    private native void enableDetachEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addServerConnectListener(ServerConnectListener serverConnectListener) {
        LinkedList linkedList = this.serverConnectListeners;
        synchronized (linkedList) {
            this.serverConnectListeners.add(serverConnectListener);
            this.enableServerConnectEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeServerConnectListener(ServerConnectListener serverConnectListener) {
        LinkedList linkedList = this.serverConnectListeners;
        synchronized (linkedList) {
            this.serverConnectListeners.remove(serverConnectListener);
            this.enableServerConnectEvents(this.serverConnectListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServerConnect(ServerConnectEvent serverConnectEvent) {
        LinkedList linkedList = this.serverConnectListeners;
        synchronized (linkedList) {
            Iterator iterator = this.serverConnectListeners.iterator();
            while (iterator.hasNext()) {
                ((ServerConnectListener)iterator.next()).serverConnected(serverConnectEvent);
            }
        }
    }

    private native void enableServerConnectEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addServerDisconnectListener(ServerDisconnectListener serverDisconnectListener) {
        LinkedList linkedList = this.serverDisconnectListeners;
        synchronized (linkedList) {
            this.serverDisconnectListeners.add(serverDisconnectListener);
            this.enableServerDisconnectEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeServerDisconnectListener(ServerDisconnectListener serverDisconnectListener) {
        LinkedList linkedList = this.serverDisconnectListeners;
        synchronized (linkedList) {
            this.serverDisconnectListeners.remove(serverDisconnectListener);
            this.enableServerDisconnectEvents(this.serverDisconnectListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServerDisconnect(ServerDisconnectEvent serverDisconnectEvent) {
        LinkedList linkedList = this.serverDisconnectListeners;
        synchronized (linkedList) {
            Iterator iterator = this.serverDisconnectListeners.iterator();
            while (iterator.hasNext()) {
                ((ServerDisconnectListener)iterator.next()).serverDisconnected(serverDisconnectEvent);
            }
        }
    }

    private native void enableServerDisconnectEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n = -1;
        int n2 = -1;
        String string = null;
        String string2 = "";
        try {
            try {
                n = this.getDeviceVersion();
                n2 = this.getSerialNumber();
                string = this.getDeviceType();
                string2 = this.isAttached() ? " (attached)" : " (unattached)";
            }
            catch (PhidgetException phidgetException) {
                Object var7_6 = null;
                if (string == null) {
                    string = this.getClass().getName().replaceFirst(".*\\.", "");
                }
            }
            Object var7_5 = null;
            if (string == null) {
                string = this.getClass().getName().replaceFirst(".*\\.", "");
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (string == null) {
                string = this.getClass().getName().replaceFirst(".*\\.", "");
            }
            throw throwable;
        }
        return string + " v" + n + " #" + n2 + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nativeDelete();
        }
        catch (Exception exception) {
        }
        finally {
            this.handle = 0L;
            super.finalize();
        }
    }

    public boolean equals(Object object) {
        Phidget phidget = (Phidget)object;
        try {
            if (phidget.getSerialNumber() == this.getSerialNumber() && phidget.getDeviceType().equals(this.getDeviceType()) && phidget.getDeviceVersion() == this.getDeviceVersion()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        System.loadLibrary("phidget21");
    }
}

