/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.PhidgetException;
import com.phidgets.event.ServerConnectEvent;
import com.phidgets.event.ServerConnectListener;
import com.phidgets.event.ServerDisconnectEvent;
import com.phidgets.event.ServerDisconnectListener;
import java.util.Iterator;
import java.util.LinkedList;

public class Dictionary {
    public long handle = 0L;
    private LinkedList serverConnectListeners = new LinkedList();
    private long nativeServerConnectHandler = 0L;
    private LinkedList serverDisconnectListeners = new LinkedList();
    private long nativeServerDisconnectHandler = 0L;

    public Dictionary() throws PhidgetException {
        this.handle = this.create();
    }

    private final native long create() throws PhidgetException;

    private final native void nativeClose() throws PhidgetException;

    private final native void nativeDelete() throws PhidgetException;

    private final native void nativeOpenRemote(String var1, String var2) throws PhidgetException;

    private final native void nativeOpenRemoteIP(String var1, int var2, String var3) throws PhidgetException;

    private final native void nativeAddKey(String var1, String var2, int var3) throws PhidgetException;

    private final native void nativeRemoveKey(String var1) throws PhidgetException;

    private final native String nativeGetKey(String var1) throws PhidgetException;

    public final native String getServerAddress() throws PhidgetException;

    public final native String getServerID() throws PhidgetException;

    public final native int getServerPort() throws PhidgetException;

    public final native boolean isAttached() throws PhidgetException;

    public final native boolean isAttachedToServer() throws PhidgetException;

    public final void add(String string, String string2) throws PhidgetException {
        this.nativeAddKey(string, string2, 1);
    }

    public final void add(String string, String string2, boolean bl) throws PhidgetException {
        if (bl) {
            this.nativeAddKey(string, string2, 1);
        } else {
            this.nativeAddKey(string, string2, 0);
        }
    }

    public final void remove(String string) throws PhidgetException {
        this.nativeRemoveKey(string);
    }

    public final String get(String string) throws PhidgetException {
        return this.nativeGetKey(string);
    }

    public final void open(String string, int n, String string2) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpenRemoteIP(string, n, string2);
    }

    public final void open(String string, int n) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpenRemoteIP(string, n, "");
    }

    public final void open(String string, String string2) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpenRemote(string, string2);
    }

    public final void open(String string) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpenRemote(string, "");
    }

    public final void close() throws PhidgetException {
        this.enableEvents(false);
        this.nativeClose();
    }

    private void enableEvents(boolean bl) {
        this.enableServerConnectEvents(bl && this.serverConnectListeners.size() > 0);
        this.enableServerDisconnectEvents(bl && this.serverDisconnectListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addServerConnectListener(ServerConnectListener serverConnectListener) {
        LinkedList linkedList = this.serverConnectListeners;
        synchronized (linkedList) {
            this.serverConnectListeners.add(serverConnectListener);
            this.enableServerConnectEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeServerConnectListener(ServerConnectListener serverConnectListener) {
        LinkedList linkedList = this.serverConnectListeners;
        synchronized (linkedList) {
            this.serverConnectListeners.remove(serverConnectListener);
            this.enableServerConnectEvents(this.serverConnectListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServerConnect(ServerConnectEvent serverConnectEvent) {
        LinkedList linkedList = this.serverConnectListeners;
        synchronized (linkedList) {
            Iterator iterator = this.serverConnectListeners.iterator();
            while (iterator.hasNext()) {
                ((ServerConnectListener)iterator.next()).serverConnected(serverConnectEvent);
            }
        }
    }

    private native void enableServerConnectEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addServerDisconnectListener(ServerDisconnectListener serverDisconnectListener) {
        LinkedList linkedList = this.serverDisconnectListeners;
        synchronized (linkedList) {
            this.serverDisconnectListeners.add(serverDisconnectListener);
            this.enableServerDisconnectEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeServerDisconnectListener(ServerDisconnectListener serverDisconnectListener) {
        LinkedList linkedList = this.serverDisconnectListeners;
        synchronized (linkedList) {
            this.serverDisconnectListeners.remove(serverDisconnectListener);
            this.enableServerDisconnectEvents(this.serverDisconnectListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServerDisconnect(ServerDisconnectEvent serverDisconnectEvent) {
        LinkedList linkedList = this.serverDisconnectListeners;
        synchronized (linkedList) {
            Iterator iterator = this.serverDisconnectListeners.iterator();
            while (iterator.hasNext()) {
                ((ServerDisconnectListener)iterator.next()).serverDisconnected(serverDisconnectEvent);
            }
        }
    }

    private native void enableServerDisconnectEvents(boolean var1);

    public String toString() {
        return "PhidgetDictionary: ";
    }

    protected void finalize() {
        try {
            this.close();
            this.nativeDelete();
            this.handle = 0L;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        System.loadLibrary("phidget21");
    }
}

