/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.CurrentChangeEvent;
import com.phidgets.event.CurrentChangeListener;
import com.phidgets.event.InputChangeEvent;
import com.phidgets.event.InputChangeListener;
import com.phidgets.event.MotorVelocityChangeEvent;
import com.phidgets.event.MotorVelocityChangeListener;
import java.util.Iterator;
import java.util.LinkedList;

public final class MotorControlPhidget
extends Phidget {
    private LinkedList motorVelocityChangeListeners = new LinkedList();
    private long nativeMotorVelocityChangeHandler = 0L;
    private LinkedList currentChangeListeners = new LinkedList();
    private long nativeCurrentChangeHandler = 0L;
    private LinkedList inputChangeListeners = new LinkedList();
    private long nativeInputChangeHandler = 0L;

    public MotorControlPhidget() throws PhidgetException {
        super(MotorControlPhidget.create());
    }

    private static native long create() throws PhidgetException;

    public native int getMotorCount() throws PhidgetException;

    public native int getInputCount() throws PhidgetException;

    public native boolean getInputState(int var1) throws PhidgetException;

    public native double getAcceleration(int var1) throws PhidgetException;

    public native void setAcceleration(int var1, double var2) throws PhidgetException;

    public native double getAccelerationMax(int var1) throws PhidgetException;

    public native double getAccelerationMin(int var1) throws PhidgetException;

    public native double getVelocity(int var1) throws PhidgetException;

    public native double getSpeed(int var1) throws PhidgetException;

    public native void setVelocity(int var1, double var2) throws PhidgetException;

    public native void setSpeed(int var1, double var2) throws PhidgetException;

    public native double getCurrent(int var1) throws PhidgetException;

    private final void enableDeviceSpecificEvents(boolean bl) {
        this.enableMotorVelocityChangeEvents(bl && this.motorVelocityChangeListeners.size() > 0);
        this.enableCurrentChangeEvents(bl && this.currentChangeListeners.size() > 0);
        this.enableInputChangeEvents(bl && this.inputChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMotorVelocityChangeListener(MotorVelocityChangeListener motorVelocityChangeListener) {
        LinkedList linkedList = this.motorVelocityChangeListeners;
        synchronized (linkedList) {
            this.motorVelocityChangeListeners.add(motorVelocityChangeListener);
            this.enableMotorVelocityChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMotorVelocityChangeListener(MotorVelocityChangeListener motorVelocityChangeListener) {
        LinkedList linkedList = this.motorVelocityChangeListeners;
        synchronized (linkedList) {
            this.motorVelocityChangeListeners.remove(motorVelocityChangeListener);
            this.enableMotorVelocityChangeEvents(this.motorVelocityChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMotorVelocityChange(MotorVelocityChangeEvent motorVelocityChangeEvent) {
        LinkedList linkedList = this.motorVelocityChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.motorVelocityChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((MotorVelocityChangeListener)iterator.next()).motorVelocityChanged(motorVelocityChangeEvent);
            }
        }
    }

    private native void enableMotorVelocityChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCurrentChangeListener(CurrentChangeListener currentChangeListener) {
        LinkedList linkedList = this.currentChangeListeners;
        synchronized (linkedList) {
            this.currentChangeListeners.add(currentChangeListener);
            this.enableCurrentChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCurrentChangeListener(CurrentChangeListener currentChangeListener) {
        LinkedList linkedList = this.currentChangeListeners;
        synchronized (linkedList) {
            this.currentChangeListeners.remove(currentChangeListener);
            this.enableCurrentChangeEvents(this.currentChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCurrentChange(CurrentChangeEvent currentChangeEvent) {
        LinkedList linkedList = this.currentChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.currentChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((CurrentChangeListener)iterator.next()).currentChanged(currentChangeEvent);
            }
        }
    }

    private native void enableCurrentChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addInputChangeListener(InputChangeListener inputChangeListener) {
        LinkedList linkedList = this.inputChangeListeners;
        synchronized (linkedList) {
            this.inputChangeListeners.add(inputChangeListener);
            this.enableInputChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeInputChangeListener(InputChangeListener inputChangeListener) {
        LinkedList linkedList = this.inputChangeListeners;
        synchronized (linkedList) {
            this.inputChangeListeners.remove(inputChangeListener);
            this.enableInputChangeEvents(this.inputChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInputChange(InputChangeEvent inputChangeEvent) {
        LinkedList linkedList = this.inputChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.inputChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((InputChangeListener)iterator.next()).inputChanged(inputChangeEvent);
            }
        }
    }

    private native void enableInputChangeEvents(boolean var1);
}

