/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.ServoPhidget;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ServoAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numServoTxt;
    private JComboBox servoCmb;
    private JComboBox servoTypeCmb;
    private JTextField positionTxt;
    private JSlider positionScrl;
    private JCheckBox engagedChk;
    private Hashtable servoTypes;

    public ServoAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numServoTxt, JComboBox servoCmb, JComboBox servoTypeCmb, JTextField positionTxt, JSlider positionScrl, JCheckBox engagedChk, Hashtable servoTypes) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numServoTxt = numServoTxt;
        this.servoCmb = servoCmb;
        this.servoTypeCmb = servoTypeCmb;
        this.positionTxt = positionTxt;
        this.positionScrl = positionScrl;
        this.engagedChk = engagedChk;
        this.servoTypes = servoTypes;
    }

    public void attached(AttachEvent ae) {
        try {
            ServoPhidget attached = (ServoPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numServoTxt.setText(Integer.toString(attached.getMotorCount()));
            this.positionScrl.setMaximum((int)attached.getPositionMax(0));
            this.positionScrl.setMinimum((int)attached.getPositionMin(0));
            this.servoCmb.setEnabled(true);
            for (int i = 0; i < attached.getMotorCount(); ++i) {
                this.servoCmb.addItem(new Integer(i));
                attached.setServoType(i, 3);
            }
            this.servoCmb.setSelectedIndex(0);
            Enumeration e = this.servoTypes.keys();
            while (e.hasMoreElements()) {
                this.servoTypeCmb.addItem(e.nextElement());
            }
            this.servoTypeCmb.setEnabled(true);
            try {
                this.positionTxt.setText(Double.toString(attached.getPosition(0)));
                this.positionScrl.setValue((int)attached.getPosition(0));
                this.engagedChk.setSelected(attached.getEngaged(0));
            }
            catch (PhidgetException ex2) {
                this.positionTxt.setText("Unknown");
                this.positionScrl.setValue(0);
                this.engagedChk.setSelected(false);
            }
            this.engagedChk.setEnabled(true);
            this.positionScrl.setEnabled(true);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

