/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.TemperatureSensorPhidget;
import com.phidgets.event.TemperatureChangeEvent;
import com.phidgets.event.TemperatureChangeListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class TempSensorTemperatureChangeListener
implements TemperatureChangeListener {
    private JFrame appFrame;
    private JTextField potTxt;
    private JTextField tcTempTxt;
    private JTextField onBoardTxt;

    public TempSensorTemperatureChangeListener(JFrame appFrame, JTextField potTxt, JTextField tcTempTxt, JTextField onBoardTxt) {
        this.appFrame = appFrame;
        this.potTxt = potTxt;
        this.tcTempTxt = tcTempTxt;
        this.onBoardTxt = onBoardTxt;
    }

    public void temperatureChanged(TemperatureChangeEvent temperatureChangeEvent) {
        try {
            TemperatureSensorPhidget source = (TemperatureSensorPhidget)temperatureChangeEvent.getSource();
            if (temperatureChangeEvent.getIndex() == 0) {
                this.onBoardTxt.setText(Double.toString(source.getAmbientTemperature()));
                this.tcTempTxt.setText(Double.toString(source.getTemperature(temperatureChangeEvent.getIndex())));
                this.potTxt.setText(Double.toString(source.getPotential(temperatureChangeEvent.getIndex())));
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

