/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.TemperatureSensorPhidget;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TempSensorAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numTCTxt;
    private JSlider sensitivityScrl;
    private JTextField sensitivityTxt;
    private JTextField potTxt;
    private JLabel potentialRngLbl;
    private JTextField tcTempTxt;
    private JLabel thermoRngLbl;
    private JTextField onBoardTxt;
    private JLabel ambientRngLbl;
    private JComboBox thermoTypeCmb;

    public TempSensorAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numTCTxt, JSlider sensitivityScrl, JTextField potTxt, JLabel potentialRngLbl, JTextField tcTempTxt, JLabel thermoRngLbl, JTextField sensitivityTxt, JTextField onBoardTxt, JLabel ambientRngLbl, JComboBox thermoTypeCmb) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numTCTxt = numTCTxt;
        this.sensitivityScrl = sensitivityScrl;
        this.sensitivityTxt = sensitivityTxt;
        this.potTxt = potTxt;
        this.potentialRngLbl = potentialRngLbl;
        this.tcTempTxt = tcTempTxt;
        this.thermoRngLbl = thermoRngLbl;
        this.onBoardTxt = onBoardTxt;
        this.ambientRngLbl = ambientRngLbl;
        this.thermoTypeCmb = thermoTypeCmb;
    }

    public void attached(AttachEvent ae) {
        try {
            TemperatureSensorPhidget attached = (TemperatureSensorPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numTCTxt.setText(Integer.toString(attached.getSensorCount()));
            this.onBoardTxt.setText(Double.toString(attached.getAmbientTemperature()));
            this.sensitivityScrl.setEnabled(true);
            this.sensitivityScrl.setValue((int)attached.getTemperatureChangeTrigger(0) * 100);
            this.sensitivityTxt.setText(Integer.toString(this.sensitivityScrl.getValue()));
            this.thermoRngLbl.setText("(" + attached.getTemperatureMin(0) + "\u00b0C - " + attached.getTemperatureMax(0) + "\u00b0C)");
            try {
                this.potentialRngLbl.setText("(" + attached.getPotentialMin(0) + "mV - " + attached.getPotentialMax(0) + "mV)");
            }
            catch (PhidgetException ex) {
                this.potentialRngLbl.setText("(Not Supported)");
            }
            this.ambientRngLbl.setText("(" + attached.getAmbientTemperatureMin() + "\u00b0C - " + attached.getAmbientTemperatureMax() + "\u00b0C)");
            this.thermoTypeCmb.setEnabled(true);
            switch (attached.getThermocoupleType(0)) {
                case 1: {
                    this.thermoTypeCmb.setSelectedItem("K-Type");
                    break;
                }
                case 2: {
                    this.thermoTypeCmb.setSelectedItem("J-Type");
                    break;
                }
                case 3: {
                    this.thermoTypeCmb.setSelectedItem("E-Type");
                    break;
                }
                case 4: {
                    this.thermoTypeCmb.setSelectedItem("T-Type");
                }
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

