/*
 * Decompiled with CFR 0.152.
 */
package PhidgetControlPanel;

import com.phidgets.Manager;
import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import listeners.ManagerAttachListener;
import listeners.ManagerDetachListener;
import org.jdesktop.layout.GroupLayout;

public class PhidgetControlPanel
extends JFrame {
    private Manager manager;
    private ManagerAttachListener attach_listener;
    private ManagerDetachListener detach_listener;
    private String[][] name_list;
    private JTable deviceTbl;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;

    public PhidgetControlPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.deviceTbl = new JTable();
        this.setDefaultCloseOperation(3);
        this.setTitle("PhidgetControlPanel");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                PhidgetControlPanel.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                PhidgetControlPanel.this.formWindowOpened(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 12));
        this.jLabel1.setText("Status");
        this.jLabel2.setFont(new Font("Tahoma", 1, 12));
        this.jLabel2.setText("Library Information");
        this.jLabel3.setText("jLabel3");
        this.deviceTbl.setModel(new DefaultTableModel(new Object[0][], new String[]{"Device Name", "Serial No.", "Version", "Attached"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.deviceTbl);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(21, 21, 21).add(this.jLabel3)).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel2)).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel1)).add(layout.createSequentialGroup().addContainerGap().add(this.jScrollPane1, -1, 475, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel1).addPreferredGap(0).add(this.jScrollPane1, -2, 130, -2).addPreferredGap(0).add(this.jLabel2).addPreferredGap(0).add(this.jLabel3).addContainerGap(35, Short.MAX_VALUE)));
        this.pack();
    }

    private String nameToExample(String name) {
        if (name.compareTo("Phidget Servo Controller 1-motor") == 0 || name.compareTo("Phidget Servo Controller 4-motor") == 0) {
            return "Servo-full.jar";
        }
        if (name.compareTo("Phidget InterfaceKit 8/8/8") == 0 || name.compareTo("Phidget InterfaceKit 0/0/4") == 0 || name.compareTo("Phidget InterfaceKit 0/16/16") == 0 || name.compareTo("Phidget InterfaceKit 0/5/7") == 0 || name.compareTo("Phidget InterfaceKit 0/8/8") == 0 || name.compareTo("Phidget InterfaceKit 0/0/8") == 0 || name.compareTo("Phidget Joystick Interface Kit") == 0 || name.compareTo("Phidget Touch Slider") == 0 || name.compareTo("Phidget Touch Rotation") == 0) {
            return "InterfaceKit-full.jar";
        }
        if (name.compareTo("Phidget Accelerometer 2-axis") == 0 || name.compareTo("Phidget Accelerometer 3-axis") == 0) {
            return "Accelerometer-full.jar";
        }
        if (name.compareTo("Phidget TextLCD Custom") == 0 || name.compareTo("Phidget TextLCD") == 0) {
            return "TextLCD-full.jar";
        }
        if (name.compareTo("Phidget RFID") == 0 || name.compareTo("Phidget RFID 2-output") == 0) {
            return "RFID-full.jar";
        }
        if (name.compareTo("Phidget Low Voltage Motor Controller 2-motor 4-input") == 0 || name.compareTo("Phidget High Current Motor Controller 2-motor") == 0) {
            return "MotorControl-full.jar";
        }
        if (name.compareTo("Phidget Temperature Sensor") == 0) {
            return "TemperatureSensor-full.jar";
        }
        if (name.compareTo("Phidget LED 64") == 0) {
            return "LED-full.jar";
        }
        if (name.compareTo("Phidget Stepper") == 0 || name.compareTo("Phidget Unipolar Stepper Controller 4-motor") == 0 || name.compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0) {
            return "Stepper-full.jar";
        }
        if (name.compareTo("Phidget Encoder 1-encoder 1-input") == 0 || name.compareTo("Phidget High Speed Encoder 1-encoder") == 0 || name.compareTo("Phidget Encoder 4-encoder 4-input") == 0) {
            return "Encoder-full.jar";
        }
        if (name.compareTo("Phidget PH Sensor") == 0) {
            return "PHSensor-full.jar";
        }
        if (name.compareTo("Phidget Advanced Servo Controller 8-motor") == 0) {
            return "AdvancedServo-full.jar";
        }
        return "PhidgetControlPanel-full.jar";
    }

    private void deviceTblMouseDblClicked(int row, int col) {
        String serialNum = (String)this.deviceTbl.getModel().getValueAt(row, 1);
        String deviceName = (String)this.deviceTbl.getModel().getValueAt(row, 0);
        String example = this.nameToExample(deviceName);
        String rundir = System.getProperty("user.dir");
        String command = "java";
        String arg1 = "-jar";
        String arg2 = "" + rundir + "\\" + example;
        String arg3 = serialNum;
        try {
            ProcessBuilder pb = new ProcessBuilder(command, arg1, arg2, arg3);
            Process p = pb.start();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "External Process Error", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Unexpected Exception, Exiting: " + ex.getMessage() + "\n" + ex.getStackTrace().toString(), "Phidget21Manager Fatal Exception", 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void formWindowOpened(WindowEvent evt) {
        try {
            this.jLabel3.setText(Phidget.getLibraryVersion());
            this.deviceTbl.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.deviceTbl.getColumnModel().getColumn(0).setResizable(false);
            this.deviceTbl.getColumnModel().getColumn(1).setPreferredWidth(80);
            this.deviceTbl.getColumnModel().getColumn(1).setResizable(false);
            this.deviceTbl.getColumnModel().getColumn(2).setPreferredWidth(75);
            this.deviceTbl.getColumnModel().getColumn(2).setResizable(false);
            this.deviceTbl.getColumnModel().getColumn(3).setPreferredWidth(75);
            this.deviceTbl.getColumnModel().getColumn(3).setResizable(false);
            this.deviceTbl.getTableHeader().setReorderingAllowed(false);
            this.deviceTbl.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evnt) {
                    if (evnt.getClickCount() > 1) {
                        int row = PhidgetControlPanel.this.deviceTbl.rowAtPoint(new Point(evnt.getX(), evnt.getY()));
                        int column = PhidgetControlPanel.this.deviceTbl.columnAtPoint(new Point(evnt.getX(), evnt.getY()));
                        PhidgetControlPanel.this.deviceTblMouseDblClicked(row, column);
                    }
                }
            });
            this.manager = new Manager();
            this.attach_listener = new ManagerAttachListener(this, this.deviceTbl);
            this.detach_listener = new ManagerDetachListener(this, this.deviceTbl);
            this.manager.addAttachListener(this.attach_listener);
            this.manager.addDetachListener(this.detach_listener);
            this.manager.open();
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Unexpected Exception, Exiting: " + ex.getMessage() + "\n" + ex.getStackTrace().toString(), "Phidget21Manager Fatal Exception", 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.manager.removeAttachListener(this.attach_listener);
            this.manager.removeDetachListener(this.detach_listener);
            this.manager.close();
            this.manager = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(null, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Unexpected Exception, Exiting: " + ex.getMessage() + "\n" + ex.getStackTrace().toString(), "Phidget21Manager Fatal Exception", 0);
            this.dispose();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PhidgetControlPanel().setVisible(true);
            }
        });
    }
}

