/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.TextLCDPhidget;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import misc.TextFieldLimiter;

public class LCDAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField dispTxt1;
    private JTextField dispTxt2;
    private JButton clearBtn;
    private JCheckBox backlightChk;
    private JCheckBox cursorChk;
    private JCheckBox blinkChk;
    private JCheckBox customChk;
    private JSlider contrastSlide;

    public LCDAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField dispTxt1, JTextField dispTxt2, JButton clearBtn, JCheckBox backlightChk, JCheckBox cursorChk, JCheckBox blinkChk, JCheckBox customChk, JSlider contrastSlide) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.dispTxt1 = dispTxt1;
        this.dispTxt2 = dispTxt2;
        this.clearBtn = clearBtn;
        this.backlightChk = backlightChk;
        this.cursorChk = cursorChk;
        this.blinkChk = blinkChk;
        this.customChk = customChk;
        this.contrastSlide = contrastSlide;
    }

    public void attached(AttachEvent ae) {
        try {
            if (ae.getSource().getDeviceType().equals("PhidgetTextLCD")) {
                TextLCDPhidget attached = (TextLCDPhidget)ae.getSource();
                this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
                this.nameTxt.setText(attached.getDeviceName());
                this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
                this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
                this.dispTxt1.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                this.dispTxt1.setEnabled(true);
                this.dispTxt2.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                this.dispTxt2.setEnabled(true);
                this.clearBtn.setEnabled(true);
                this.backlightChk.setSelected(attached.getBacklight());
                this.backlightChk.setEnabled(true);
                this.cursorChk.setSelected(attached.getCursor());
                this.cursorChk.setEnabled(true);
                this.blinkChk.setSelected(attached.getCursorBlink());
                this.blinkChk.setEnabled(true);
                this.customChk.setEnabled(true);
                this.contrastSlide.setEnabled(true);
                this.contrastSlide.setMaximum(255);
                this.contrastSlide.setMinimum(0);
                this.contrastSlide.setValue(attached.getContrast());
            } else {
                this.attachedTxt.setText("false");
                this.nameTxt.setText("");
                this.serialTxt.setText("");
                this.versionTxt.setText("");
                this.dispTxt1.setText("");
                this.dispTxt1.setEnabled(false);
                this.dispTxt2.setText("");
                this.dispTxt2.setEnabled(false);
                this.clearBtn.setEnabled(false);
                this.backlightChk.setEnabled(false);
                this.cursorChk.setEnabled(false);
                this.blinkChk.setEnabled(false);
                this.customChk.setEnabled(false);
                this.contrastSlide.setEnabled(false);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

