/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.AccelerometerPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AccelerationChangeEvent;
import com.phidgets.event.AccelerationChangeListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class AccelChangeListener
implements AccelerationChangeListener {
    private JFrame appFrame;
    private JTextField accel1Txt;
    private JTextField accel2Txt;
    private JTextField accel3Txt;

    public AccelChangeListener(JFrame appFrame, JTextField accel1Txt, JTextField accel2Txt, JTextField accel3Txt) {
        this.appFrame = appFrame;
        this.accel1Txt = accel1Txt;
        this.accel2Txt = accel2Txt;
        this.accel3Txt = accel3Txt;
    }

    public void accelerationChanged(AccelerationChangeEvent accelerationChangeEvent) {
        try {
            AccelerometerPhidget sender = (AccelerometerPhidget)accelerationChangeEvent.getSource();
            switch (accelerationChangeEvent.getIndex()) {
                case 0: {
                    this.accel1Txt.setText(Double.toString(sender.getAcceleration(0)));
                    break;
                }
                case 1: {
                    this.accel2Txt.setText(Double.toString(sender.getAcceleration(1)));
                    break;
                }
                case 2: {
                    this.accel3Txt.setText(Double.toString(sender.getAcceleration(2)));
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this.appFrame, "Index " + accelerationChangeEvent.getIndex() + " is not a valid axis!", "Axis Index Error", 0);
                    break;
                }
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

