/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.AccelerometerPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AccelAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numAxesTxt;
    private JTextField accel3Txt;
    private JTextField sensitivity1Txt;
    private JTextField sensitivity2Txt;
    private JTextField sensitivity3Txt;

    public AccelAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numAxesTxt, JTextField accel3Txt, JTextField sensitivity1Txt, JTextField sensitivity2Txt, JTextField sensitivity3Txt) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numAxesTxt = numAxesTxt;
        this.accel3Txt = accel3Txt;
        this.sensitivity1Txt = sensitivity1Txt;
        this.sensitivity2Txt = sensitivity2Txt;
        this.sensitivity3Txt = sensitivity3Txt;
    }

    public void attached(AttachEvent ae) {
        try {
            AccelerometerPhidget attached = (AccelerometerPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numAxesTxt.setText(Integer.toString(attached.getAxisCount()));
            this.sensitivity1Txt.setEnabled(true);
            this.sensitivity2Txt.setEnabled(true);
            if (attached.getAxisCount() > 2) {
                this.sensitivity3Txt.setEnabled(true);
            } else {
                this.sensitivity3Txt.setEnabled(false);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

