/*
 * Decompiled with CFR 0.152.
 */
package Accelerometer;

import com.phidgets.AccelerometerPhidget;
import com.phidgets.PhidgetException;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import listeners.AccelAttachListener;
import listeners.AccelChangeListener;
import listeners.AccelDetachListener;
import listeners.AccelErrorListener;
import org.jdesktop.layout.GroupLayout;

public class Accelerometer
extends JFrame {
    private static String[] runArgs;
    private AccelerometerPhidget accel;
    private AccelAttachListener attach_listener;
    private AccelDetachListener detach_listener;
    private AccelErrorListener error_listener;
    private AccelChangeListener change_listener;
    private JTextField accel1Txt;
    private JTextField accel2Txt;
    private JTextField accel3Txt;
    private JTextField attachedTxt;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JTextField numAxesTxt;
    private JTextField sensitivity1Txt;
    private JTextField sensitivity2Txt;
    private JTextField sensitivity3Txt;
    private JTextField serialTxt;
    private JTextField versionTxt;

    public Accelerometer() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numAxesTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.accel1Txt = new JTextField();
        this.accel2Txt = new JTextField();
        this.accel3Txt = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jPanel3 = new JPanel();
        this.sensitivity1Txt = new JTextField();
        this.sensitivity2Txt = new JTextField();
        this.sensitivity3Txt = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Accelerometer - full");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                Accelerometer.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                Accelerometer.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Accelerometer Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setFont(new Font("Tahoma", 0, 11));
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        this.numAxesTxt.setEditable(false);
        this.jLabel5.setText("Axes:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(35, 35, 35).add(jPanel1Layout.createParallelGroup(2).add(this.jLabel1).add(this.jLabel2).add(this.jLabel3).add(this.jLabel4).add(this.jLabel5)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.numAxesTxt).add(1, this.versionTxt).add(1, this.serialTxt).add(1, this.attachedTxt).add(1, this.jScrollPane1)).addContainerGap(22, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jScrollPane1, -2, -1, -2).add(this.jLabel2)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numAxesTxt, -2, -1, -2).add(this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Acceleration Data"));
        this.accel1Txt.setEditable(false);
        this.accel2Txt.setEditable(false);
        this.accel3Txt.setEditable(false);
        this.jLabel6.setText("Axis 1:");
        this.jLabel7.setText("Axis 2:");
        this.jLabel8.setText("Axis 3:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().addContainerGap(51, Short.MAX_VALUE).add(jPanel2Layout.createParallelGroup(2).add(jPanel2Layout.createSequentialGroup().add(this.jLabel8).addPreferredGap(0).add(this.accel3Txt, -2, 167, -2)).add(jPanel2Layout.createSequentialGroup().add(this.jLabel7).addPreferredGap(0).add(this.accel2Txt, -2, 167, -2)).add(jPanel2Layout.createSequentialGroup().add(this.jLabel6).addPreferredGap(0).add(this.accel1Txt, -2, 167, -2))).add(22, 22, 22)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(3).add(this.accel1Txt, -2, -1, -2).add(this.jLabel6)).add(16, 16, 16).add(jPanel2Layout.createParallelGroup(3).add(this.accel2Txt, -2, -1, -2).add(this.jLabel7)).add(16, 16, 16).add(jPanel2Layout.createParallelGroup(3).add(this.accel3Txt, -2, -1, -2).add(this.jLabel8)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Sensitivity Settings"));
        this.sensitivity1Txt.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                Accelerometer.this.sensitivity1TxtKeyReleased(evt);
            }
        });
        this.sensitivity2Txt.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                Accelerometer.this.sensitivity2TxtKeyReleased(evt);
            }
        });
        this.sensitivity3Txt.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                Accelerometer.this.sensitivity3TxtKeyReleased(evt);
            }
        });
        this.jLabel9.setText("Axis 1:");
        this.jLabel10.setText("Axis 2:");
        this.jLabel11.setText("Axis 3:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(2, jPanel3Layout.createSequentialGroup().addContainerGap(53, Short.MAX_VALUE).add(jPanel3Layout.createParallelGroup(2).add(jPanel3Layout.createSequentialGroup().add(this.jLabel11).addPreferredGap(0).add(this.sensitivity3Txt, -2, 167, -2)).add(jPanel3Layout.createSequentialGroup().add(this.jLabel10).addPreferredGap(0).add(this.sensitivity2Txt, -2, 167, -2)).add(jPanel3Layout.createSequentialGroup().add(this.jLabel9).addPreferredGap(0).add(this.sensitivity1Txt, -2, 167, -2))).add(20, 20, 20)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(3).add(this.sensitivity1Txt, -2, -1, -2).add(this.jLabel9)).add(14, 14, 14).add(jPanel3Layout.createParallelGroup(3).add(this.sensitivity2Txt, -2, -1, -2).add(this.jLabel10)).add(16, 16, 16).add(jPanel3Layout.createParallelGroup(3).add(this.sensitivity3Txt, -2, -1, -2).add(this.jLabel11)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(2, this.jPanel3, -1, -1, Short.MAX_VALUE).add(2, this.jPanel2, -1, -1, Short.MAX_VALUE).add(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addPreferredGap(0).add(this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.sensitivity1Txt.setEnabled(false);
        this.sensitivity2Txt.setEnabled(false);
        this.sensitivity3Txt.setEnabled(false);
        try {
            this.accel = new AccelerometerPhidget();
            this.attach_listener = new AccelAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numAxesTxt, this.accel3Txt, this.sensitivity1Txt, this.sensitivity2Txt, this.sensitivity3Txt);
            this.detach_listener = new AccelDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numAxesTxt, this.accel1Txt, this.accel2Txt, this.accel3Txt, this.sensitivity1Txt, this.sensitivity2Txt, this.sensitivity3Txt);
            this.error_listener = new AccelErrorListener(this);
            this.change_listener = new AccelChangeListener(this, this.accel1Txt, this.accel2Txt, this.accel3Txt);
            this.accel.addAttachListener(this.attach_listener);
            this.accel.addDetachListener(this.detach_listener);
            this.accel.addErrorListener(this.error_listener);
            this.accel.addAccelerationChangeListener(this.change_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.accel.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.accel.open(Integer.parseInt(runArgs[0]));
            } else {
                this.accel.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void sensitivity1TxtKeyReleased(KeyEvent evt) {
        try {
            this.accel.setAccelerationChangeTrigger(0, Double.parseDouble(this.sensitivity1Txt.getText()));
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
        catch (NumberFormatException ex) {
            try {
                this.accel.setAccelerationChangeTrigger(0, 0.0);
            }
            catch (PhidgetException ex2) {
                JOptionPane.showMessageDialog(this, ex2.getDescription(), "Phidget Error" + ex2.getErrorNumber(), 0);
            }
            this.sensitivity1Txt.setText("0");
        }
    }

    private void sensitivity2TxtKeyReleased(KeyEvent evt) {
        try {
            this.accel.setAccelerationChangeTrigger(1, Double.parseDouble(this.sensitivity2Txt.getText()));
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
        catch (NumberFormatException ex) {
            try {
                this.accel.setAccelerationChangeTrigger(1, 0.0);
            }
            catch (PhidgetException ex2) {
                JOptionPane.showMessageDialog(this, ex2.getDescription(), "Phidget Error" + ex2.getErrorNumber(), 0);
            }
            this.sensitivity2Txt.setText("0");
        }
    }

    private void sensitivity3TxtKeyReleased(KeyEvent evt) {
        try {
            this.accel.setAccelerationChangeTrigger(2, Double.parseDouble(this.sensitivity3Txt.getText()));
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
        catch (NumberFormatException ex) {
            try {
                this.accel.setAccelerationChangeTrigger(2, 0.0);
            }
            catch (PhidgetException ex2) {
                JOptionPane.showMessageDialog(this, ex2.getDescription(), "Phidget Error" + ex2.getErrorNumber(), 0);
            }
            this.sensitivity3Txt.setText("0");
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.accel.removeAccelerationChangeListener(this.change_listener);
            this.accel.removeErrorListener(this.error_listener);
            this.accel.removeDetachListener(this.detach_listener);
            this.accel.removeAttachListener(this.attach_listener);
            this.accel.close();
            this.accel = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Accelerometer().setVisible(true);
            }
        });
    }
}

