/*
 * Decompiled with CFR 0.152.
 */
package Servo;

import com.phidgets.PhidgetException;
import com.phidgets.ServoPhidget;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.ServoAttachListener;
import listeners.ServoDetachListener;
import listeners.ServoErrorListener;
import listeners.ServoPositionListener;
import org.jdesktop.layout.GroupLayout;

public class Servo
extends JFrame {
    private static String[] runArgs;
    private ServoPhidget servo;
    private ServoAttachListener attach_listener;
    private ServoDetachListener detach_listener;
    private ServoErrorListener error_listener;
    private ServoPositionListener change_listener;
    private JTextField attachedTxt;
    private JCheckBox engagedChk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JTextField numServoTxt;
    private JSlider positionScrl;
    private JTextField positionTxt;
    private JTextField serialTxt;
    private JComboBox servoCmb;
    private JTextField versionTxt;

    public Servo() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numServoTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.servoCmb = new JComboBox();
        this.jLabel6 = new JLabel();
        this.positionTxt = new JTextField();
        this.jLabel7 = new JLabel();
        this.positionScrl = new JSlider();
        this.engagedChk = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("Servo - full");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                Servo.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                Servo.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Servo Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        this.numServoTxt.setEditable(false);
        this.jLabel5.setText("Servos:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(35, 35, 35).add(jPanel1Layout.createParallelGroup(2).add(this.jLabel1).add(this.jLabel2).add(this.jLabel3).add(this.jLabel4).add(this.jLabel5)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.numServoTxt).add(1, this.versionTxt).add(1, this.serialTxt).add(1, this.attachedTxt).add(1, this.jScrollPane1)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jScrollPane1, -2, -1, -2).add(this.jLabel2)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numServoTxt, -2, -1, -2).add(this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Servo Position"));
        this.servoCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Servo.this.servoCmbActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Servo No.:");
        this.positionTxt.setEditable(false);
        this.jLabel7.setText("Position:");
        this.positionScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Servo.this.positionScrlStateChanged(evt);
            }
        });
        this.engagedChk.setText("Engaged");
        this.engagedChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Servo.this.engagedChkActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(35, 35, 35).add(jPanel2Layout.createParallelGroup(2).add(this.jLabel6).add(this.jLabel7)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.engagedChk).addContainerGap()).add(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().add(this.positionScrl, -1, 164, Short.MAX_VALUE).addContainerGap()).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(2).add(1, this.positionTxt, -1, 166, Short.MAX_VALUE).add(1, this.servoCmb, 0, 166, Short.MAX_VALUE)).add(8, 8, 8))))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(3).add(this.servoCmb, -2, -1, -2).add(this.jLabel6)).add(17, 17, 17).add(jPanel2Layout.createParallelGroup(3).add(this.positionTxt, -2, -1, -2).add(this.jLabel7)).add(18, 18, 18).add(this.positionScrl, -2, -1, -2).addPreferredGap(0, 16, Short.MAX_VALUE).add(this.engagedChk).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel2, 0, -1, Short.MAX_VALUE).add(this.jPanel1, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.servoCmb.setEnabled(false);
        this.positionScrl.setEnabled(false);
        this.engagedChk.setEnabled(false);
        try {
            this.servo = new ServoPhidget();
            this.attach_listener = new ServoAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numServoTxt, this.servoCmb, this.positionTxt, this.positionScrl, this.engagedChk);
            this.detach_listener = new ServoDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numServoTxt, this.servoCmb, this.positionTxt, this.positionScrl, this.engagedChk);
            this.error_listener = new ServoErrorListener(this);
            this.change_listener = new ServoPositionListener(this.positionTxt);
            this.servo.addAttachListener(this.attach_listener);
            this.servo.addDetachListener(this.detach_listener);
            this.servo.addErrorListener(this.error_listener);
            this.servo.addServoPositionChangeListener(this.change_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.servo.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.servo.open(Integer.parseInt(runArgs[0]));
            } else {
                this.servo.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void servoCmbActionPerformed(ActionEvent evt) {
        if (this.servoCmb.isEnabled()) {
            try {
                this.positionTxt.setText(Double.toString(this.servo.getPosition((Integer)this.servoCmb.getSelectedItem())));
                this.positionScrl.setValue((int)this.servo.getPosition((Integer)this.servoCmb.getSelectedItem()));
                this.engagedChk.setSelected(this.servo.getMotorOn((Integer)this.servoCmb.getSelectedItem()));
            }
            catch (PhidgetException ex) {
                this.positionTxt.setText("Unknown");
                this.positionScrl.setValue(0);
                this.engagedChk.setSelected(false);
            }
        }
    }

    private void positionScrlStateChanged(ChangeEvent evt) {
        if (this.positionScrl.isEnabled()) {
            try {
                this.servo.setPosition((Integer)this.servoCmb.getSelectedItem(), this.positionScrl.getValue());
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.servo.removeServoPositionChangeListener(this.change_listener);
            this.servo.removeErrorListener(this.error_listener);
            this.servo.removeDetachListener(this.detach_listener);
            this.servo.removeAttachListener(this.attach_listener);
            this.servo.close();
            this.servo = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void engagedChkActionPerformed(ActionEvent evt) {
        try {
            this.servo.setMotorOn((Integer)this.servoCmb.getSelectedItem(), this.engagedChk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Servo().setVisible(true);
            }
        });
    }
}

