/*
 * Decompiled with CFR 0.152.
 */
package TextLCD;

import com.phidgets.PhidgetException;
import com.phidgets.TextLCDPhidget;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.LCDAttachListener;
import listeners.LCDDetachListener;
import listeners.LCDErrorListener;
import org.jdesktop.layout.GroupLayout;

public class TextLCD
extends JFrame {
    private static String[] runArgs;
    private TextLCDPhidget lcd;
    private LCDAttachListener attach_listener;
    private LCDDetachListener detach_listener;
    private LCDErrorListener error_listener;
    private JTextField attachedTxt;
    private JCheckBox backlightChk;
    private JCheckBox blinkChk;
    private JButton clearBtn;
    private JSlider contrastSlide;
    private JCheckBox cursorChk;
    private JCheckBox customChk;
    private JTextField dispTxt1;
    private JTextField dispTxt2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;

    public TextLCD() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.attachedTxt = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.serialTxt = new JTextField();
        this.versionTxt = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.dispTxt1 = new JTextField();
        this.dispTxt2 = new JTextField();
        this.clearBtn = new JButton();
        this.backlightChk = new JCheckBox();
        this.cursorChk = new JCheckBox();
        this.blinkChk = new JCheckBox();
        this.customChk = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.contrastSlide = new JSlider();
        this.setDefaultCloseOperation(3);
        this.setTitle("TextLCD - full");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                TextLCD.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                TextLCD.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Device Info"));
        this.jLabel1.setText("Attached:");
        this.jLabel2.setText("Name:");
        this.jLabel3.setText("Serial No.:");
        this.jLabel4.setText("Version:");
        this.attachedTxt.setEditable(false);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextArea.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setFont(new Font("Tahoma", 0, 11));
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(2);
        this.nameTxt.setTabSize(2);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.serialTxt.setEditable(false);
        this.versionTxt.setEditable(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(this.jLabel1).add(this.jLabel3).add(this.jLabel2).add(this.jLabel4)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1, false).add(this.attachedTxt, -1, 172, Short.MAX_VALUE).add(this.jScrollPane1).add(this.serialTxt).add(this.versionTxt, -1, 137, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.attachedTxt, -2, -1, -2)).add(8, 8, 8).add(jPanel1Layout.createParallelGroup(1).add(this.jLabel2).add(this.jScrollPane1, -2, 63, -2)).add(11, 11, 11).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel3).add(this.serialTxt, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel4).add(this.versionTxt, -2, -1, -2)).addContainerGap(93, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("LCD Control"));
        this.jLabel5.setText("Display Text:");
        this.dispTxt1.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                TextLCD.this.dispTxt1KeyReleased(evt);
            }
        });
        this.dispTxt2.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                TextLCD.this.dispTxt2KeyReleased(evt);
            }
        });
        this.clearBtn.setText("Clear");
        this.clearBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.clearBtnActionPerformed(evt);
            }
        });
        this.backlightChk.setText("Backlight");
        this.backlightChk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.backlightChk.setMargin(new Insets(0, 0, 0, 0));
        this.backlightChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.backlightChkActionPerformed(evt);
            }
        });
        this.cursorChk.setText("Cursor");
        this.cursorChk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cursorChk.setMargin(new Insets(0, 0, 0, 0));
        this.cursorChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.cursorChkActionPerformed(evt);
            }
        });
        this.blinkChk.setText("Cursor Blink");
        this.blinkChk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.blinkChk.setMargin(new Insets(0, 0, 0, 0));
        this.blinkChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.blinkChkActionPerformed(evt);
            }
        });
        this.customChk.setText("Custom Characters");
        this.customChk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.customChk.setMargin(new Insets(0, 0, 0, 0));
        this.customChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLCD.this.customChkActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Contrast:");
        this.contrastSlide.setPaintTicks(true);
        this.contrastSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TextLCD.this.contrastSlideStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(this.jLabel6).add(jPanel2Layout.createParallelGroup(2, false).add(1, this.contrastSlide, 0, 0, Short.MAX_VALUE).add(1, jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(this.backlightChk).add(this.cursorChk)).add(17, 17, 17).add(jPanel2Layout.createParallelGroup(1).add(this.customChk).add(this.blinkChk)))).add(this.jLabel5).add(this.clearBtn).add(2, this.dispTxt2, -1, 185, Short.MAX_VALUE).add(this.dispTxt1, -1, 185, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.jLabel5).addPreferredGap(0).add(this.dispTxt1, -2, -1, -2).addPreferredGap(0).add(this.dispTxt2, -2, -1, -2).addPreferredGap(0).add(this.clearBtn).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.backlightChk).add(this.blinkChk)).add(21, 21, 21).add(jPanel2Layout.createParallelGroup(3).add(this.cursorChk).add(this.customChk)).add(16, 16, 16).add(this.jLabel6).addPreferredGap(0).add(this.contrastSlide, -2, -1, -2).addContainerGap(32, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(layout.createParallelGroup(1).add(this.jPanel2, -2, -1, -2).add(this.jPanel1, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        try {
            this.lcd = new TextLCDPhidget();
            this.attach_listener = new LCDAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.dispTxt1, this.dispTxt2, this.clearBtn, this.backlightChk, this.cursorChk, this.blinkChk, this.customChk, this.contrastSlide);
            this.lcd.addAttachListener(this.attach_listener);
            this.detach_listener = new LCDDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.dispTxt1, this.dispTxt2, this.clearBtn, this.backlightChk, this.cursorChk, this.blinkChk, this.customChk, this.contrastSlide);
            this.lcd.addDetachListener(this.detach_listener);
            this.error_listener = new LCDErrorListener(this);
            this.lcd.addErrorListener(this.error_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.lcd.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.lcd.open(Integer.parseInt(runArgs[0]));
            } else {
                this.lcd.openAny();
            }
            this.dispTxt1.setEnabled(false);
            this.dispTxt2.setEnabled(false);
            this.clearBtn.setEnabled(false);
            this.backlightChk.setEnabled(false);
            this.cursorChk.setEnabled(false);
            this.blinkChk.setEnabled(false);
            this.customChk.setEnabled(false);
            this.contrastSlide.setEnabled(false);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.lcd.removeAttachListener(this.attach_listener);
            this.lcd.removeDetachListener(this.detach_listener);
            this.lcd.removeErrorListener(this.error_listener);
            this.lcd.close();
            this.lcd = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void contrastSlideStateChanged(ChangeEvent evt) {
        try {
            this.lcd.setContrast(this.contrastSlide.getValue());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void customChkActionPerformed(ActionEvent evt) {
        if (this.customChk.isEnabled()) {
            try {
                this.lcd.setDisplayString(0, "Testing Custom Chars");
                this.lcd.setCustomCharacter(8, 949247, 536);
                this.lcd.setCustomCharacter(9, 1015791, 17180);
                this.lcd.setCustomCharacter(10, 1048039, 549790);
                this.lcd.setCustomCharacter(11, 1031395, 816095);
                this.lcd.setCustomCharacter(12, 498785, 949247);
                this.lcd.setCustomCharacter(13, 232480, 1015791);
                this.lcd.setCustomCharacter(14, 99328, 1048039);
                this.lcd.setDisplayString(1, "\b\t\n\u000b\f\r\u000e");
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
            }
        } else {
            try {
                this.lcd.setDisplayString(0, "");
                this.lcd.setDisplayString(1, "");
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
            }
        }
    }

    private void blinkChkActionPerformed(ActionEvent evt) {
        try {
            this.lcd.setCursorBlink(this.blinkChk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void cursorChkActionPerformed(ActionEvent evt) {
        try {
            this.lcd.setCursor(this.cursorChk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void backlightChkActionPerformed(ActionEvent evt) {
        try {
            this.lcd.setBacklight(this.backlightChk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void clearBtnActionPerformed(ActionEvent evt) {
        this.dispTxt1.setText("");
        this.dispTxt2.setText("");
        try {
            this.lcd.setDisplayString(0, "");
            this.lcd.setDisplayString(1, "");
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void dispTxt2KeyReleased(KeyEvent evt) {
        try {
            this.lcd.setDisplayString(1, this.dispTxt2.getText());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    private void dispTxt1KeyReleased(KeyEvent evt) {
        try {
            this.lcd.setDisplayString(0, this.dispTxt1.getText());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TextLCD().setVisible(true);
            }
        });
    }
}

