/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.StepperPhidget;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class StepperAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numMotorsTxt;
    private JTextField numInTxt;
    private JComboBox motorCmb;
    private JTextField velTxt;
    private JTextField accelTxt;
    private JTextField posTxt;
    private JTextField targetPosTxt;
    private JTextField torqueTxt;
    private JTextField currentTxt;
    private JSlider velScrl;
    private JSlider accelScrl;
    private JSlider targetPosScrl;
    private JSlider torqueScrl;
    private JCheckBox[] inputArray;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel16;
    private int[] targetPosArray;

    public StepperAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numMotorsTxt, JTextField numInTxt, JComboBox motorCmb, JTextField velTxt, JTextField accelTxt, JTextField posTxt, JTextField targetPosTxt, JTextField torqueTxt, JTextField currentTxt, JSlider velScrl, JSlider accelScrl, JSlider targetPosScrl, JSlider torqueScrl, JCheckBox[] inputArray, JLabel jLabel11, JLabel jLabel12, JLabel jLabel16, int[] targetPosArray) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numMotorsTxt = numMotorsTxt;
        this.numInTxt = numInTxt;
        this.motorCmb = motorCmb;
        this.velTxt = velTxt;
        this.accelTxt = accelTxt;
        this.posTxt = posTxt;
        this.targetPosTxt = targetPosTxt;
        this.torqueTxt = torqueTxt;
        this.currentTxt = currentTxt;
        this.velScrl = velScrl;
        this.accelScrl = accelScrl;
        this.targetPosScrl = targetPosScrl;
        this.torqueScrl = torqueScrl;
        this.inputArray = inputArray;
        this.jLabel11 = jLabel11;
        this.jLabel12 = jLabel12;
        this.jLabel16 = jLabel16;
        this.targetPosArray = targetPosArray;
    }

    public void attached(AttachEvent ae) {
        try {
            int i;
            StepperPhidget attached = (StepperPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numMotorsTxt.setText(Integer.toString(attached.getMotorCount()));
            this.targetPosArray = new int[attached.getMotorCount()];
            for (i = 0; i < attached.getMotorCount(); ++i) {
                this.motorCmb.addItem(new Integer(i));
                this.targetPosArray[i] = 0;
                attached.setMaxVelocity(i, 0.0);
                attached.setAcceleration(i, 0.0);
                attached.setPosition(i, 0L);
            }
            this.motorCmb.setSelectedIndex(0);
            this.velScrl.setValue(0);
            this.accelScrl.setValue(0);
            this.targetPosScrl.setValue(0);
            this.targetPosTxt.setText(Integer.toString(this.targetPosScrl.getValue()));
            if (attached.getDeviceName().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0) {
                this.numInTxt.setText(Integer.toString(attached.getInputCount()));
                for (i = 0; i < attached.getMotorCount(); ++i) {
                    attached.setTorque(i, 0.0);
                }
                this.torqueScrl.setValue(0);
                this.jLabel16.setVisible(true);
                this.torqueScrl.setVisible(true);
                this.torqueTxt.setText(Integer.toString(this.torqueScrl.getValue()));
                this.jLabel11.setVisible(true);
                this.torqueTxt.setVisible(true);
                this.jLabel12.setVisible(true);
                this.currentTxt.setVisible(true);
                this.motorCmb.setEnabled(true);
                for (i = 0; i < attached.getInputCount(); ++i) {
                    this.inputArray[i].setVisible(true);
                }
                this.velScrl.setMaximum((int)attached.getVelocityMax(0));
                this.velScrl.setMinimum((int)attached.getVelocityMin(0));
                this.accelScrl.setMaximum((int)attached.getAccelerationMax(0));
                this.accelScrl.setMinimum((int)attached.getAccelerationMin(0));
                this.targetPosScrl.setMaximum((int)attached.getPositionMax(0));
                this.targetPosScrl.setMinimum((int)attached.getPositionMin(0));
                this.torqueScrl.setMaximum(100);
                this.torqueScrl.setMinimum(0);
                this.velScrl.setEnabled(true);
                this.accelScrl.setEnabled(true);
                this.targetPosScrl.setEnabled(true);
                this.torqueScrl.setEnabled(true);
            } else {
                this.numInTxt.setText("0");
                this.torqueScrl.setValue(0);
                this.jLabel16.setVisible(false);
                this.torqueScrl.setVisible(false);
                this.torqueTxt.setText("");
                this.jLabel11.setVisible(false);
                this.torqueTxt.setVisible(false);
                this.jLabel12.setVisible(false);
                this.currentTxt.setVisible(false);
                this.motorCmb.setEnabled(true);
                for (i = 0; i < 4; ++i) {
                    this.inputArray[i].setVisible(false);
                }
                this.velScrl.setMaximum((int)attached.getVelocityMax(0));
                this.velScrl.setMinimum((int)attached.getVelocityMin(0));
                this.accelScrl.setMaximum((int)attached.getAccelerationMax(0));
                this.accelScrl.setMinimum((int)attached.getAccelerationMin(0));
                this.targetPosScrl.setMaximum((int)attached.getPositionMax(0));
                this.targetPosScrl.setMinimum((int)attached.getPositionMin(0));
                this.velScrl.setEnabled(true);
                this.accelScrl.setEnabled(true);
                this.targetPosScrl.setEnabled(true);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

