/*
 * Decompiled with CFR 0.152.
 */
package Stepper;

import com.phidgets.PhidgetException;
import com.phidgets.StepperPhidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.StepperAttachListener;
import listeners.StepperCurrentChangeListener;
import listeners.StepperDetachListener;
import listeners.StepperErrorListener;
import listeners.StepperInputChangeListener;
import listeners.StepperPositionListener;
import listeners.StepperVelocityListener;
import org.jdesktop.layout.GroupLayout;

public class Stepper
extends JFrame {
    private static String[] runArgs;
    private StepperPhidget stepper;
    private StepperAttachListener attach_listener;
    private StepperDetachListener detach_listener;
    private StepperErrorListener error_listener;
    private StepperCurrentChangeListener current_listener;
    private StepperInputChangeListener input_listener;
    private StepperPositionListener position_listener;
    private StepperVelocityListener velocity_listener;
    private JCheckBox[] inputArray;
    private int[] targetPosArray;
    private JSlider accelScrl;
    private JTextField accelTxt;
    private JTextField attachedTxt;
    private JTextField currentTxt;
    private JCheckBox in0Chk;
    private JCheckBox in1Chk;
    private JCheckBox in2Chk;
    private JCheckBox in3Chk;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JComboBox motorCmb;
    private JTextArea nameTxt;
    private JTextField numInTxt;
    private JTextField numMotorsTxt;
    private JTextField posTxt;
    private JTextField serialTxt;
    private JSlider targetPosScrl;
    private JTextField targetPosTxt;
    private JSlider torqueScrl;
    private JTextField torqueTxt;
    private JSlider velScrl;
    private JTextField velTxt;
    private JTextField versionTxt;

    public Stepper() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.motorCmb = new JComboBox();
        this.velTxt = new JTextField();
        this.jLabel7 = new JLabel();
        this.accelTxt = new JTextField();
        this.jLabel8 = new JLabel();
        this.posTxt = new JTextField();
        this.jLabel9 = new JLabel();
        this.targetPosTxt = new JTextField();
        this.jLabel10 = new JLabel();
        this.torqueTxt = new JTextField();
        this.jLabel11 = new JLabel();
        this.currentTxt = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.velScrl = new JSlider();
        this.accelScrl = new JSlider();
        this.jLabel15 = new JLabel();
        this.targetPosScrl = new JSlider();
        this.jLabel16 = new JLabel();
        this.torqueScrl = new JSlider();
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numMotorsTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.numInTxt = new JTextField();
        this.jLabel17 = new JLabel();
        this.jPanel3 = new JPanel();
        this.in0Chk = new JCheckBox();
        this.in1Chk = new JCheckBox();
        this.in2Chk = new JCheckBox();
        this.in3Chk = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("Stepper - full");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                Stepper.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                Stepper.this.formWindowOpened(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Motor Data"));
        this.jLabel6.setText("Choose Stepper Motor:");
        this.motorCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Stepper.this.motorCmbActionPerformed(evt);
            }
        });
        this.velTxt.setEditable(false);
        this.jLabel7.setText("Velocity:");
        this.accelTxt.setEditable(false);
        this.jLabel8.setText("Acceleration:");
        this.posTxt.setEditable(false);
        this.jLabel9.setText("Position:");
        this.targetPosTxt.setEditable(false);
        this.jLabel10.setText("Target Position:");
        this.torqueTxt.setEditable(false);
        this.jLabel11.setText("Torque:");
        this.currentTxt.setEditable(false);
        this.jLabel12.setText("Current:");
        this.jLabel13.setText("Set Maximum Velocity:");
        this.jLabel14.setText("Set Acceleration:");
        this.velScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Stepper.this.velScrlStateChanged(evt);
            }
        });
        this.accelScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Stepper.this.accelScrlStateChanged(evt);
            }
        });
        this.jLabel15.setText("Set Target Position:");
        this.targetPosScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Stepper.this.targetPosScrlStateChanged(evt);
            }
        });
        this.jLabel16.setText("Set Torque:");
        this.torqueScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Stepper.this.torqueScrlStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(this.targetPosScrl, -1, 294, Short.MAX_VALUE).add(2, jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(2).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(this.velScrl, -2, 132, -2).add(this.jLabel13)).add(26, 26, 26)).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(2).add(this.jLabel7).add(this.jLabel6).add(this.jLabel8).add(this.jLabel9)).addPreferredGap(0)).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(2).add(this.jLabel11).add(this.jLabel10).add(this.jLabel12)).addPreferredGap(0))).add(jPanel2Layout.createParallelGroup(2).add(1, this.velTxt, -1, 136, Short.MAX_VALUE).add(1, this.posTxt, -1, 136, Short.MAX_VALUE).add(1, this.targetPosTxt, -1, 136, Short.MAX_VALUE).add(1, this.torqueTxt, -1, 136, Short.MAX_VALUE).add(1, this.currentTxt, -1, 136, Short.MAX_VALUE).add(1, this.accelScrl, -1, 136, Short.MAX_VALUE).add(1, this.accelTxt, -1, 136, Short.MAX_VALUE).add(1, this.jLabel14).add(1, this.motorCmb, 0, 136, Short.MAX_VALUE))).add(this.jLabel15).add(this.jLabel16).add(this.torqueScrl, -1, 294, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(2).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(3).add(this.motorCmb, -2, -1, -2).add(this.jLabel6)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.velTxt, -2, -1, -2).add(this.jLabel7)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel8).add(this.accelTxt, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.posTxt, -2, -1, -2).add(this.jLabel9)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.targetPosTxt, -2, -1, -2).add(this.jLabel10)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.torqueTxt, -2, -1, -2).add(this.jLabel11)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.currentTxt, -2, -1, -2).add(this.jLabel12)).addPreferredGap(0).add(this.jLabel14).addPreferredGap(0).add(this.accelScrl, -2, -1, -2)).add(jPanel2Layout.createSequentialGroup().add(this.jLabel13).addPreferredGap(0).add(this.velScrl, -2, -1, -2))).addPreferredGap(0).add(this.jLabel15).addPreferredGap(0).add(this.targetPosScrl, -2, -1, -2).addPreferredGap(0).add(this.jLabel16).addPreferredGap(0).add(this.torqueScrl, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Stepper Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setFont(new Font("Tahoma", 0, 11));
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        this.numMotorsTxt.setEditable(false);
        this.jLabel5.setText("Motors:");
        this.numInTxt.setEditable(false);
        this.jLabel17.setText("Inputs:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(35, 35, 35).add(jPanel1Layout.createParallelGroup(2).add(this.jLabel1).add(this.jLabel2).add(this.jLabel4).add(this.jLabel3).add(this.jLabel5).add(this.jLabel17)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.numInTxt).add(1, this.numMotorsTxt).add(1, this.versionTxt).add(1, this.serialTxt).add(1, this.attachedTxt).add(1, this.jScrollPane1)).addContainerGap(59, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jScrollPane1, -2, -1, -2).add(this.jLabel2)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numMotorsTxt, -2, -1, -2).add(this.jLabel5)).add(19, 19, 19).add(jPanel1Layout.createParallelGroup(3).add(this.numInTxt, -2, -1, -2).add(this.jLabel17)).addContainerGap(24, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Input Data"));
        this.jPanel3.setMaximumSize(new Dimension(249, 51));
        this.in0Chk.setText("Input 0");
        this.in0Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in0Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in1Chk.setText("Input 1");
        this.in1Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in1Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in2Chk.setText("Input 2");
        this.in2Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in2Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in3Chk.setText("Input 3");
        this.in3Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in3Chk.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(40, 40, 40).add(this.in0Chk).addPreferredGap(0).add(this.in1Chk).addPreferredGap(0).add(this.in2Chk).addPreferredGap(0).add(this.in3Chk).addContainerGap(44, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(3).add(this.in0Chk).add(this.in1Chk).add(this.in2Chk).add(this.in3Chk)).addContainerGap(23, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel1, -2, -1, -2).add(2, this.jPanel2, -2, -1, -2).add(this.jPanel3, -2, -1, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.jPanel1, this.jPanel2, this.jPanel3}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addPreferredGap(0).add(this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.inputArray = new JCheckBox[4];
        this.inputArray[0] = this.in0Chk;
        this.inputArray[1] = this.in1Chk;
        this.inputArray[2] = this.in2Chk;
        this.inputArray[3] = this.in3Chk;
        for (int i = 0; i < 4; ++i) {
            this.inputArray[i].setVisible(false);
            this.inputArray[i].setEnabled(false);
        }
        this.motorCmb.setEnabled(false);
        this.velScrl.setEnabled(false);
        this.accelScrl.setEnabled(false);
        this.targetPosScrl.setEnabled(false);
        this.jLabel11.setVisible(false);
        this.torqueTxt.setVisible(false);
        this.jLabel16.setVisible(false);
        this.torqueScrl.setEnabled(false);
        this.torqueScrl.setVisible(false);
        this.jLabel12.setVisible(false);
        this.currentTxt.setVisible(false);
        try {
            this.stepper = new StepperPhidget();
            this.attach_listener = new StepperAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numMotorsTxt, this.numInTxt, this.motorCmb, this.velTxt, this.accelTxt, this.posTxt, this.targetPosTxt, this.torqueTxt, this.currentTxt, this.velScrl, this.accelScrl, this.targetPosScrl, this.torqueScrl, this.inputArray, this.jLabel11, this.jLabel12, this.jLabel16, this.targetPosArray);
            this.detach_listener = new StepperDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numMotorsTxt, this.numInTxt, this.motorCmb, this.velTxt, this.accelTxt, this.posTxt, this.targetPosTxt, this.torqueTxt, this.currentTxt, this.velScrl, this.accelScrl, this.targetPosScrl, this.torqueScrl, this.inputArray, this.jLabel11, this.jLabel12, this.jLabel16, this.targetPosArray);
            this.error_listener = new StepperErrorListener(this);
            this.current_listener = new StepperCurrentChangeListener(this.motorCmb, this.currentTxt);
            this.input_listener = new StepperInputChangeListener(this.inputArray);
            this.position_listener = new StepperPositionListener(this.motorCmb, this.posTxt);
            this.velocity_listener = new StepperVelocityListener(this.motorCmb, this.velTxt);
            this.stepper.addAttachListener(this.attach_listener);
            this.stepper.addDetachListener(this.detach_listener);
            this.stepper.addErrorListener(this.error_listener);
            this.stepper.addCurrentChangeListener(this.current_listener);
            this.stepper.addInputChangeListener(this.input_listener);
            this.stepper.addStepperPositionChangeListener(this.position_listener);
            this.stepper.addStepperVelocityChangeListener(this.velocity_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.stepper.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.stepper.open(Integer.parseInt(runArgs[0]));
            } else {
                this.stepper.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void motorCmbActionPerformed(ActionEvent evt) {
        if (this.motorCmb.isEnabled()) {
            try {
                this.velTxt.setText("0");
                this.velScrl.setValueIsAdjusting(true);
                this.velScrl.setValue(0);
                this.velScrl.setValueIsAdjusting(false);
                this.accelTxt.setText(Double.toString(this.stepper.getAcceleration((Integer)this.motorCmb.getSelectedItem())));
                this.accelScrl.setValueIsAdjusting(true);
                this.accelScrl.setValue((int)this.stepper.getAcceleration((Integer)this.motorCmb.getSelectedItem()));
                this.accelScrl.setValueIsAdjusting(false);
                this.posTxt.setText(Long.toString(this.stepper.getPosition((Integer)this.motorCmb.getSelectedItem())));
                this.targetPosTxt.setText(Integer.toString(this.targetPosArray[(Integer)this.motorCmb.getSelectedItem()]));
                this.targetPosScrl.setValueIsAdjusting(true);
                this.targetPosScrl.setValue(this.targetPosArray[(Integer)this.motorCmb.getSelectedItem()]);
                this.targetPosScrl.setValueIsAdjusting(false);
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void velScrlStateChanged(ChangeEvent evt) {
        if (this.velScrl.isEnabled()) {
            try {
                this.stepper.setMaxVelocity((Integer)this.motorCmb.getSelectedItem(), this.velScrl.getValue());
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
                this.attachedTxt.setText("false");
                this.nameTxt.setText("");
                this.serialTxt.setText("");
                this.versionTxt.setText("");
                this.numMotorsTxt.setText("");
                this.numInTxt.setText("");
                this.motorCmb.removeAllItems();
                this.motorCmb.setSelectedIndex(0);
                this.motorCmb.setEnabled(false);
                if (this.nameTxt.getText().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0) {
                    this.jLabel16.setVisible(false);
                    this.torqueScrl.setEnabled(false);
                    this.torqueScrl.setValue(0);
                    this.torqueScrl.setVisible(false);
                    this.jLabel11.setVisible(false);
                    this.torqueTxt.setText("");
                    this.torqueTxt.setVisible(false);
                    this.jLabel12.setVisible(false);
                    this.currentTxt.setText("");
                    this.currentTxt.setVisible(false);
                }
                this.velTxt.setText("");
                this.accelTxt.setText("");
                this.posTxt.setText("");
                this.targetPosTxt.setText("");
                this.velScrl.setEnabled(false);
                this.velScrl.setValue(0);
                this.accelScrl.setEnabled(false);
                this.accelScrl.setValue(0);
                this.targetPosScrl.setEnabled(false);
                this.targetPosScrl.setValue(0);
                for (int i = 0; i < 4; ++i) {
                    this.inputArray[i].setVisible(false);
                }
            }
        }
    }

    private void accelScrlStateChanged(ChangeEvent evt) {
        if (this.accelScrl.isEnabled()) {
            try {
                this.stepper.setAcceleration((Integer)this.motorCmb.getSelectedItem(), this.accelScrl.getValue());
                this.accelTxt.setText(Double.toString(this.stepper.getAcceleration((Integer)this.motorCmb.getSelectedItem())));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
                this.attachedTxt.setText("false");
                this.nameTxt.setText("");
                this.serialTxt.setText("");
                this.versionTxt.setText("");
                this.numMotorsTxt.setText("");
                this.numInTxt.setText("");
                this.motorCmb.removeAllItems();
                this.motorCmb.setSelectedIndex(0);
                this.motorCmb.setEnabled(false);
                if (this.nameTxt.getText().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0) {
                    this.jLabel16.setVisible(false);
                    this.torqueScrl.setEnabled(false);
                    this.torqueScrl.setValue(0);
                    this.torqueScrl.setVisible(false);
                    this.jLabel11.setVisible(false);
                    this.torqueTxt.setText("");
                    this.torqueTxt.setVisible(false);
                    this.jLabel12.setVisible(false);
                    this.currentTxt.setText("");
                    this.currentTxt.setVisible(false);
                }
                this.velTxt.setText("");
                this.accelTxt.setText("");
                this.posTxt.setText("");
                this.targetPosTxt.setText("");
                this.velScrl.setEnabled(false);
                this.velScrl.setValue(0);
                this.accelScrl.setEnabled(false);
                this.accelScrl.setValue(0);
                this.targetPosScrl.setEnabled(false);
                this.targetPosScrl.setValue(0);
                for (int i = 0; i < 4; ++i) {
                    this.inputArray[i].setVisible(false);
                }
            }
        }
    }

    private void targetPosScrlStateChanged(ChangeEvent evt) {
        if (this.targetPosScrl.isEnabled()) {
            try {
                this.stepper.setPosition((Integer)this.motorCmb.getSelectedItem(), this.targetPosScrl.getValue());
                this.targetPosArray[((Integer)this.motorCmb.getSelectedItem()).intValue()] = this.targetPosScrl.getValue();
                this.targetPosTxt.setText(Integer.toString(this.targetPosArray[(Integer)this.motorCmb.getSelectedItem()]));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
                this.attachedTxt.setText("false");
                this.nameTxt.setText("");
                this.serialTxt.setText("");
                this.versionTxt.setText("");
                this.numMotorsTxt.setText("");
                this.numInTxt.setText("");
                this.motorCmb.removeAllItems();
                this.motorCmb.setSelectedIndex(0);
                this.motorCmb.setEnabled(false);
                if (this.nameTxt.getText().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0) {
                    this.jLabel16.setVisible(false);
                    this.torqueScrl.setEnabled(false);
                    this.torqueScrl.setValue(0);
                    this.torqueScrl.setVisible(false);
                    this.jLabel11.setVisible(false);
                    this.torqueTxt.setText("");
                    this.torqueTxt.setVisible(false);
                    this.jLabel12.setVisible(false);
                    this.currentTxt.setText("");
                    this.currentTxt.setVisible(false);
                }
                this.velTxt.setText("");
                this.accelTxt.setText("");
                this.posTxt.setText("");
                this.targetPosTxt.setText("");
                this.velScrl.setEnabled(false);
                this.velScrl.setValue(0);
                this.accelScrl.setEnabled(false);
                this.accelScrl.setValue(0);
                this.targetPosScrl.setEnabled(false);
                this.targetPosScrl.setValue(0);
                for (int i = 0; i < 4; ++i) {
                    this.inputArray[i].setVisible(false);
                }
            }
        }
    }

    private void torqueScrlStateChanged(ChangeEvent evt) {
        if (this.torqueScrl.isEnabled()) {
            try {
                this.stepper.setTorque((Integer)this.motorCmb.getSelectedItem(), this.torqueScrl.getValue());
                this.torqueTxt.setText(Integer.toString(this.torqueScrl.getValue()));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
                this.attachedTxt.setText("false");
                this.nameTxt.setText("");
                this.serialTxt.setText("");
                this.versionTxt.setText("");
                this.numMotorsTxt.setText("");
                this.numInTxt.setText("");
                this.motorCmb.removeAllItems();
                this.motorCmb.setSelectedIndex(0);
                this.motorCmb.setEnabled(false);
                if (this.nameTxt.getText().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0) {
                    this.jLabel16.setVisible(false);
                    this.torqueScrl.setEnabled(false);
                    this.torqueScrl.setValue(0);
                    this.torqueScrl.setVisible(false);
                    this.jLabel11.setVisible(false);
                    this.torqueTxt.setText("");
                    this.torqueTxt.setVisible(false);
                    this.jLabel12.setVisible(false);
                    this.currentTxt.setText("");
                    this.currentTxt.setVisible(false);
                }
                this.velTxt.setText("");
                this.accelTxt.setText("");
                this.posTxt.setText("");
                this.targetPosTxt.setText("");
                this.velScrl.setEnabled(false);
                this.velScrl.setValue(0);
                this.accelScrl.setEnabled(false);
                this.accelScrl.setValue(0);
                this.targetPosScrl.setEnabled(false);
                this.targetPosScrl.setValue(0);
                for (int i = 0; i < 4; ++i) {
                    this.inputArray[i].setVisible(false);
                }
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.stepper.removeAttachListener(this.attach_listener);
            this.stepper.removeDetachListener(this.detach_listener);
            this.stepper.removeErrorListener(this.error_listener);
            this.stepper.removeCurrentChangeListener(this.current_listener);
            this.stepper.removeInputChangeListener(this.input_listener);
            this.stepper.removeStepperPositionChangeListener(this.position_listener);
            this.stepper.removeStepperVelocityChangeListener(this.velocity_listener);
            this.stepper.close();
            this.stepper = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Stepper().setVisible(true);
            }
        });
    }
}

