/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.AdvancedServoPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AdvServoAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numServosTxt;
    private JComboBox servoCmb;
    private JTextField actVelTxt;
    private JTextField actPosTxt;
    private JTextField currentTxt;
    private JSlider posScrl;
    private JTextField targetPosTxt;
    private JSlider velScrl;
    private JTextField targetVelTxt;
    private JSlider accelScrl;
    private JTextField accelTxt;
    private JCheckBox engagedChk;
    private JCheckBox rampingChk;

    public AdvServoAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numServosTxt, JComboBox servoCmb, JTextField actVelTxt, JTextField actPosTxt, JTextField currentTxt, JSlider posScrl, JTextField targetPosTxt, JSlider velScrl, JTextField targetVelTxt, JSlider accelScrl, JTextField accelTxt, JCheckBox engagedChk, JCheckBox rampingChk) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numServosTxt = numServosTxt;
        this.servoCmb = servoCmb;
        this.actVelTxt = actVelTxt;
        this.actPosTxt = actPosTxt;
        this.currentTxt = currentTxt;
        this.posScrl = posScrl;
        this.targetPosTxt = targetPosTxt;
        this.velScrl = velScrl;
        this.targetVelTxt = targetVelTxt;
        this.accelScrl = accelScrl;
        this.accelTxt = accelTxt;
        this.engagedChk = engagedChk;
        this.rampingChk = rampingChk;
    }

    public void attached(AttachEvent ae) {
        try {
            AdvancedServoPhidget attached = (AdvancedServoPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numServosTxt.setText(Integer.toString(attached.getMotorCount()));
            this.posScrl.setMaximum((int)attached.getPositionMax(0));
            this.posScrl.setMinimum((int)attached.getPositionMin(0));
            this.velScrl.setMaximum((int)attached.getVelocityMax(0));
            this.velScrl.setMinimum((int)attached.getVelocityMin(0));
            this.accelScrl.setMaximum((int)attached.getAccelerationMax(0));
            this.accelScrl.setMinimum((int)attached.getAccelerationMin(0));
            for (int i = 0; i < attached.getMotorCount(); ++i) {
                this.servoCmb.addItem(new Integer(i));
                attached.setPosition(i, 0.0);
                attached.setMaxVelocity(i, 0.0);
                attached.setAcceleration(i, 0.0);
                attached.setMotorOn(i, true);
            }
            this.servoCmb.setSelectedIndex(0);
            this.servoCmb.setEnabled(true);
            this.engagedChk.setSelected(attached.getMotorOn(0));
            this.engagedChk.setEnabled(true);
            this.rampingChk.setSelected(attached.getSpeedRampingOn(0));
            this.rampingChk.setEnabled(true);
            try {
                this.actPosTxt.setText(Double.toString(attached.getPosition(0)));
                this.actVelTxt.setText(Double.toString(attached.getMaxVelocity(0)));
            }
            catch (PhidgetException ex2) {
                this.actPosTxt.setText("Unknown");
                this.actVelTxt.setText("Unknown");
            }
            this.posScrl.setValueIsAdjusting(true);
            this.posScrl.setValue(0);
            this.targetPosTxt.setText(Integer.toString(this.posScrl.getValue()));
            this.posScrl.setValueIsAdjusting(false);
            this.velScrl.setValueIsAdjusting(true);
            this.velScrl.setValue(0);
            this.targetVelTxt.setText(Integer.toString(this.velScrl.getValue()));
            this.velScrl.setValueIsAdjusting(false);
            this.accelScrl.setValueIsAdjusting(true);
            this.accelScrl.setValue(0);
            this.accelTxt.setText(Integer.toString(this.accelScrl.getValue()));
            this.accelScrl.setValueIsAdjusting(false);
            this.posScrl.setEnabled(true);
            this.velScrl.setEnabled(true);
            this.accelScrl.setEnabled(true);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

