/*
 * Decompiled with CFR 0.152.
 */
package PHSensor;

import com.phidgets.PHSensorPhidget;
import com.phidgets.PhidgetException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import listeners.PHAttachListener;
import listeners.PHDetachListener;
import listeners.PHErrorListener;
import listeners.PHPHChangeListener;
import org.jdesktop.layout.GroupLayout;

public class PHSensor
extends JFrame {
    private static String[] runArgs;
    private PHSensorPhidget ph;
    private PHAttachListener attach_listener;
    private PHDetachListener detach_listener;
    private PHErrorListener error_listener;
    private PHPHChangeListener ph_listener;
    private JLabel PHRngLbl;
    private JTextField attachedTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JTextField phTxt;
    private JTextField potTxt;
    private JLabel potentialRngLbl;
    private JTextField sensitivityTxt;
    private JTextField serialTxt;
    private JTextField tempTxt;
    private JTextField versionTxt;

    public PHSensor() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPanel2 = new JPanel();
        this.phTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.potTxt = new JTextField();
        this.jLabel6 = new JLabel();
        this.sensitivityTxt = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.tempTxt = new JTextField();
        this.PHRngLbl = new JLabel();
        this.potentialRngLbl = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("PHSensor - full");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                PHSensor.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                PHSensor.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("PHSensor Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(35, 35, 35).add(jPanel1Layout.createParallelGroup(2).add(this.jLabel1).add(this.jLabel2).add(this.jLabel4).add(this.jLabel3)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.versionTxt).add(1, this.serialTxt).add(1, this.attachedTxt).add(1, this.jScrollPane1)).addContainerGap(12, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jScrollPane1, -2, -1, -2).add(this.jLabel2)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Sensor Data"));
        this.phTxt.setEditable(false);
        this.jLabel5.setText("Measured PH:");
        this.potTxt.setEditable(false);
        this.jLabel6.setText("Potential:");
        this.sensitivityTxt.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                PHSensor.this.sensitivityTxtKeyReleased(evt);
            }
        });
        this.jLabel7.setText("Sensitivity:");
        this.jLabel8.setText("Temperature:");
        this.tempTxt.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                PHSensor.this.tempTxtKeyReleased(evt);
            }
        });
        this.PHRngLbl.setText("()");
        this.potentialRngLbl.setText("()");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(10, 10, 10).add(this.PHRngLbl)).add(this.jLabel5))).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(10, 10, 10).add(this.potentialRngLbl)).add(this.jLabel6))).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.jLabel7)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.jLabel8))).addPreferredGap(0, 55, Short.MAX_VALUE).add(jPanel2Layout.createParallelGroup(1, false).add(this.tempTxt).add(this.sensitivityTxt).add(this.potTxt).add(2, this.phTxt, -1, 123, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel5).add(this.phTxt, -2, -1, -2)).addPreferredGap(0).add(this.PHRngLbl).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel6).add(this.potTxt, -2, -1, -2)).addPreferredGap(0).add(this.potentialRngLbl).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel7).add(this.sensitivityTxt, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel8).add(this.tempTxt, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, this.jPanel1, -2, -1, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.jPanel1, this.jPanel2}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.sensitivityTxt.setEnabled(false);
        this.sensitivityTxt.setText("");
        this.tempTxt.setEnabled(false);
        this.tempTxt.setText("");
        try {
            this.ph = new PHSensorPhidget();
            this.attach_listener = new PHAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.phTxt, this.PHRngLbl, this.potTxt, this.potentialRngLbl, this.sensitivityTxt, this.tempTxt);
            this.detach_listener = new PHDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.phTxt, this.PHRngLbl, this.potTxt, this.potentialRngLbl, this.sensitivityTxt, this.tempTxt);
            this.error_listener = new PHErrorListener(this);
            this.ph_listener = new PHPHChangeListener(this, this.phTxt, this.potTxt);
            this.ph.addAttachListener(this.attach_listener);
            this.ph.addDetachListener(this.detach_listener);
            this.ph.addErrorListener(this.error_listener);
            this.ph.addPHChangeListener(this.ph_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.ph.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.ph.open(Integer.parseInt(runArgs[0]));
            } else {
                this.ph.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void sensitivityTxtKeyReleased(KeyEvent evt) {
        if (this.sensitivityTxt.isEnabled()) {
            try {
                this.ph.setPHChangeTrigger(Double.parseDouble(this.sensitivityTxt.getText()));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
            catch (NumberFormatException ex) {
                try {
                    this.ph.setPHChangeTrigger(0.0);
                }
                catch (PhidgetException ex2) {
                    JOptionPane.showMessageDialog(this, ex2.getDescription(), "Phidget Error" + ex2.getErrorNumber(), 0);
                }
                this.sensitivityTxt.setText("0");
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.ph.removePHChangeListener(this.ph_listener);
            this.ph.removeErrorListener(this.error_listener);
            this.ph.removeDetachListener(this.detach_listener);
            this.ph.removeAttachListener(this.attach_listener);
            this.ph.close();
            this.ph = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void tempTxtKeyReleased(KeyEvent evt) {
        if (this.tempTxt.isEnabled()) {
            try {
                this.ph.setTemperature(Double.parseDouble(this.tempTxt.getText()));
                this.PHRngLbl.setText("(" + this.ph.getPotentialMin() + " - " + this.ph.getPotentialMax() + ")");
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Number Format Error", 0);
            }
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PHSensor().setVisible(true);
            }
        });
    }
}

