/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.InterfaceKitPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class IFKitAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numDigiInTxt;
    private JTextField numDigiOutTxt;
    private JTextField numSensorTxt;
    private JCheckBox[] digiInArray;
    private JCheckBox[] digiOutArray;
    private JTextField[] sensorInArray;
    private JCheckBox ratioChk;
    private JLabel jLabel8;
    private JTextField sensitivityTxt;
    private JSlider sensitivityScrl;

    public IFKitAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numDigiInTxt, JTextField numDigiOutTxt, JTextField numSensorTxt, JCheckBox[] digiInArray, JCheckBox[] digiOutArray, JTextField[] sensorInArray, JCheckBox ratioChk, JLabel jLabel8, JTextField sensitivityTxt, JSlider sensitivityScrl) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numDigiInTxt = numDigiInTxt;
        this.numDigiOutTxt = numDigiOutTxt;
        this.numSensorTxt = numSensorTxt;
        this.digiInArray = digiInArray;
        this.digiOutArray = digiOutArray;
        this.sensorInArray = sensorInArray;
        this.ratioChk = ratioChk;
        this.jLabel8 = jLabel8;
        this.sensitivityTxt = sensitivityTxt;
        this.sensitivityScrl = sensitivityScrl;
    }

    public void attached(AttachEvent ae) {
        try {
            int i;
            InterfaceKitPhidget attached = (InterfaceKitPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numDigiInTxt.setText(Integer.toString(attached.getInputCount()));
            this.numDigiOutTxt.setText(Integer.toString(attached.getOutputCount()));
            this.numSensorTxt.setText(Integer.toString(attached.getSensorCount()));
            for (i = 0; i < attached.getInputCount(); ++i) {
                this.digiInArray[i].setVisible(true);
            }
            for (i = 0; i < attached.getOutputCount(); ++i) {
                this.digiOutArray[i].setVisible(true);
                this.digiOutArray[i].setSelected(false);
                this.digiOutArray[i].setEnabled(true);
            }
            if (attached.getSensorCount() > 0) {
                for (i = 0; i < attached.getSensorCount(); ++i) {
                    this.sensorInArray[i].setVisible(true);
                }
                this.jLabel8.setVisible(true);
                this.sensitivityScrl.setVisible(true);
                this.sensitivityScrl.setMaximum(1000);
                this.sensitivityScrl.setMinimum(0);
                this.sensitivityScrl.setValue(attached.getSensorChangeTrigger(0));
                this.sensitivityScrl.setEnabled(true);
                this.sensitivityTxt.setVisible(true);
                this.sensitivityTxt.setText(Integer.toString(this.sensitivityScrl.getValue()));
                this.ratioChk.setVisible(true);
                this.ratioChk.setEnabled(true);
                attached.setRatiometric(true);
                this.ratioChk.setSelected(attached.getRatiometric());
            } else {
                this.jLabel8.setVisible(false);
                this.sensitivityTxt.setVisible(false);
                this.sensitivityScrl.setEnabled(false);
                this.sensitivityScrl.setVisible(false);
                this.ratioChk.setVisible(false);
                this.ratioChk.setEnabled(false);
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

