/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.LEDPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LEDAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numLEDTxt;
    private JComboBox ledCmb;
    private JSlider ledBrightScrl;

    public LEDAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numLEDTxt, JComboBox ledCmb, JSlider ledBrightScrl) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numLEDTxt = numLEDTxt;
        this.ledCmb = ledCmb;
        this.ledBrightScrl = ledBrightScrl;
    }

    public void attached(AttachEvent ae) {
        try {
            LEDPhidget attached = (LEDPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numLEDTxt.setText(Integer.toString(attached.getLEDCount()));
            for (int i = 0; i < attached.getLEDCount(); ++i) {
                this.ledCmb.addItem(new Integer(i));
            }
            this.ledCmb.setEnabled(true);
            this.ledCmb.setSelectedIndex(0);
            this.ledBrightScrl.setEnabled(true);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

