/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.Dictionary;
import com.phidgets.PhidgetException;
import com.phidgets.event.KeyChangeEvent;
import com.phidgets.event.KeyChangeListener;
import com.phidgets.event.KeyRemovalEvent;
import com.phidgets.event.KeyRemovalListener;
import java.util.Iterator;
import java.util.LinkedList;

public class DictionaryKeyListener {
    private String pattern;
    Dictionary dict;
    private long handle = 0L;
    private long nativeHandler = 0L;
    public long listenerhandle = 0L;
    private LinkedList keyChangeListeners = new LinkedList();
    private long nativeKeyChangeHandler = 0L;
    private LinkedList keyRemovalListeners = new LinkedList();
    private long nativeKeyRemovalHandler = 0L;

    public void start() throws PhidgetException {
        this.handle = this.dict.handle;
        if (this.handle == 0L) {
            throw new PhidgetException(5, "Dictionary is not attached - call open first");
        }
        this.listenerhandle = this.enableDictionaryKeyEvents(this.keyChangeListeners.size() > 0 || this.keyRemovalListeners.size() > 0, this.pattern);
    }

    public void stop() {
        this.listenerhandle = this.enableDictionaryKeyEvents(false, this.pattern);
    }

    public Dictionary getDictionary() {
        return this.dict;
    }

    public DictionaryKeyListener(Dictionary dictionary, String string) {
        this.pattern = string;
        this.dict = dictionary;
        this.handle = dictionary.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addKeyChangeListener(KeyChangeListener keyChangeListener) {
        LinkedList linkedList = this.keyChangeListeners;
        synchronized (linkedList) {
            this.keyChangeListeners.add(keyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeKeyChangeListener(KeyChangeListener keyChangeListener) {
        LinkedList linkedList = this.keyChangeListeners;
        synchronized (linkedList) {
            this.keyChangeListeners.remove(keyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireKeyChange(KeyChangeEvent keyChangeEvent) {
        LinkedList linkedList = this.keyChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.keyChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((KeyChangeListener)iterator.next()).keyChanged(keyChangeEvent);
            }
        }
    }

    private native long enableDictionaryKeyEvents(boolean var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addKeyRemovalListener(KeyRemovalListener keyRemovalListener) {
        LinkedList linkedList = this.keyRemovalListeners;
        synchronized (linkedList) {
            this.keyRemovalListeners.add(keyRemovalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeKeyRemovalListener(KeyRemovalListener keyRemovalListener) {
        LinkedList linkedList = this.keyRemovalListeners;
        synchronized (linkedList) {
            this.keyRemovalListeners.remove(keyRemovalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireKeyRemoval(KeyRemovalEvent keyRemovalEvent) {
        LinkedList linkedList = this.keyRemovalListeners;
        synchronized (linkedList) {
            Iterator iterator = this.keyRemovalListeners.iterator();
            while (iterator.hasNext()) {
                ((KeyRemovalListener)iterator.next()).keyRemoved(keyRemovalEvent);
            }
        }
    }

    public String toString() {
        return this.dict.toString() + "Dictionary Key Listener (" + this.pattern + "): ";
    }

    protected void finalize() {
        this.listenerhandle = this.enableDictionaryKeyEvents(false, this.pattern);
    }

    static {
        System.loadLibrary("phidget21");
    }
}

