/*
 * Decompiled with CFR 0.152.
 */
package RFID;

import com.phidgets.PhidgetException;
import com.phidgets.RFIDPhidget;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import listeners.RFIDAttachListener;
import listeners.RFIDDetachListener;
import listeners.RFIDErrorListener;
import listeners.RFIDTagGainListener;
import listeners.RFIDTagLossListener;
import org.jdesktop.layout.GroupLayout;

public class RFID
extends JFrame {
    private static String[] runArgs;
    private RFIDPhidget rfid;
    private RFIDAttachListener attach_listener;
    private RFIDDetachListener detach_listener;
    private RFIDErrorListener error_listener;
    private RFIDTagGainListener tagGain_listener;
    private RFIDTagLossListener tagLoss_listener;
    private JCheckBox antennaChk;
    private JTextField attachedTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JCheckBox ledChk;
    private JTextArea nameTxt;
    private JTextField numOutputsTxt;
    private JCheckBox out0Chk;
    private JCheckBox out1Chk;
    private JTextField serialTxt;
    private JTextField tagTxt;
    private JTextField versionTxt;

    public RFID() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numOutputsTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.antennaChk = new JCheckBox();
        this.out0Chk = new JCheckBox();
        this.ledChk = new JCheckBox();
        this.out1Chk = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.tagTxt = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setTitle("RFID - full");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                RFID.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                RFID.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("RFID Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setFont(new Font("Tahoma", 0, 11));
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        this.numOutputsTxt.setEditable(false);
        this.jLabel5.setText("Outputs:");
        this.antennaChk.setText("Antenna Enabled");
        this.antennaChk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.antennaChk.setMargin(new Insets(0, 0, 0, 0));
        this.antennaChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RFID.this.antennaChkActionPerformed(evt);
            }
        });
        this.out0Chk.setText("Output 0");
        this.out0Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.out0Chk.setMargin(new Insets(0, 0, 0, 0));
        this.out0Chk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RFID.this.out0ChkActionPerformed(evt);
            }
        });
        this.ledChk.setText("Led Enabled");
        this.ledChk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ledChk.setMargin(new Insets(0, 0, 0, 0));
        this.ledChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RFID.this.ledChkActionPerformed(evt);
            }
        });
        this.out1Chk.setText("Output 1");
        this.out1Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.out1Chk.setMargin(new Insets(0, 0, 0, 0));
        this.out1Chk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RFID.this.out1ChkActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(35, 35, 35).add(jPanel1Layout.createParallelGroup(2).add(this.jLabel1).add(this.jLabel2).add(this.jLabel3).add(this.jLabel4).add(this.jLabel5)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.numOutputsTxt).add(1, this.versionTxt).add(1, this.serialTxt).add(1, this.attachedTxt).add(1, this.jScrollPane1))).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(this.antennaChk).add(this.ledChk)).add(25, 25, 25).add(jPanel1Layout.createParallelGroup(1).add(this.out1Chk).add(this.out0Chk)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jScrollPane1, -2, -1, -2).add(this.jLabel2)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numOutputsTxt, -2, -1, -2).add(this.jLabel5)).add(31, 31, 31).add(jPanel1Layout.createParallelGroup(3).add(this.antennaChk).add(this.out0Chk)).add(18, 18, 18).add(jPanel1Layout.createParallelGroup(3).add(this.ledChk).add(this.out1Chk)).addContainerGap(20, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Tag Info"));
        this.jLabel6.setText("Tag Data:");
        this.tagTxt.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(40, 40, 40).add(this.jLabel6).addPreferredGap(0).add(this.tagTxt, -1, 163, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(3).add(this.tagTxt, -2, -1, -2).add(this.jLabel6)).addContainerGap(22, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel2, -2, -1, -2).add(this.jPanel1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.antennaChk.setEnabled(false);
        this.ledChk.setEnabled(false);
        this.out0Chk.setEnabled(false);
        this.out1Chk.setEnabled(false);
        try {
            this.rfid = new RFIDPhidget();
            this.attach_listener = new RFIDAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numOutputsTxt, this.antennaChk, this.ledChk, this.out0Chk, this.out1Chk);
            this.detach_listener = new RFIDDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numOutputsTxt, this.antennaChk, this.ledChk, this.out0Chk, this.out1Chk);
            this.error_listener = new RFIDErrorListener(this);
            this.tagGain_listener = new RFIDTagGainListener(this.tagTxt);
            this.tagLoss_listener = new RFIDTagLossListener(this.tagTxt);
            this.rfid.addAttachListener(this.attach_listener);
            this.rfid.addDetachListener(this.detach_listener);
            this.rfid.addErrorListener(this.error_listener);
            this.rfid.addTagGainListener(this.tagGain_listener);
            this.rfid.addTagLossListener(this.tagLoss_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.rfid.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.rfid.open(Integer.parseInt(runArgs[0]));
            } else {
                this.rfid.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void antennaChkActionPerformed(ActionEvent evt) {
        try {
            this.rfid.setAntennaOn(this.antennaChk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void ledChkActionPerformed(ActionEvent evt) {
        try {
            this.rfid.setLEDOn(this.ledChk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void out0ChkActionPerformed(ActionEvent evt) {
        try {
            this.rfid.setOutputState(0, this.out0Chk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void out1ChkActionPerformed(ActionEvent evt) {
        try {
            this.rfid.setOutputState(1, this.out1Chk.isSelected());
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.rfid.removeTagLossListener(this.tagLoss_listener);
            this.rfid.removeTagGainListener(this.tagGain_listener);
            this.rfid.removeErrorListener(this.error_listener);
            this.rfid.removeDetachListener(this.detach_listener);
            this.rfid.removeAttachListener(this.attach_listener);
            this.rfid.close();
            this.rfid = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new RFID().setVisible(true);
            }
        });
    }
}

