' - TextLCD full -
' This example creates a nice gui to display the connected TextLCD's details as well as provides fields and checkboxes to
' manipulate all of the available controls and methods for a TextLCD such as backlight, cursor, cursor blink, brightness, contrast,
' screen, screen size, initialize, and a simulation of the custom characters ability of the TextLCD api.
' NOTE: For the Text LCD Adapter, you must select the screen and screen size before any of the other functions can be used.
' The method to create a custom character is not simply straight bit setting.  There is a web tool located in the documentation section of the
' website that one can refer to in order to generate the int values to generate a custom character
'
' Please note that this example was designed to work with only one Phidget TextLCD connected. 
'
' Copyright 2011 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1

    Dim WithEvents phidgetLCD As Phidgets.TextLCD
    Dim textOriginals(,) As String = {{"", "", "", ""}, {"", "", "", ""}}
    Dim currScreen As Integer = 0

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    'initialize our TextLCD Phidget and hook the event handlers
    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        phidgetLCD = New Phidgets.TextLCD
        phidgetLCD.open()

        attachedText.Text = "False"

        dispText1.Enabled = False
        dispText2.Enabled = False
        dispText3.Enabled = False
        dispText4.Enabled = False
        initBtn.Enabled = False
        backlightChk.Enabled = False
        cursorChk.Enabled = False
        cursorBlinkChk.Enabled = False
        customChrChk.Enabled = False
        contrastTrkBr.Enabled = False

        screenCmb.Enabled = False
        screenSizeCmb.Enabled = False
        brightnessTrkBar.Enabled = False
    End Sub

    'attach event handler...we will display the attach status and the attached TextLCD device's details
    'We will also enable the fields used to manipulate the TextLCD as well as do some initializing of
    'ranges and maximum values for some of these fields
    Private Sub lcd_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetLCD.Attach
        Dim i As Integer
        attachedText.Text = sender.Attached.ToString()
        nameText.Text = sender.Name
        serialText.Text = sender.SerialNumber.ToString()
        versionText.Text = sender.Version.ToString()

        If phidgetLCD.ID = Phidgets.Phidget.PhidgetID.TEXTLCD_ADAPTER Then

            screenCmb.Enabled = True
            screenCmb.Enabled = True
            For i = 0 To phidgetLCD.ScreenCount - 1
                screenCmb.Items.Add(i.ToString)
            Next i
            screenCmb.SelectedIndex = 0

            Dim screenSize As String
            screenSizeCmb.Enabled = True

            For Each screenSize In [Enum].GetNames(GetType(Phidgets.TextLCD.ScreenSizes))
                screenSizeCmb.Items.Add(screenSize.ToString)
            Next

            screenSizeCmb.SelectedItem = Phidgets.TextLCD.ScreenSizes.UNKNOWN.ToString

            brightnessTrkBar.Enabled = True
            brightnessTrkBar.SetRange(0, 255)
            brightnessTrkBar.Value = 88

        Else
            setAllTextFieldProperties(2)

            dispText1.MaxLength = phidgetLCD.rows(0).MaximumLength
            dispText2.MaxLength = phidgetLCD.rows(1).MaximumLength
            If phidgetLCD.ID = Phidgets.TextLCD.PhidgetID.TEXTLCD_2x20_w_8_8_8 And phidgetLCD.Version >= 200 Then
                brightnessTrkBar.Enabled = True
                brightnessTrkBar.SetRange(0, 255)
                brightnessTrkBar.Value = 88
            End If
        End If

            initBtn.Enabled = True
            backlightChk.Enabled = True
            cursorChk.Enabled = True
            cursorBlinkChk.Enabled = True
            customChrChk.Enabled = True
            contrastTrkBr.Enabled = True
            contrastTrkBr.SetRange(0, 255)
        contrastTrkBr.Value = 88

            Try
                phidgetLCD.Backlight = True
                backlightChk.Checked = phidgetLCD.Backlight
            Catch ex As Phidgets.PhidgetException
            End Try

            phidgetLCD.Cursor = True
        cursorChk.Checked = True
            phidgetLCD.CursorBlink = True
            cursorBlinkChk.Checked = phidgetLCD.CursorBlink
    End Sub

    'detach event handler.... we will display the device attach status and clear all the other fields
    Private Sub lcd_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetLCD.Detach
        attachedText.Text = sender.Attached.ToString()
        nameText.Clear()
        serialText.Clear()
        versionText.Clear()
        clearTextBoxes()
        dispText1.Enabled = False
        dispText2.Enabled = False
        dispText3.Enabled = False
        dispText4.Enabled = False
        initBtn.Enabled = False
        backlightChk.Enabled = False
        backlightChk.Checked = False
        cursorChk.Enabled = False
        cursorChk.Checked = False
        cursorBlinkChk.Enabled = False
        cursorBlinkChk.Checked = False
        customChrChk.Enabled = False
        customChrChk.Checked = False
        contrastTrkBr.Enabled = False
        contrastTrkBr.Enabled = False
        brightnessTrkBar.Enabled = False
        screenCmb.Items.Clear()
        screenCmb.Enabled = False
        screenSizeCmb.Items.Clear()
        screenSizeCmb.Enabled = False
    End Sub

    'Error event handler..we will simply display the error details text in a popup message box
    Private Sub lcd_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetLCD.Error
        MessageBox.Show(e.Description)
    End Sub

    'line 1 textChanged event handler...when the user is entering text, pass it on to the textLCD to be displayed
    Private Sub dispText1_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dispText1.TextChanged
        Try
            phidgetLCD.rows(0).DisplayString = sender.Text
        Catch ex As Exception
        End Try
    End Sub

    'line 2 textChanged event handler...when the user is entering text, pass it on to the textLCD to be displayed
    Private Sub dispText2_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dispText2.TextChanged
        Try
            phidgetLCD.rows(1).DisplayString = sender.Text
        Catch ex As Exception
        End Try
    End Sub

    'line 3 textChanged event handler...when the user is entering text, pass it on to the textLCD to be displayed
    Private Sub dispText3_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dispText3.TextChanged
        Try
            phidgetLCD.rows(2).DisplayString = sender.Text
        Catch ex As Exception
        End Try
    End Sub

    'line 4 textChanged event handler...when the user is entering text, pass it on to the textLCD to be displayed
    Private Sub dispText4_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dispText4.TextChanged
        Try
            phidgetLCD.rows(3).DisplayString = sender.Text
        Catch ex As Exception
        End Try
    End Sub

    'If the clear button is clicked, we want to clear the fields as well as clear the TextLCD screen
    Private Sub initBtn_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles initBtn.Click
        clearTextBoxes()
        Try
            If phidgetLCD.ID = Phidgets.Phidget.PhidgetID.TEXTLCD_ADAPTER Then
                phidgetLCD.initialize()
            Else
                phidgetLCD.rows(0).DisplayString = ""
                phidgetLCD.rows(1).DisplayString = ""
            End If
        Catch ex As Phidgets.PhidgetException
        End Try
    End Sub

    'Enable or disable the backlight by clicking on the checkbox
    Private Sub backlightChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles backlightChk.CheckedChanged
        Try
            phidgetLCD.Backlight = backlightChk.Checked
        Catch ex As Phidgets.PhidgetException
        End Try
    End Sub

    'enable or disable the cursor by clicking on the checkbox
    Private Sub cursorChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cursorChk.CheckedChanged
        Try
            phidgetLCD.Cursor = cursorChk.Checked
        Catch ex As Phidgets.PhidgetException
        End Try
    End Sub

    'enable or disable a blinking cursor by clicking on the checkbox
    Private Sub cursorBlinkChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cursorBlinkChk.CheckedChanged
        Try
            phidgetLCD.CursorBlink = cursorBlinkChk.Checked
        Catch ex As Phidgets.PhidgetException
        End Try
    End Sub

    'display the simulation of the custom characters when the checkbox is clicked. the screen must be atleast 2 rows and 20 columns
    Private Sub customChrChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles customChrChk.CheckedChanged
        Try
            If (sender.Checked) Then
                phidgetLCD.rows(0).DisplayString = "Testing Custom Chars"
                phidgetLCD.customCharacters(0).setCustomCharacter(949247, 536)
                phidgetLCD.customCharacters(1).setCustomCharacter(1015791, 17180)
                phidgetLCD.customCharacters(2).setCustomCharacter(1048039, 549790)
                phidgetLCD.customCharacters(3).setCustomCharacter(1031395, 816095)
                phidgetLCD.customCharacters(4).setCustomCharacter(498785, 949247)
                phidgetLCD.customCharacters(5).setCustomCharacter(232480, 1015791)
                phidgetLCD.customCharacters(6).setCustomCharacter(99328, 1048039)
                phidgetLCD.rows(1).DisplayString = phidgetLCD.customCharacters(0).StringCode & _
                    phidgetLCD.customCharacters(1).StringCode & _
                    phidgetLCD.customCharacters(2).StringCode & _
                    phidgetLCD.customCharacters(3).StringCode & _
                    phidgetLCD.customCharacters(4).StringCode & _
                    phidgetLCD.customCharacters(5).StringCode & _
                phidgetLCD.customCharacters(6).StringCode()

            Else
                phidgetLCD.rows(0).DisplayString = ""
                phidgetLCD.rows(1).DisplayString = ""
            End If
        Catch ex As Exception
            MessageBox.Show("The screen must be atleast 2 rows and 20 columns", "Custom Char")
        End Try
    End Sub

    'adjust the contast of the screen on the textLCD based on the value selected on the slider (0 to 255)
    Private Sub contrastTrkBr_Scroll(ByVal sender As Object, ByVal e As System.EventArgs) Handles contrastTrkBr.Scroll
        Try
            phidgetLCD.Contrast = contrastTrkBr.Value
        Catch ex As Phidgets.PhidgetException

        End Try
    End Sub

    'adjust the brightness of the screen on the textLCD based on the value selected on the slider (0 to 255)
    Private Sub brightnessTrkBar_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles brightnessTrkBar.Scroll
        Try
            phidgetLCD.Brightness = brightnessTrkBar.Value
        Catch ex As Phidgets.PhidgetException

        End Try
    End Sub

    Private Sub screenCmb_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles screenCmb.SelectedIndexChanged
        Try
            If phidgetLCD.Attached Then

                'make copy of all text
                textOriginals(currScreen, 0) = dispText1.Text
                textOriginals(currScreen, 1) = dispText2.Text
                textOriginals(currScreen, 2) = dispText3.Text
                textOriginals(currScreen, 3) = dispText4.Text

                phidgetLCD.Screen = screenCmb.SelectedIndex
                currScreen = screenCmb.SelectedIndex

                'display text for the current screen
                dispText1.Text = textOriginals(screenCmb.SelectedIndex, 0)
                dispText2.Text = textOriginals(screenCmb.SelectedIndex, 1)
                dispText3.Text = textOriginals(screenCmb.SelectedIndex, 2)
                dispText4.Text = textOriginals(screenCmb.SelectedIndex, 3)

                Try
                    screenSizeCmb.SelectedItem = phidgetLCD.ScreenSize.ToString
                Catch ex As Phidgets.PhidgetException
                    screenSizeCmb.SelectedItem = Phidgets.TextLCD.ScreenSizes.UNKNOWN.ToString
                End Try

                Try
                    backlightChk.Checked = phidgetLCD.Backlight
                Catch ex As Phidgets.PhidgetException
                End Try

                Try
                    cursorBlinkChk.Checked = phidgetLCD.CursorBlink
                    cursorChk.Checked = phidgetLCD.Cursor
                Catch ex As Phidgets.PhidgetException
                End Try

                Try
                    contrastTrkBr.Value = phidgetLCD.Contrast
                Catch ex As Exception
                End Try

                Try
                    brightnessTrkBar.Value = phidgetLCD.Brightness
                Catch ex As Exception
                End Try
            End If
        Catch ex As Phidgets.PhidgetException

        End Try

    End Sub

    Private Sub screenSizeCmb_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles screenSizeCmb.SelectedIndexChanged
        Try

            If phidgetLCD.Attached Then
              
                If screenSizeCmb.SelectedItem.ToString = Phidgets.TextLCD.ScreenSizes.NONE.ToString Or screenSizeCmb.SelectedItem.ToString = Phidgets.TextLCD.ScreenSizes.UNKNOWN.ToString Then
                    setAllTextFieldProperties(0)
                Else
                    phidgetLCD.ScreenSize = DirectCast([Enum].Parse(GetType(Phidgets.TextLCD.ScreenSizes), screenSizeCmb.SelectedItem.ToString), Phidgets.TextLCD.ScreenSizes)
                    setRowEnables()
                    Try
                        dispText1.MaxLength = phidgetLCD.rows(0).MaximumLength
                        dispText2.MaxLength = phidgetLCD.rows(0).MaximumLength
                        dispText3.MaxLength = phidgetLCD.rows(0).MaximumLength
                        dispText4.MaxLength = phidgetLCD.rows(0).MaximumLength
                    Catch ex As Phidgets.PhidgetException
                    End Try
                End If
            End If
        Catch ex As Phidgets.PhidgetException
            screenSizeCmb.SelectedValue = Phidgets.TextLCD.ScreenSizes.UNKNOWN.ToString
            setRowEnables()
        End Try

    End Sub

    Private Sub clearTextBoxes()
        dispText1.Clear()
        dispText2.Clear()
        dispText3.Clear()
        dispText4.Clear()

        Dim i, j As Integer
        For i = 0 To 1
            For j = 0 To 3
                textOriginals(i, j) = ""
            Next
        Next
    End Sub

    Private Sub setRowEnables()
        Try
            setAllTextFieldProperties(phidgetLCD.rows.Count)
        Catch ex As Phidgets.PhidgetException
        End Try
    End Sub
    Private Sub setAllTextFieldProperties(ByVal rows As Integer)
     
          Select rows
            Case 1
                setFieldProperties(dispText1, True)
                setFieldProperties(dispText2, False)
                setFieldProperties(dispText3, False)
                setFieldProperties(dispText4, False)
            Case 2
                setFieldProperties(dispText1, True)
                setFieldProperties(dispText2, True)
                setFieldProperties(dispText3, False)
                setFieldProperties(dispText4, False)
            Case 3
                setFieldProperties(dispText1, True)
                setFieldProperties(dispText2, True)
                setFieldProperties(dispText3, True)
                setFieldProperties(dispText4, False)
            Case 4
                setFieldProperties(dispText1, True)
                setFieldProperties(dispText2, True)
                setFieldProperties(dispText3, True)
                setFieldProperties(dispText4, True)
            Case Else
                setFieldProperties(dispText1, False)
                setFieldProperties(dispText2, False)
                setFieldProperties(dispText3, False)
                setFieldProperties(dispText4, False)
        End Select
    End Sub

    Private Sub setFieldProperties(ByVal dispText As TextBox, ByVal state As Boolean)
        dispText.Enabled = state
    End Sub

    'When the application is terminating, close the Phidget.
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        RemoveHandler phidgetLCD.Attach, AddressOf lcd_Attach
        RemoveHandler phidgetLCD.Detach, AddressOf lcd_Detach
        RemoveHandler phidgetLCD.Error, AddressOf lcd_Error

        Application.DoEvents()
        phidgetLCD.close()
        phidgetLCD = Nothing
    End Sub
End Class
