'A reference to the Phidget21.NET.dll must be added to new projects in VB.Net 
'From the "Project" menu select "Add Reference" 
'From the "Add Reference" window select the "Browse" tab 
'Browse to the directory you installed the Phidgets library to 
'The default is "C:\Program Files\Phidgets" 
'Select "Phidget21.NET.dll" and click "OK" 
'To view objects that have been added, select the "View" menu 
'Select "Object Browser" 
'Then expand the Phidget21.NET.dll item 

Public Class Form1
    Dim WithEvents sensor As Phidgets.TemperatureSensor


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        sensor = New Phidgets.TemperatureSensor()
        sensor.open()
        'Defaults for text fields
        txtStatus.Text = "Not Connected"

    End Sub

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    Private Sub sensor_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles sensor.Attach
        'When the Phidget RFID attaches update the form text boxes
        Label1.Text = "PhidgetTemperatureSensor has Attached"
        txtStatus.Text = "Connected"
        txtSerialNumber.Text = (Str(sensor.SerialNumber))
        sensor.thermocouples(0).Sensitivity = 0

    End Sub
    Private Sub sensor_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles sensor.Detach
        'If the Phidget RFID detaches close the form
        Me.Close()

    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'If the form closes and the PhidgetEncoder is attached Close it.
        If sensor.Attached = True Then
            sensor.close()
        End If
    End Sub

    Private Sub sensor_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles sensor.Error
        MessageBox.Show(e.Description)
        Me.Close()
    End Sub

    Private Sub sensor_TemperatureChange(ByVal sender As Object, ByVal e As Phidgets.Events.TemperatureChangeEventArgs) Handles sensor.TemperatureChange
        If e.Index = 0 Then
            TextBox1.Text = e.Temperature.ToString
        ElseIf e.Index = 1 Then
            TextBox2.Text = e.Temperature.ToString
        End If

    End Sub

End Class



