'A reference to the Phidget21.NET.dll must be added to new projects in VB.Net
'From the "Project" menu select "Add Reference"
'From the "Add Reference" window select the ".NET" tab
'select "Phidget21.NET" and click "OK"

Public Class Form1

    Dim WithEvents stepper As Phidgets.Stepper

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        stepper = New Phidgets.Stepper
        stepper.open()
    End Sub

    Private Sub stepper_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles stepper.Attach
        attachedTxt.Text = stepper.Attached.ToString()
        nameTxt.Text = stepper.Name
        serialTxt.Text = stepper.SerialNumber.ToString()
        versiontxt.Text = stepper.Version.ToString()
        numSteppersTxt.Text = stepper.steppers.Count.ToString()

        velocityTrk.SetRange(stepper.steppers(0).VelocityMin, stepper.steppers(0).VelocityMax)
        velocityTrk.TickFrequency = stepper.steppers(0).VelocityMax / 64
        velocityTrk.LargeChange = stepper.steppers(0).VelocityMax / 64
        accelTrk.SetRange(stepper.steppers(0).AccelerationMin, stepper.steppers(0).AccelerationMax)
        accelTrk.TickFrequency = stepper.steppers(0).AccelerationMin * 4
        accelTrk.LargeChange = stepper.steppers(0).AccelerationMin
        positionTrk.SetRange(-20000, 20000) 'Have arbitrarily chosen a range of -20000 - 20000, but the maximum range is closer to +-549000000000
        positionTrk.TickFrequency = 1000
        positionTrk.LargeChange = 250
        currentPositionTrk.SetRange(-20000, 20000) 'Have arbitrarily chosen a range of -20000 - 20000, but the maximum range is closer to +-549000000000
        currentPositionTrk.TickFrequency = 1000
        currentPositionTrk.LargeChange = 250

        velocityTrk.Enabled = True
        accelTrk.Enabled = True
        positionTrk.Enabled = True
        currentPositionTrk.Enabled = True
        engagedCheckBox.Enabled = True
        stepperCmb.Enabled = True

        Select Case stepper.ID
            'Only a Bipolar stepper has access to these features
            Case Phidgets.Phidget.PhidgetID.BIPOLAR_STEPPER_1MOTOR
                currentLimitTrk.Visible = True
                currentLimitTxt.Visible = True
                currentTxt.Visible = True
                currentLimitLbl.Visible = True
                currentLimitTrkLbl.Visible = True
                currentLbl.Visible = True

                currentLimitTrk.Enabled = True

                inputsGrp.Visible = True

                currentLimitTrk.SetRange((stepper.steppers(0).CurrentMin * 100.0), (stepper.steppers(0).CurrentMax * 100.0)) ' Range for the current limit
                currentLimitTrk.TickFrequency = 5

            Case Phidgets.Phidget.PhidgetID.UNIPOLAR_STEPPER_4MOTOR
                currentLimitTrk.Visible = False
                currentLimitTxt.Visible = False
                currentTxt.Visible = False
                currentLimitLbl.Visible = False
                currentLimitTrkLbl.Visible = False
                currentLbl.Visible = False

                inputsGrp.Visible = False
        End Select

        For i As Integer = 0 To stepper.steppers.Count - 1
            stepperCmb.Items.Add(i)
        Next i

        stepperCmb.SelectedIndex = 0
    End Sub

    Private Sub stepper_CurrentChange(ByVal sender As Object, ByVal e As Phidgets.Events.CurrentChangeEventArgs) Handles stepper.CurrentChange
        If e.Index = stepperCmb.SelectedItem Then
            currentTxt.Text = e.Current.ToString()
        End If
    End Sub

    Private Sub stepper_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles stepper.Detach
        attachedTxt.Text = stepper.Attached.ToString()
        nameTxt.Clear()
        serialTxt.Clear()
        versiontxt.Clear()
        numSteppersTxt.Clear()

        velocityTrk.Enabled = False
        accelTrk.Enabled = False
        positionTrk.Enabled = False
        currentPositionTrk.Enabled = False
        currentLimitTrk.Enabled = False
        engagedCheckBox.Enabled = False
        stepperCmb.Enabled = False

        positionTrk.Value = 0
        currentPositionTrk.Value = 0
        velocityTrk.Value = velocityTrk.Minimum
        accelTrk.Value = accelTrk.Minimum
        currentLimitTrk.Value = currentLimitTrk.Minimum

        velocityLimitTxt.Clear()
        velocityTxt.Clear()
        accelTxt.Clear()
        positionTxt.Clear()
        targetPositionTxt.Clear()
        currentLimitTxt.Clear()
        currentTxt.Clear()

        engagedCheckBox.Checked = False
        stoppedCheckBox.Checked = False

        stepperCmb.Items.Clear()
    End Sub

    Private Sub stepper_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles stepper.Error
        MessageBox.Show(e.exception.Message, "Error Event")
    End Sub

    Private Sub stepper_InputChange(ByVal sender As Object, ByVal e As Phidgets.Events.InputChangeEventArgs) Handles stepper.InputChange
        Dim inputChk As CheckBox = inputsGrp.Controls("input" + e.Index.ToString() + "Chk")
        inputChk.Checked = e.Value
    End Sub

    Private Sub stepper_PositionChange(ByVal sender As Object, ByVal e As Phidgets.Events.StepperPositionChangeEventArgs) Handles stepper.PositionChange
        If e.Index = stepperCmb.SelectedItem Then
            positionTxt.Text = e.Position.ToString()
            stoppedCheckBox.Checked = stepper.steppers(e.Index).Stopped
            If currentPositionTrk.Focused = False Then
                currentPositionTrk.Enabled = stepper.steppers(e.Index).Stopped
            End If
        End If
    End Sub

    Private Sub stepper_VelocityChange(ByVal sender As Object, ByVal e As Phidgets.Events.VelocityChangeEventArgs) Handles stepper.VelocityChange
        If e.Index = stepperCmb.SelectedItem Then
            velocityTxt.Text = e.Velocity.ToString()
            stoppedCheckBox.Checked = stepper.steppers(e.Index).Stopped
            If currentPositionTrk.Focused = False Then
                currentPositionTrk.Enabled = stepper.steppers(e.Index).Stopped
            End If
        End If
    End Sub

    Private Sub stepperCmb_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles stepperCmb.SelectedIndexChanged

        Try
            positionTrk.Value = stepper.steppers(stepperCmb.SelectedItem).TargetPosition
            targetPositionTxt.Text = stepper.steppers(stepperCmb.SelectedItem).TargetPosition.ToString()
        Catch
            positionTrk.Value = 0
            targetPositionTxt.Clear()
        End Try

        Try
            currentPositionTrk.Value = stepper.steppers(stepperCmb.SelectedItem).CurrentPosition
            positionTxt.Text = stepper.steppers(stepperCmb.SelectedItem).CurrentPosition.ToString()

        Catch

            currentPositionTrk.Value = 0
            positionTxt.Clear()
        End Try

        Try
            velocityTrk.Value = stepper.steppers(stepperCmb.SelectedItem).VelocityLimit
            velocityLimitTxt.Text = stepper.steppers(stepperCmb.SelectedItem).VelocityLimit.ToString()
        Catch
            velocityTrk.Value = velocityTrk.Minimum
            velocityLimitTxt.Clear()
        End Try

        Try
            accelTrk.Value = stepper.steppers(stepperCmb.SelectedItem).Acceleration
            accelTxt.Text = stepper.steppers(stepperCmb.SelectedItem).Acceleration.ToString()
        Catch
            accelTrk.Value = accelTrk.Minimum
            accelTxt.Clear()
        End Try

        Try
            velocityTxt.Text = stepper.steppers(stepperCmb.SelectedItem).Velocity.ToString()
        Catch
            velocityTxt.Clear()
        End Try

        Try
            currentTxt.Text = stepper.steppers(stepperCmb.SelectedItem).Current.ToString()
        Catch
            currentTxt.Clear()
        End Try

        Try
            stoppedCheckBox.Checked = stepper.steppers(stepperCmb.SelectedItem).Stopped
            currentPositionTrk.Enabled = stepper.steppers(stepperCmb.SelectedItem).Stopped
        Catch
            stoppedCheckBox.Checked = False
        End Try

        Try
            engagedCheckBox.Checked = stepper.steppers(stepperCmb.SelectedItem).Engaged
        Catch
            engagedCheckBox.Checked = False
        End Try

        currentLimitTxt.Clear()
        currentLimitTrk.Value = currentLimitTrk.Minimum
    End Sub

    Private Sub engagedCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles engagedCheckBox.CheckedChanged
        Try
            stepper.steppers(stepperCmb.SelectedItem).Engaged = engagedCheckBox.Checked
        Catch
        End Try
    End Sub

    Private Sub velocityTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles velocityTrk.Scroll
        Try
            Dim vel As Double = velocityTrk.Value

            If vel < stepper.steppers(stepperCmb.SelectedItem).VelocityMin Then
                vel = stepper.steppers(stepperCmb.SelectedItem).VelocityMin
            End If

            If vel > stepper.steppers(stepperCmb.SelectedItem).VelocityMax Then
                vel = stepper.steppers(stepperCmb.SelectedItem).VelocityMax
            End If

            stepper.steppers(stepperCmb.SelectedItem).VelocityLimit = vel
            velocityLimitTxt.Text = vel.ToString()
        Catch
            velocityLimitTxt.Text = "Err"
        End Try
    End Sub

    Private Sub accelTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles accelTrk.Scroll
        Try
            Dim accel As Double = accelTrk.Value

            If accel < stepper.steppers(stepperCmb.SelectedItem).AccelerationMin Then
                accel = stepper.steppers(stepperCmb.SelectedItem).AccelerationMin
            End If

            If accel > stepper.steppers(stepperCmb.SelectedItem).AccelerationMax Then
                accel = stepper.steppers(stepperCmb.SelectedItem).AccelerationMax
            End If

            stepper.steppers(stepperCmb.SelectedItem).Acceleration = accel
            accelTxt.Text = accel.ToString()
        Catch
            accelTxt.Text = "Err"
        End Try
    End Sub

    Private Sub positionTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles positionTrk.Scroll
        Try
            stepper.steppers(stepperCmb.SelectedItem).TargetPosition = positionTrk.Value
            targetPositionTxt.Text = positionTrk.Value.ToString()
        Catch
            targetPositionTxt.Text = "Err"
        End Try
    End Sub

    Private Sub currentPositionTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles currentPositionTrk.Scroll
        Try
            stepper.steppers(stepperCmb.SelectedItem).CurrentPosition = currentPositionTrk.Value
            targetPositionTxt.Text = currentPositionTrk.Value.ToString()
        Catch
            targetPositionTxt.Text = "Err"
        End Try
    End Sub

    Private Sub currentLimitTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles currentLimitTrk.Scroll
        Try
            Dim current As Double = currentLimitTrk.Value / 100.0

            If current < stepper.steppers(stepperCmb.SelectedItem).CurrentMin Then
                current = stepper.steppers(stepperCmb.SelectedItem).CurrentMin
            End If

            If current > stepper.steppers(stepperCmb.SelectedItem).CurrentMax Then
                current = stepper.steppers(stepperCmb.SelectedItem).CurrentMax
            End If

            stepper.steppers(stepperCmb.SelectedItem).CurrentLimit = current
            currentLimitTxt.Text = current.ToString()
        Catch
            currentLimitTxt.Text = "Err"
        End Try
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        RemoveHandler stepper.Attach, AddressOf stepper_Attach
        RemoveHandler stepper.CurrentChange, AddressOf stepper_CurrentChange
        RemoveHandler stepper.Detach, AddressOf stepper_Detach
        RemoveHandler stepper.Error, AddressOf stepper_Error
        RemoveHandler stepper.PositionChange, AddressOf stepper_PositionChange
        RemoveHandler stepper.VelocityChange, AddressOf stepper_VelocityChange
        RemoveHandler stepper.InputChange, AddressOf stepper_InputChange
        Application.DoEvents()

        If stepper.Attached Then
            For i As Integer = 0 To stepper.steppers.Count - 1
                stepper.steppers(i).Engaged = False
            Next i
        End If

        stepper.close()
        stepper = Nothing
    End Sub
End Class
