'A reference to the PhidgetNET.dll must be added to new projects in VB.Net
'From the "Project" menu select "Add Reference"
'From the "Add Reference" window select the "Browse" tab
'Browse to the directory you installed the Phidgets library to
'The default is "C:\Program Files\Phidgets"
'Select "PhidgetsNET.dll" and click "OK"
'To view objects that have been added, select the "View" menu
'Select "Object Browser"
'Then expand the PhidgetsNET.dll item

Public Class Form1
    Dim WithEvents phidgetRFID As Phidgets.RFID


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'To reduce code complexity we assume that there is one PhidgetRFID
        'attached to the PC before the program is run.
        phidgetRFID = New Phidgets.RFID()
        phidgetRFID.Open()
        'Defaults for text fields
        txtStatus.Text = "Not Connected"
    End Sub

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
        lvPhidgetInfo.MultiColumn = False
        lvPhidgetInfo.Items.Insert(0, "TagID             Count")
    End Sub

    Private Sub phidgetRFID_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetRFID.Attach
        'When the Phidget RFID attaches update the form text boxes
        Label1.Text = "Phidget RFID Reader has Attached"
        txtStatus.Text = "Connected"
        txtNumOutputs.Text = phidgetRFID.outputs.Count
        txtSerialNumber.Text = (Str(phidgetRFID.SerialNumber))
        phidgetRFID.Antenna = True
        CheckBox3.Checked = True
        phidgetRFID.LED = True
        CheckBox2.Checked = True

    End Sub
    Private Sub phidgetRFID_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetRFID.Detach
        'If the Phidget RFID detaches close the form
        Me.Close()

    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'If the form closes and the Phidget RFID is attached Close it.
        If phidgetRFID.Attached = True Then
            phidgetRFID.close()
        End If
    End Sub

    Private Sub phidgetRFID_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetRFID.Error
        'If the Phidget RFID is not attached when the form opens show
        'message box and close the form
        MessageBox.Show(e.Description)
        Me.Close()
    End Sub

    Private Sub phidgetRFID_RFIDTag(ByVal sender As Object, ByVal e As Phidgets.Events.TagEventArgs) Handles phidgetRFID.Tag
        Static count As Integer
        count = count + 1
        lvPhidgetInfo.BeginUpdate()
        lvPhidgetInfo.Items.Insert(1, e.Tag & "   " & count)
        lvPhidgetInfo.EndUpdate()
    End Sub
    Private Sub phidgetRFID_RFIDTagLost(ByVal sender As Object, ByVal e As Phidgets.Events.TagEventArgs) Handles phidgetRFID.TagLost
        lvPhidgetInfo.BeginUpdate()
        lvPhidgetInfo.Items.Insert(1, e.Tag & "   Lost")
        lvPhidgetInfo.EndUpdate()
    End Sub
    'This section handles the events for the four checkboxes
    'This is the simplest approach but the least elegant method.
    'It works here because there are only four outputs to handle but can quickly get out of hand
    'if there are more outputs to control. Below this section we have added a commented section
    'that handles all the check boxes in a single sub. Simply comment out the four subs below and
    'uncomment the sub CheckBox_CheckedChanged
    Private Sub CheckBox0_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox0.CheckedChanged
        phidgetRFID.outputs(0) = CheckBox0.CheckState
    End Sub
    Private Sub CheckBox1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox1.CheckedChanged
        phidgetRFID.outputs(1) = CheckBox1.CheckState
    End Sub
    Private Sub CheckBox2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox2.CheckedChanged
        phidgetRFID.LED = CheckBox2.CheckState
    End Sub
    Private Sub CheckBox3_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox3.CheckedChanged
        phidgetRFID.Antenna = CheckBox3.CheckState
    End Sub
    'This is the slightly more sophisticated approach to handling the events for all the checkboxes.
    'Private Sub CheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _
    'CheckBox0.CheckedChanged, CheckBox3.CheckedChanged, CheckBox2.CheckedChanged, CheckBox1.CheckedChanged
    '    RFID1.SetOutputState((CType(sender, System.Windows.Forms.CheckBox).Tag), CType(sender, System.Windows.Forms.CheckBox).CheckState)
    'Use this if you want to see what's going on: MessageBox.Show(CType(sender, System.Windows.Forms.CheckBox).Tag.ToString)
    'End Sub


End Class


