' Copyright 2011 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1
    Dim WithEvents phidgetMotor As Phidgets.MotorControl
    Private inputArray As CheckBox()
    Private encoderArray As TextBox()
    Private sensorArray As TextBox()

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Me.Size = New Size(Me.Size.Width, 301)

        phidgetMotor = New Phidgets.MotorControl

        Dim i As Integer

        attachedTxt.Text = "False"

        motorGrp.Visible = False
        backEMFChk.Enabled = False
        brakeTrk.Enabled = False

        ReDim inputArray(3)
        inputArray(0) = input0Chk
        inputArray(1) = input1Chk
        inputArray(2) = input2Chk
        inputArray(3) = input3Chk

        ReDim encoderArray(0)
        encoderArray(0) = encoderPosition0Txt

        ReDim sensorArray(1)
        sensorArray(0) = sensorValue0Txt
        sensorArray(1) = sensorValue1Txt

        digitalInputsGrp.Visible = False
        For i = 0 To 3
            inputArray(i).Visible = False
            inputArray(i).Enabled = False
        Next

        encoderGrp.Visible = False
        For i = 0 To 0
            encoderArray(i).Visible = False
            encoderArray(i).Enabled = False
        Next
        resetBtn.Enabled = False

        sensorGrp.Visible = False
        For i = 0 To 1
            sensorArray(i).Visible = False
            sensorArray(i).Enabled = False
        Next
        ratiometricChk.Enabled = False
        phidgetMotor.open()

    End Sub

    Private Sub phidgetMotor_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetMotor.Attach
        Dim i As Integer
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = sender.Name.ToString()
        serialTxt.Text = sender.SerialNumber.ToString()
        versiontxt.Text = sender.Version.ToString()
        numMotorsTxt.Text = phidgetMotor.motors.Count.ToString()
        numInputsTxt.Text = phidgetMotor.inputs.Count.ToString()
        numEncodersTxt.Text = phidgetMotor.encoders.Count.ToString()
        numSensorsTxt.Text = phidgetMotor.sensors.Count.ToString()


        If phidgetMotor.ID = Phidgets.Phidget.PhidgetID.MOTORCONTROL_1MOTOR Then

            backEMFChk.Enabled = True
            brakeTrk.Enabled = True
            brakeTrk.SetRange(0, 100)

            brakeTrk.Value = 0
            brakeTxt.Text = brakeTrk.Value

            supplyVoltageTimer.Start()

        End If

        voltageTxt.Text = "Unknown"

        velocityTrk.SetRange(-100, 100)
        accelTrk.SetRange(Math.Ceiling(phidgetMotor.motors(motorCmb.SelectedItem).AccelerationMin), phidgetMotor.motors(motorCmb.SelectedItem).AccelerationMax)
        accelTrk.Value = accelTrk.Minimum

        If phidgetMotor.motors.Count > 0 Then
            Me.Size = New Size(Me.Size.Width, 603)
            motorGrp.Visible = True
            For i = 0 To sender.motors.Count - 1
                motorCmb.Items.Add(i)
            Next
        End If
        motorCmb.Enabled = True
        motorCmb.SelectedIndex = 0

        'Re-size according to capabilities
        If phidgetMotor.inputs.Count > 0 Then
            digitalInputsGrp.Visible = True
            Me.Size = New Size(Me.Size.Width, 665)
            For i = 0 To phidgetMotor.inputs.Count - 1
                inputArray(i).Visible = True
                inputArray(i).Enabled = True
            Next
        End If

        If phidgetMotor.encoders.Count > 0 Then
            Me.Size = New Size(Me.Size.Width, 735)
            encoderGrp.Visible = True
            For i = 0 To phidgetMotor.encoders.Count - 1
                encoderArray(i).Visible = True
                encoderArray(i).Enabled = True
                encoderArray(i).Text = phidgetMotor.encoders(i).Position.ToString
            Next
            resetBtn.Enabled = True
        End If

        If phidgetMotor.sensors.Count > 0 Then

            Me.Size = New Size(Me.Size.Width, 808)
            sensorGrp.Visible = True
            For i = 0 To phidgetMotor.sensors.Count - 1
                sensorArray(i).Visible = True
                sensorArray(i).Enabled = True
            Next
            ratiometricChk.Enabled = True
            ratiometricChk.Checked = phidgetMotor.Ratiometric
        End If
      

    End Sub

    Private Sub phidgetMotor_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetMotor.Detach

        Dim i As Integer

        Me.Size = New Size(Me.Size.Width, 301)

        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Clear()
        serialTxt.Clear()
        versiontxt.Clear()
        numMotorsTxt.Clear()
        numInputsTxt.Clear()
        numEncodersTxt.Clear()
        numSensorsTxt.Clear()

        motorGrp.Visible = False
        motorCmb.Items.Clear()
        motorCmb.SelectedItem = 0
        motorCmb.Enabled = False

        velocityActualTxt.Clear()
        velocityMaximumTxt.Clear()
        AccelerationTxt.Clear()
        brakeTxt.Clear()
        currentTxt.Clear()
        backEMFChk.Checked = False
        backEMFTxt.Clear()
        voltageTxt.Clear()

        digitalInputsGrp.Visible = False
        For i = 0 To phidgetMotor.inputs.Count - 1
            inputArray(i).Visible = False
            inputArray(i).Enabled = False
            inputArray(i).Checked = False
        Next

        encoderGrp.Visible = False
        For i = 0 To phidgetMotor.encoders.Count - 1
            encoderArray(i).Visible = False
            encoderArray(i).Enabled = False
            encoderArray(i).Clear()
        Next
        resetBtn.Enabled = False

        sensorGrp.Visible = False
        For i = 0 To phidgetMotor.sensors.Count - 1
            sensorArray(i).Visible = False
            sensorArray(i).Enabled = False
            sensorArray(i).Clear()
        Next
        ratiometricChk.Checked = False

    End Sub

    Private Sub phidgetMotor_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetMotor.Error

        'Ignore this error - it's not useful in this context.
        If e.Type <> Phidgets.PhidgetException.ErrorType.PHIDGET_ERREVENT_PACKETLOST Then
            MessageBox.Show(e.Description)

        End If

    End Sub

    Private Sub phidgetMotor_CurrentChange(ByVal sender As Object, ByVal e As Phidgets.Events.CurrentChangeEventArgs) Handles phidgetMotor.CurrentChange
        If e.Index = motorCmb.SelectedIndex Then
            currentTxt.Text = e.Current.ToString("F3")
        End If
    End Sub

    Private Sub phidgetMotor_InputChange(ByVal sender As Object, ByVal e As Phidgets.Events.InputChangeEventArgs) Handles phidgetMotor.InputChange
        inputArray(e.Index).Checked = e.Value
    End Sub

    Private Sub phidgetMotor_VelocityChange(ByVal sender As Object, ByVal e As Phidgets.Events.VelocityChangeEventArgs) Handles phidgetMotor.VelocityChange
        If e.Index = motorCmb.SelectedIndex Then
            velocityActualTxt.Text = e.Velocity.ToString("F2")
        End If
    End Sub

    Private Sub phidgetMotor_BackEMFUpdate(ByVal sender As Object, ByVal e As Phidgets.Events.BackEMFUpdateEventArgs) Handles phidgetMotor.BackEMFUpdate
        If e.Index = motorCmb.SelectedIndex Then
            If backEMFChk.Checked = True Then
                backEMFTxt.Text = e.Value.ToString("F3")
            Else
                backEMFTxt.Text = "Unknown"
            End If
        End If
    End Sub

    Private Sub phidgetMotor_EncoderPositionChange(ByVal sender As Object, ByVal e As Phidgets.Events.EncoderPositionChangeEventArgs) Handles phidgetMotor.EncoderPositionChange
        encoderArray(e.Index).Text = phidgetMotor.encoders(e.Index).Position.ToString

    End Sub

    Private Sub phidgetMotor_SensorUpdate(ByVal sender As Object, ByVal e As Phidgets.Events.SensorUpdateEventArgs) Handles phidgetMotor.SensorUpdate
        sensorArray(e.Index).Text = e.Value.ToString
    End Sub

    Private Sub accelTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles accelTrk.Scroll
        phidgetMotor.motors(motorCmb.SelectedItem).Acceleration = accelTrk.Value
        AccelerationTxt.Text = accelTrk.Value.ToString()
    End Sub

    Private Sub velocityTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles velocityTrk.Scroll
        phidgetMotor.motors(motorCmb.SelectedItem).Velocity = velocityTrk.Value
        velocityMaximumTxt.Text = velocityTrk.Value.ToString("F2")

    End Sub

    Private Sub brakeTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles brakeTrk.Scroll
        Try
            phidgetMotor.motors(motorCmb.SelectedItem).Braking = brakeTrk.Value
            brakeTxt.Text = brakeTrk.Value
        Catch ex As Exception
        End Try
    End Sub

    Private Sub motorCmb_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles motorCmb.SelectedIndexChanged

        Try
            velocityMaximumTxt.Text = phidgetMotor.motors(motorCmb.SelectedItem).Velocity.ToString("F2")
            velocityTrk.Value = phidgetMotor.motors(motorCmb.SelectedItem).Velocity
            velocityActualTxt.Text = phidgetMotor.motors(motorCmb.SelectedIndex).Velocity.ToString("F2")
        Catch ex As Phidgets.PhidgetException
            velocityMaximumTxt.Text = "0"
            velocityTrk.Value = 0
        End Try

        Try
            AccelerationTxt.Text = phidgetMotor.motors(motorCmb.SelectedItem).Acceleration.ToString("F2")
            accelTrk.Value = Math.Ceiling(phidgetMotor.motors(motorCmb.SelectedItem).Acceleration)
        Catch ex As Phidgets.PhidgetException
            AccelerationTxt.Text = "Unknown"
        End Try

        Try
            brakeTxt.Text = phidgetMotor.motors(motorCmb.SelectedIndex).Braking.ToString("F2")
            brakeTrk.Value = phidgetMotor.motors(motorCmb.SelectedIndex).Braking
        Catch ex As Phidgets.PhidgetException
            brakeTxt.Text = "Unknown"
        End Try

        Try
            currentTxt.Text = phidgetMotor.motors(motorCmb.SelectedIndex).Current.ToString("F3")
        Catch ex As Phidgets.PhidgetException
            currentTxt.Text = "Unknown"
        End Try

        Try
            backEMFChk.Checked = phidgetMotor.motors(motorCmb.SelectedIndex).BackEMFSensing
        Catch ex As Phidgets.PhidgetException
            backEMFChk.Checked = False
        End Try

        If backEMFChk.Checked Then
            Try
                backEMFTxt.Text = phidgetMotor.motors(motorCmb.SelectedIndex).BackEMF.ToString("F3")
            Catch ex As Phidgets.PhidgetException
                backEMFTxt.Text = "Unknown"
            End Try
        Else
            backEMFTxt.Text = "Unknown"
        End If
    End Sub

    Private Sub resetBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles resetBtn.Click
        Dim i As Integer
        Try
            For i = 0 To phidgetMotor.encoders.Count - 1
                phidgetMotor.encoders(i).Position = 0
                encoderArray(i).Text = phidgetMotor.encoders(i).Position.ToString
            Next
        Catch ex As Phidgets.PhidgetException
        End Try
    End Sub

    Private Sub ratiometricChk_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ratiometricChk.CheckedChanged
        If phidgetMotor.Attached Then
            phidgetMotor.Ratiometric = ratiometricChk.Checked
        End If
    End Sub

    Private Sub backEMFChk_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles backEMFChk.CheckedChanged
        Try
            If phidgetMotor.Attached Then
                phidgetMotor.motors(motorCmb.SelectedItem).BackEMFSensing = backEMFChk.Checked
                If backEMFChk.Checked = False Then
                    backEMFTxt.Text = "Unknown"
                End If
            End If
        Catch ex As Phidgets.PhidgetException
        End Try
    End Sub

    Private Sub supplyVoltageTimer_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles supplyVoltageTimer.Tick
        Try
            voltageTxt.Text = phidgetMotor.SupplyVoltage.ToString("F2")
        Catch ex As Exception
            voltageTxt.Text = "Unknown"
            supplyVoltageTimer.Stop()
        End Try
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        Dim i As Integer
        If phidgetMotor.Attached = True Then
            For i = 0 To phidgetMotor.motors.Count - 1
                phidgetMotor.motors(i).Velocity = 0
            Next
        End If

        RemoveHandler phidgetMotor.VelocityChange, AddressOf phidgetMotor_VelocityChange
        RemoveHandler phidgetMotor.InputChange, AddressOf phidgetMotor_InputChange
        RemoveHandler phidgetMotor.Error, AddressOf phidgetMotor_Error
        RemoveHandler phidgetMotor.CurrentChange, AddressOf phidgetMotor_CurrentChange
        RemoveHandler phidgetMotor.BackEMFUpdate, AddressOf phidgetMotor_BackEMFUpdate
        RemoveHandler phidgetMotor.EncoderPositionChange, AddressOf phidgetMotor_EncoderPositionChange
        RemoveHandler phidgetMotor.SensorUpdate, AddressOf phidgetMotor_SensorUpdate
        RemoveHandler phidgetMotor.Attach, AddressOf phidgetMotor_Attach
        RemoveHandler phidgetMotor.Detach, AddressOf phidgetMotor_Detach
        Application.DoEvents()

        phidgetMotor.close()
    End Sub

End Class

