' - LED multiple -
' This example demonstrates the key functionalities of controlling two Phidget LEDs.  It will allow you to choose an attached LED board, and choose an LED index in order
' to control the LED plugged into that index port.  It will also display the phidget information for the connected LED.
'
' PLEASE NOTE that you will need to change the serial numbers used in the open() commands for each PhidgetLED to correspond to the particular hardware you are using for
' this example to function.
'
' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/


Public Class Form1
    'Our LED object that will be used to interface with a connected Phidget LED board
    Dim WithEvents phidgetLED1 As Phidgets.LED
    Dim WithEvents phidgetLED2 As Phidgets.LED
    Dim selectedLED As Phidgets.LED

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub


    'Create and initialize an LED object to control an attached LED.  Hook the event handlers to the object and open.

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        ledBoardCmb.Enabled = False
        ledIndexCmb.Enabled = False
        ledTrk.Enabled = False
        ledTrk.SetRange(0, 100)

        phidgetLED1 = New Phidgets.LED
        phidgetLED2 = New Phidgets.LED

        'To reduce code complexity we assume that there is one PhidgetInterfacekit
        'attached to the PC before the program is run.
        Try
            phidgetLED1.open(28539)
            phidgetLED2.open(46511)
        Catch ex As Exception
            MessageBox.Show(ex.ToString())
        End Try

    End Sub

    'LED Attach event handler...populate the information fields and initialize the index selector combo boxes according to the
    'number of available LEDs on the connected Phidget LED board.  Enable all the editable controls.
    Private Sub phidgetLED_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetLED1.Attach, phidgetLED2.Attach
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = sender.Name
        serialTxt.Text = sender.SerialNumber.ToString()
        versionTxt.Text = sender.Version.ToString()
        ledNumTxt.Text = sender.leds.Count.ToString()

        Dim i As Integer
        For i = 0 To sender.leds.Count - 1
            ledIndexCmb.Items.Add(i)
            sender.leds(i) = 0
        Next i

        If (sender.Equals(phidgetLED1)) Then
            ledBoardCmb.Items.Add(1)
        ElseIf (sender.Equals(phidgetLED2)) Then
            ledBoardCmb.Items.Add(2)
        End If

        ledBoardCmb.Enabled = True
        ledBoardCmb.SelectedIndex = 0
        ledIndexCmb.Enabled = True
        ledIndexCmb.SelectedIndex = 0
        ledTrk.Enabled = True
        ledTrk.Value = 0
    End Sub



    'LED Detach event handler...we'll clear all our fields and disable all the editable fields to prevent errors
    Private Sub phidgetLED_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetLED1.Detach, phidgetLED2.Detach
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = ""
        serialTxt.Text = ""
        versionTxt.Text = ""
        ledNumTxt.Text = ""

        ledBoardCmb.Enabled = False
        ledBoardCmb.Items.Clear()
        ledIndexCmb.Enabled = False
        ledIndexCmb.Items.Clear()
        ledTrk.Enabled = False
        ledTrk.Value = 0
    End Sub


    'Error event handler...We will just display the error message in a popup messagebox
    Private Sub phidgetLED_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetLED1.Error, phidgetLED2.Error
        MessageBox.Show(e.Description)
    End Sub

    Private Sub ledBoardCmb_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ledBoardCmb.SelectedIndexChanged
        If (ledBoardCmb.SelectedItem = 1) Then
            selectedLED = phidgetLED1
        ElseIf (ledBoardCmb.SelectedItem = 2) Then
            selectedLED = phidgetLED2
        End If
    End Sub

    'When we select an LED index, in this case for the left bank of leds, set the trackbar to the selected LED's current
    'brightness setting.  
    'A PhidgetException could be thrown when accessing the led collection from the phidget class if no LED phidget is connected, 
    'so we'llcatch it and deal with it accordingly
    Private Sub ledIndexCmb_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ledIndexCmb.SelectedIndexChanged
        Try
            ledTrk.Value = selectedLED.leds(ledIndexCmb.SelectedItem)
        Catch ex As Exception
            MessageBox.Show("No Phidget LED Connected!")
            ledIndexCmb.Enabled = False
            ledIndexCmb.Items.Clear()
            ledIndexCmb.SelectedIndex = 0
            ledTrk.Enabled = False
            ledTrk.Value = 0
        End Try

    End Sub

    'When we scroll the trackbar for a selected LED index, we want to set the LED to that value in the created object.
    'A PhidgetException may be thrown if there is no Phidget LED connected, so we'll catch it and deal with it
    'accordingly
    Private Sub ledTrk_Scroll(ByVal sender As Object, ByVal e As System.EventArgs) Handles ledTrk.Scroll
        Try
            selectedLED.leds(ledIndexCmb.SelectedItem) = ledTrk.Value

        Catch ex As Exception
            MessageBox.Show("No Phidget LED Connected!")
            ledIndexCmb.Enabled = False
            ledIndexCmb.Items.Clear()
            ledIndexCmb.SelectedIndex = 0
            ledTrk.Enabled = False
            ledTrk.Value = 0
        End Try

    End Sub

    'When the application is terminating, close the phidget
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        RemoveHandler phidgetLED1.Attach, AddressOf phidgetLED_Attach
        RemoveHandler phidgetLED1.Detach, AddressOf phidgetLED_Detach
        RemoveHandler phidgetLED1.Error, AddressOf phidgetLED_Error
        RemoveHandler phidgetLED2.Attach, AddressOf phidgetLED_Attach
        RemoveHandler phidgetLED2.Detach, AddressOf phidgetLED_Detach
        RemoveHandler phidgetLED2.Error, AddressOf phidgetLED_Error
        Application.DoEvents()

        phidgetLED1.close()
        phidgetLED2.close()
    End Sub

End Class
