' - IR full -
' This example displays a gui that shows the attached Phidgets IR reader device's details and will 
' display and tag data that is scanned by the antenna.  it also provides checkboxes to manipulate the 
' different attirbutes of the IR reader as well as the digital outputs.
'
' Copyright 2010 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Imports System.Text
Imports System.Threading

Public Class Form1
    Dim WithEvents phidgetIR As Phidgets.IR
    Dim repeatCount As Integer
    Dim buttonPressed As Boolean
    Dim lastLearnedCode As Phidgets.IRCode
    Dim lastLearnedCodeInfo As Phidgets.IRCodeInfo
    Dim rawDataCol As Integer


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        phidgetIR = New Phidgets.IR
        phidgetIR.open()

        attachedTxt.Text = "Not Connected"
    End Sub

    Private Sub phidgetIR_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetIR.Attach

        attachedTxt.Text = phidgetIR.Attached.ToString()
        nameTxt.Text = phidgetIR.Name
        serialTxt.Text = phidgetIR.SerialNumber.ToString()
        versionTxt.Text = phidgetIR.Version.ToString()

        codeTxt.Clear()
        repeatCountTextBox.Clear()
        bitLengthTextBox.Clear()

        Dim readRawDataThread As New Thread(New ThreadStart(AddressOf ReadRawDataThreadFunction))
        readRawDataThread.Start()

    End Sub

    Private Sub phidgetIR_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetIR.Detach

        attachedTxt.Text = phidgetIR.Attached.ToString()
        nameTxt.Text = ""
        serialTxt.Text = ""
        versionTxt.Text = ""

        retransmitButton.Enabled = False

    End Sub

    Private Sub phidgetIR_Code(ByVal sender As Object, ByVal e As Phidgets.Events.IRCodeEventArgs) Handles phidgetIR.Code

        codeTxt.Text = "0x" + e.Code.ToString()
        bitLengthTextBox.Text = e.Code.BitCount.ToString()

        repeatCount += 1
        If Not e.Repeat Then
            repeatCount = 0
        End If

        repeatCountTextBox.Text = repeatCount.ToString()

    End Sub

    Private Sub phidgetIR_Learn(ByVal sender As Object, ByVal e As Phidgets.Events.IRLearnEventArgs) Handles phidgetIR.Learn

        codeLearnTextBox.Text = "0x" + e.LearnedCode.Code.ToString()

        bitLengthLearnTextBox.Text = e.LearnedCode.CodeInfo.BitCount.ToString()
        lengthLearnTextBox.Text = e.LearnedCode.CodeInfo.Length.ToString() + " Length"
        encodingTextBox.Text = e.LearnedCode.CodeInfo.Encoding.ToString()
        gapTextBox.Text = e.LearnedCode.CodeInfo.Gap.ToString()

        If e.LearnedCode.CodeInfo.Trail <> 0 Then
            trailTextBox.Text = e.LearnedCode.CodeInfo.Trail.ToString()
        Else
            trailTextBox.Text = "None"
        End If

        oneTextBox.Text = e.LearnedCode.CodeInfo.One(0).ToString() + ", " + e.LearnedCode.CodeInfo.One(1).ToString()
        zeroTextBox.Text = e.LearnedCode.CodeInfo.Zero(0).ToString() + ", " + e.LearnedCode.CodeInfo.Zero(1).ToString()

        If Not e.LearnedCode.CodeInfo.Header Is Nothing Then
            Dim sb As New StringBuilder(e.LearnedCode.CodeInfo.Header.Length * 2)

            For Each i As Integer In e.LearnedCode.CodeInfo.Header
                sb.Append(i.ToString())
                sb.Append(", ")
            Next
            headerTextBox.Text = sb.ToString()
        Else
            headerTextBox.Text = "No Header"
        End If

        If Not e.LearnedCode.CodeInfo.ToggleMask Is Nothing Then
            toggleTextBox.Text = "0x" + e.LearnedCode.CodeInfo.ToggleMask.ToString()
        Else
            toggleTextBox.Text = "No Toggle Mask"
        End If

        If Not e.LearnedCode.CodeInfo.Repeat Is Nothing Then
            Dim sb As New StringBuilder(e.LearnedCode.CodeInfo.Repeat.Length * 2)

            For Each i As Integer In e.LearnedCode.CodeInfo.Repeat
                sb.Append(i.ToString())
                sb.Append(", ")
            Next
            repeatTextBox.Text = sb.ToString()
        Else
            repeatTextBox.Text = "No Repeat Code"
        End If

        lastLearnedCode = e.LearnedCode.Code
        lastLearnedCodeInfo = e.LearnedCode.CodeInfo
        retransmitButton.Enabled = True

    End Sub

    Private Sub ReadRawDataThreadFunction()
        While phidgetIR.Attached
            Try
                Dim buffer(1024) As Integer
                Dim size As Integer

                Thread.Sleep(100)
                size = phidgetIR.readRaw(buffer)
                If size > 0 Then
                    If pollRawDataRadio.Checked Then
                        printRawData(buffer, size)
                    End If
                End If
            Catch ex As Exception

            End Try
        End While
    End Sub

    Private Delegate Sub bufferDelegate(ByVal data() As Integer, ByVal length As Integer)
    Private Sub printRawData(ByVal data() As Integer, ByVal length As Integer)
        If rawDataBox.InvokeRequired Then
            Try
                rawDataBox.Invoke(New bufferDelegate(AddressOf printRawData), New Object() {data, length})
            Catch ex As Exception

            End Try
        Else

            If rawDataCheckBox.Checked Then
                Dim i As Integer
                For i = 0 To length - 1
                    If data(i) = Phidgets.IR.RAWDATA_LONGSPACE Then
                        rawDataBox.AppendText(Environment.NewLine + Environment.NewLine)
                        rawDataBox.AppendText("LONG")
                        rawDataBox.AppendText(Environment.NewLine)
                        rawDataBox.ScrollToCaret()
                        rawDataCol = -1
                    ElseIf data(i) > 100000 Then
                        rawDataBox.AppendText(Environment.NewLine + Environment.NewLine)
                        rawDataBox.AppendText(data(i).ToString().PadLeft(7) + ",")
                        rawDataBox.AppendText(Environment.NewLine)
                        rawDataBox.ScrollToCaret()
                        rawDataCol = -1
                    Else
                        rawDataBox.AppendText(data(i).ToString().PadLeft(7) + ",")
                    End If

                    rawDataCol += 1
                    If rawDataCol >= 10 Then
                        rawDataBox.AppendText(Environment.NewLine)
                        rawDataBox.ScrollToCaret()
                        rawDataCol = 0
                    End If
                Next
            End If
        End If
    End Sub

    Private Sub phidgetIR_RawData(ByVal sender As Object, ByVal e As Phidgets.Events.IRRawDataEventArgs) Handles phidgetIR.RawData
        If eventRawDataRadio.Checked Then
            printRawData(e.RawData, e.RawData.Length)
        End If
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        If phidgetIR.Attached = True Then
            RemoveHandler phidgetIR.Attach, AddressOf phidgetIR_Attach
            RemoveHandler phidgetIR.Detach, AddressOf phidgetIR_Detach
            RemoveHandler phidgetIR.Code, AddressOf phidgetIR_Code
            RemoveHandler phidgetIR.Learn, AddressOf phidgetIR_Learn
            RemoveHandler phidgetIR.RawData, AddressOf phidgetIR_RawData

            Application.DoEvents()

            phidgetIR.close()
        End If
    End Sub

    Private Sub retransmitThread()
        Thread.Sleep(100)
        Try
            phidgetIR.transmit(lastLearnedCode, lastLearnedCodeInfo)
            While buttonPressed
                phidgetIR.transmitRepeat()
            End While
        Catch ex As Exception

        End Try
    End Sub

    Private Sub retransmitButton_MouseDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles retransmitButton.MouseDown
        buttonPressed = True
        Dim buttonThread As New Thread(New ThreadStart(AddressOf retransmitThread))
        buttonThread.Start()
    End Sub

    Private Sub retransmitButton_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles retransmitButton.MouseUp
        buttonPressed = False
    End Sub

    Private Sub rawDataCheckBox_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles rawDataCheckBox.CheckedChanged
        If rawDataCheckBox.Checked Then
            rawDataBox.Visible = True
            clearButton.Visible = True
            eventRawDataRadio.Visible = True
            pollRawDataRadio.Visible = True
            Me.Size = New Size(900, Me.Size.Height)
        Else
            rawDataBox.Visible = False
            clearButton.Visible = False
            eventRawDataRadio.Visible = False
            pollRawDataRadio.Visible = False
            Me.Size = New Size(300, Me.Size.Height)
        End If
    End Sub

    Private Sub clearButton_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles clearButton.Click
        rawDataBox.Clear()
    End Sub

    Private Sub button1_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles button1.Click

        Dim data() As Integer = {9040, 4590, 540, 630, 550, 1740, 550, 1750, 550, 1740, 550, 620, 550, 1750, 550, 1740, 550, 1750, 550, 1740, 550, 1740, 560, 1740, 540, 630, 550, 620, 550, 620, 540, 630, 550, 1750, 550, 1740, 560, 1740, 550, 620, 550, 1740, 550, 620, 550, 620, 560, 610, 550, 620, 550, 1750, 550, 1740, 550, 620, 550, 1740, 550, 1750, 550, 620, 550, 620, 550, 620, 540}
        phidgetIR.transmitRaw(data, 37850)
    End Sub

    Private Sub eventRawDataRadio_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles eventRawDataRadio.CheckedChanged
        If eventRawDataRadio.Checked Then
            pollRawDataRadio.Checked = False
        End If
    End Sub

    Private Sub pollRawDataRadio_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles pollRawDataRadio.CheckedChanged
        If pollRawDataRadio.Checked Then
            eventRawDataRadio.Checked = False
        End If
    End Sub
End Class
