' - GPS full - 
' This example displays the connected Phidget GPS device's details as well as the current 
' position, velocity, heading. There is also a map view that shows the current location on a map.
' 
' Please note that this example was designed to work with only one Phidget GPS connected. 
' For an example showing how to use two Phidgets of the same time concurrently, please see the
' Servo-multi example in the Servo Examples.
'
' Copyright 2011 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
'/
Option Strict On
Option Explicit On

Public Class Form1

    Dim WithEvents GPS As Phidgets.GPS

    Private mapGraphic As Graphics

    Public Sub New()

        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        GroupBox2.Visible = False
        GroupBox3.Visible = False

        Me.Size = New Size(341, 255)
        Try
            GPS = New Phidgets.GPS
            GPS.open()
            attachedTxt.Text = GPS.Attached.ToString

        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.ToString())
        End Try

        Try
            GMapControl1.CurrentPosition = New GMap.NET.PointLatLng(0, 0)
        Catch ex As Exception
        End Try
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If (GPS.Attached) Then
            RemoveHandler GPS.Attach, AddressOf GPS_Attach
            RemoveHandler GPS.Detach, AddressOf GPS_Detach
            RemoveHandler GPS.Error, AddressOf GPS_Error
            RemoveHandler GPS.PositionFixStatusChange, AddressOf GPS_PositionFixStatusChange
            RemoveHandler GPS.PositionChange, AddressOf GPS_PositionChange

            Application.DoEvents()
            GPS.close()
            GPS = Nothing

        End If
    End Sub

    Private Sub GPS_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles GPS.Attach
        Me.Size = New Size(866, 555)

        DisplayGPSInfo()
        InitializeGPSData()
    End Sub

    Private Sub GPS_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles GPS.Detach
        Me.Size = New Size(341, 255)
        GroupBox2.Visible = False
        GroupBox3.Visible = False
        attachedTxt.Text = "False"
        nameTxt.Clear()
        serialTxt.Clear()
        versionTxt.Clear()
        timer1.Stop()
        fixChk.Checked = False
        latTxt.Clear()
        lonTxt.Clear()
        altTxt.Clear()
        heaTxt.Clear()
        velTxt.Clear()
        timTxt.Clear()
        datTxt.Clear()
        Try
            GMapControl1.CurrentPosition = New GMap.NET.PointLatLng(0, 0)
        Catch ex As Exception
        End Try
    End Sub

    Private Sub GPS_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles GPS.Error
        MessageBox.Show(e.Description)

    End Sub

    Private Sub DisplayGPSInfo()
        attachedTxt.Text = GPS.Attached.ToString()
        nameTxt.Text = GPS.Name
        serialTxt.Text = GPS.SerialNumber.ToString()
        versionTxt.Text = GPS.Version.ToString()
    End Sub

    Private Sub InitializeGPSData()
        GroupBox2.Visible = True
        GroupBox3.Visible = True
        latTxt.Text = "Unknown"
        lonTxt.Text = "Unknown"
        altTxt.Text = "Unknown"
        heaTxt.Text = "Unknown"
        velTxt.Text = "Unknown"
        timTxt.Text = "Unknown"
        datTxt.Text = "Unknown"
        timer1.Start()
    End Sub

    Private Sub GPS_PositionChange(ByVal sender As Object, ByVal e As Phidgets.Events.GPSPositionChangeEventArgs) Handles GPS.PositionChange
        latTxt.Text = e.Latitude.ToString("F6") + " " + Chr(176)
        lonTxt.Text = e.Longitude.ToString("F6") + " " + Chr(176)
        altTxt.Text = e.Altitude.ToString("F1") + " m"

        Try
            heaTxt.Text = GPS.Heading.ToString("F1") + " " + Chr(176)
            velTxt.Text = GPS.Velocity.ToString("F1") + " km/h"
        Catch ex As Phidgets.PhidgetException
            heaTxt.Text = "Unknown"
            velTxt.Text = "Unknown"
        End Try

        Try
            If (fixChk.Checked) Then
                GMapControl1.CurrentPosition = New GMap.NET.PointLatLng(e.Latitude, e.Longitude)
            Else
            End If
        Catch ex As Exception

        End Try

    End Sub

    Private Sub GPS_PositionFixStatusChange(ByVal sender As Object, ByVal e As Phidgets.Events.GPSPositionFixStatusChangeEventArgs) Handles GPS.PositionFixStatusChange
        fixChk.Checked = e.PositionFixStatus
        If (Not e.PositionFixStatus) Then
            latTxt.Text = "Unknown"
            lonTxt.Text = "Unknown"
            altTxt.Text = "Unknown"
            heaTxt.Text = "Unknown"
            velTxt.Text = "Unknown"
        End If
    End Sub

    Private Sub timer1_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles timer1.Tick
        If (GPS.Attached) Then
            Dim localTime As Date
            Try
                localTime = GPS.GPSDateAndTime.ToLocalTime()
                timTxt.Text = localTime.Hour.ToString("D2") + ":" + localTime.Minute.ToString("D2") + ":" + localTime.Second.ToString("D2") + "." + localTime.Millisecond.ToString("D3")
                datTxt.Text = localTime.Day.ToString() + "/" + localTime.Month.ToString() + "/" + localTime.Year.ToString()

            Catch ex As Phidgets.PhidgetException

            End Try
        End If
    End Sub

End Class