' - FrequencyCounter full -
' In this example we display the frequency counter details.
'
' Please note that this example was designed to work with only one Phidget Frequency Counter connected. 
' Using two Phidgets at the same time concurrently would require separate Phidget objects.
'
' Copyright 2011 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Option Strict On
Option Explicit On

Public Class Form1

    Dim WithEvents FrequencyCounter As Phidgets.FrequencyCounter

    Public Sub New()
       
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        InitForm()

        Try
            FrequencyCounter = New Phidgets.FrequencyCounter
            FrequencyCounter.open()
            attachedTxt.Text = FrequencyCounter.Attached.ToString

        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.ToString())
        End Try

    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If (FrequencyCounter.Attached) Then
            RemoveHandler FrequencyCounter.Attach, AddressOf FrequencyCounter_Attach
            RemoveHandler FrequencyCounter.Detach, AddressOf FrequencyCounter_Detach
            RemoveHandler FrequencyCounter.Error, AddressOf FrequencyCounter_Error
            RemoveHandler FrequencyCounter.Count, AddressOf FrequencyCounter_Count

            Application.DoEvents()
            FrequencyCounter.close()
            FrequencyCounter = Nothing
        End If
    End Sub

    Private Sub FrequencyCounter_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles FrequencyCounter.Attach

        Me.Size = New Size(Me.Size.Width, 545)

        DisplayFrequencyCounterInfo()
        DisplayFrequencyData()

    End Sub

    Private Sub FrequencyCounter_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles FrequencyCounter.Detach
        InitForm()
    End Sub

    Private Sub FrequencyCounter_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles FrequencyCounter.Error
        MessageBox.Show(e.Description)
    End Sub

    Private Sub FrequencyCounter_Count(ByVal sender As Object, ByVal e As Phidgets.Events.FrequencyCounterCountEventArgs) Handles FrequencyCounter.Count
        If (e.Index = channelCmb.SelectedIndex And enableChk.Checked) Then
            Try
                frequencyTxt.Text = FrequencyCounter.inputs(e.Index).Frequency.ToString("F4")
            Catch ex As Phidgets.PhidgetException

            End Try

            timeTxt.Text = (e.Time / 1000.0).ToString("F2")
            countTxt.Text = e.Counts.ToString

            totalTimeTxt.Text = (FrequencyCounter.inputs(channelCmb.SelectedIndex).TotalTime / 1000.0).ToString("F2")
            totalCountTxt.Text = FrequencyCounter.inputs(channelCmb.SelectedIndex).TotalCount.ToString

        End If
    End Sub

    'initializes the form to the default setting
    Private Sub InitForm()
        attachedTxt.Text = "False"
        nameTxt.Clear()
        serialTxt.Clear()
        versionTxt.Clear()
        channelNumTxt.Clear()

        GroupBox2.Visible = False
        timeoutTxt.Clear()
        timeoutTxt.Enabled = False
        setTimeoutBtn.Enabled = False
        countTxt.Clear()
        countTxt.Enabled = False
        timeTxt.Clear()
        timeTxt.Enabled = False
        frequencyTxt.Clear()
        frequencyTxt.Enabled = False
        totalCountTxt.Clear()
        totalCountTxt.Enabled = False
        totalTimeTxt.Clear()
        totalTimeTxt.Enabled = False
        resetBtn.Enabled = False
        channelCmb.Items.Clear()
        channelCmb.Enabled = False
        enableChk.Checked = False
        enableChk.Enabled = False
        filterCmb.Items.Clear()
        filterCmb.Enabled = False

        Me.Size = New Size(Me.Size.Width, 292)

    End Sub

    Private Sub DisplayFrequencyCounterInfo()
        attachedTxt.Text = FrequencyCounter.Attached.ToString()
        nameTxt.Text = FrequencyCounter.Name
        serialTxt.Text = FrequencyCounter.SerialNumber.ToString()
        versionTxt.Text = FrequencyCounter.Version.ToString()
        channelNumTxt.Text = FrequencyCounter.inputs.Count.ToString()
    End Sub

    Private Sub DisplayFrequencyData()

        Dim I As Integer

        GroupBox2.Visible = True

        channelCmb.Enabled = True
        For I = 0 To FrequencyCounter.inputs.Count - 1
            channelCmb.Items.Add(I.ToString)
        Next I
        channelCmb.SelectedIndex = 0

        enableChk.Enabled = True

        Dim filterType As String

        For Each filterType In [Enum].GetNames(GetType(Phidgets.FrequencyCounterInput.FilterType))
            If filterType = Phidgets.FrequencyCounterInput.FilterType.INVALID.ToString Then Exit For
            filterCmb.Items.Add(filterType.ToString)
        Next
        filterCmb.SelectedItem = "ZERO_CROSSING"

    End Sub

    Private Sub channelCmb_SelectionChangeCommitted(ByVal sender As Object, ByVal e As System.EventArgs) Handles channelCmb.SelectionChangeCommitted
        enableChk.Checked = FrequencyCounter.inputs(channelCmb.SelectedIndex).Enabled
        enableChanged(enableChk.Checked)
    End Sub


    Private Sub filterCmb_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles filterCmb.SelectedIndexChanged
        FrequencyCounter.inputs(channelCmb.SelectedIndex).Filter = DirectCast([Enum].Parse(GetType(Phidgets.FrequencyCounterInput.FilterType), filterCmb.SelectedItem.ToString), Phidgets.FrequencyCounterInput.FilterType)
    End Sub

    Private Sub setTimeoutBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles setTimeoutBtn.Click
        Try
            FrequencyCounter.inputs(channelCmb.SelectedIndex).Timeout = Convert.ToInt32(timeoutTxt.Text) * 1000
        Catch ex As Exception
            MessageBox.Show("Please set a value between 100-100000 milliseconds", "Timeout Invalid")
        End Try
    End Sub

    Private Sub enableChk_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles enableChk.CheckedChanged
        If FrequencyCounter.Attached Then
            FrequencyCounter.inputs(channelCmb.SelectedIndex).Enabled = enableChk.Checked
            enableChanged(enableChk.Checked)
        Else 'Phidget is not attached
            enableChanged(False)
        End If
    End Sub

    Private Sub enableChanged(ByVal state As Boolean)
        'initialize data
        filterCmb.Enabled = False
        timeoutTxt.Clear()
        timeoutTxt.Enabled = False
        setTimeoutBtn.Enabled = False
        countTxt.Clear()
        countTxt.Enabled = False
        timeTxt.Clear()
        timeTxt.Enabled = False
        frequencyTxt.Clear()
        frequencyTxt.Enabled = False
        totalCountTxt.Clear()
        totalCountTxt.Enabled = False
        totalTimeTxt.Clear()
        totalTimeTxt.Enabled = False
        resetBtn.Enabled = False

        'Display frequency data only if the channel is selected and the enabled state is true 
        If state Then
            filterCmb.Enabled = True
            filterCmb.SelectedItem = FrequencyCounter.inputs(channelCmb.SelectedIndex).Filter.ToString
            timeoutTxt.Enabled = True
            setTimeoutBtn.Enabled = True
            countTxt.Enabled = True
            timeTxt.Enabled = True
            frequencyTxt.Enabled = True
            totalCountTxt.Enabled = True
            totalTimeTxt.Enabled = True
            timeoutTxt.Text = (FrequencyCounter.inputs(channelCmb.SelectedIndex).Timeout / 1000.0).ToString
            totalCountTxt.Text = (FrequencyCounter.inputs(channelCmb.SelectedIndex).TotalCount).ToString
            totalTimeTxt.Text = (FrequencyCounter.inputs(channelCmb.SelectedIndex).TotalTime / 1000).ToString("F2")
            resetBtn.Enabled = True
            countTxt.Text = "0"
            timeTxt.Text = "0"

            Try
                frequencyTxt.Text = FrequencyCounter.inputs(channelCmb.SelectedIndex).Frequency.ToString("F4")
            Catch ex As Phidgets.PhidgetException
                frequencyTxt.Text = "Unknown"

            End Try
        End If
    End Sub

    Private Sub resetBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles resetBtn.Click
        FrequencyCounter.inputs(channelCmb.SelectedIndex).reset()
        totalCountTxt.Text = (FrequencyCounter.inputs(channelCmb.SelectedIndex).TotalCount).ToString
        totalTimeTxt.Text = (FrequencyCounter.inputs(channelCmb.SelectedIndex).TotalTime).ToString
    End Sub

End Class