' - Bridge full -
' In this example we display the bridge details.
'
' Please note that this example was designed to work with only one Phidget Bridge connected. 
' Using two Phidgets at the same time concurrently would require separate Phidget objects.
'
' Copyright 2011 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Option Strict On
Option Explicit On

Public Class Form1

    Dim WithEvents Bridge As Phidgets.Bridge

    Public Sub New()

        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        InitForm()

        Try
            Bridge = New Phidgets.Bridge
            Bridge.open()
            attachedTxt.Text = Bridge.Attached.ToString

        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.ToString())
        End Try

    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If (Bridge.Attached) Then
            RemoveHandler Bridge.Attach, AddressOf Bridge_Attach
            RemoveHandler Bridge.Detach, AddressOf Bridge_Detach
            RemoveHandler Bridge.Error, AddressOf Bridge_Error
            RemoveHandler Bridge.BridgeData, AddressOf Bridge_BridgeData

            Application.DoEvents()
            Bridge.close()
            Bridge = Nothing
        End If
    End Sub

    'initializes the form to the default setting
    Private Sub InitForm()
        attachedTxt.Text = "False"
        nameTxt.Clear()
        serialTxt.Clear()
        versionTxt.Clear()
        bridgeNumTxt.Clear()

        GroupBox2.Visible = False
        bridgeValueTxt.Clear()
        bridgeValueTxt.Enabled = False
        ' calibrationBtn.Enabled = False
   
        bridgeCmb.Items.Clear()
        bridgeCmb.Enabled = False
        enableChk.Checked = False
        enableChk.Enabled = False
        gainCmb.Items.Clear()
        gainCmb.Enabled = False

        dataRateTrk.Enabled = False
        dataRateTrk.Minimum = 0
        dataRateTrk.Maximum = 125
        dataRateTxt.Clear()
        dataRateTxt.Enabled = False

        convertedValueTxt.Clear()
        convertedValueTxt.Enabled = False
        calibrateBtn.Enabled = False
        value1Txt.ReadOnly = True
        value2Txt.ReadOnly = True
        set1Btn.Enabled = False
        set2Btn.Enabled = False
        convertedValueTxt.Clear()
        convertedValueTxt.Enabled = False

        Me.Size = New Size(Me.Size.Width, 292)

    End Sub

    Private Sub Bridge_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles Bridge.Attach
        Me.Size = New Size(Me.Size.Width, 686)
        DisplayBridgeInfo()
        DisplayBridgeData()
    End Sub

    Private Sub Bridge_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles Bridge.Detach
        InitForm()
    End Sub

    Private Sub Bridge_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles Bridge.Error
        MessageBox.Show(e.Description)
    End Sub

    Private Sub Bridge_BridgeData(ByVal sender As Object, ByVal e As Phidgets.Events.BridgeDataEventArgs) Handles Bridge.BridgeData
        If (e.Index = bridgeCmb.SelectedIndex And enableChk.Checked) Then
            Try
                bridgeValueTxt.Text = e.Value.ToString
            Catch ex As Phidgets.PhidgetException
            End Try

            convertedValueTxt.Text = Math.Round((slope * e.Value) + yInt, 2).ToString
        End If
    End Sub

    Private Sub DisplayBridgeInfo()
        attachedTxt.Text = Bridge.Attached.ToString()
        nameTxt.Text = Bridge.Name
        serialTxt.Text = Bridge.SerialNumber.ToString()
        versionTxt.Text = Bridge.Version.ToString()
        bridgeNumTxt.Text = Bridge.bridges.Count.ToString()
    End Sub

    Private Sub DisplayBridgeData()

        Dim I, newDataRate As Integer

        GroupBox2.Visible = True

        bridgeCmb.Enabled = True
        For I = 0 To Bridge.bridges.Count - 1
            bridgeCmb.Items.Add(I.ToString)
        Next I
        bridgeCmb.SelectedIndex = 0

        enableChk.Enabled = True

        Dim gainType As String
        For Each gainType In [Enum].GetNames(GetType(Phidgets.BridgeInput.Gains))
            If gainType = Phidgets.BridgeInput.Gains.UNKNOWN.ToString Then Exit For
            gainCmb.Items.Add(gainType.ToString)
        Next
        gainCmb.SelectedItem = "GAIN_1"

        dataRateTrk.Minimum = CType(Bridge.DataRateMax / 8, Integer)
        dataRateTrk.Maximum = CType((Bridge.DataRateMin / 8), Integer)

        newDataRate = 10
        dataRateTrk.Value = newDataRate

    End Sub

    Private Sub bridgeCmb_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bridgeCmb.SelectedIndexChanged
        If Bridge.Attached Then
            enableChk.Checked = Bridge.bridges(bridgeCmb.SelectedIndex).Enabled
            enableChanged(enableChk.Checked)
        End If
    End Sub

    Private Sub gainCmb_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles gainCmb.SelectedIndexChanged
        Bridge.bridges(bridgeCmb.SelectedIndex).Gain = DirectCast([Enum].Parse(GetType(Phidgets.BridgeInput.Gains), gainCmb.SelectedItem.ToString), Phidgets.BridgeInput.Gains)
    End Sub

    Private Sub enableChk_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles enableChk.CheckedChanged
        If Bridge.Attached Then
            Bridge.bridges(bridgeCmb.SelectedIndex).Enabled = enableChk.Checked
            enableChanged(enableChk.Checked)
        Else 'Phidget is not attached
            enableChanged(False)
        End If
    End Sub

    Private Sub enableChanged(ByVal state As Boolean)
        'initialize data
        gainCmb.Enabled = False
        bridgeValueTxt.Clear()
        bridgeValueTxt.Enabled = False

        dataRateTrk.Enabled = False
        dataRateTxt.Clear()
        dataRateTxt.Enabled = False

        calibrateBtn.Enabled = False
        convertedValueTxt.Clear()
        convertedValueTxt.Enabled = False

        'Display bridge data only if the bridge is selected and the enabled state is true 
        If state Then
            gainCmb.Enabled = True
            gainCmb.SelectedItem = Bridge.bridges(bridgeCmb.SelectedIndex).Gain.ToString
            bridgeValueTxt.Enabled = True
            dataRateTrk.Enabled = True

            dataRateTrk.Value = CType(Bridge.DataRate / 8, Integer)
            dataRateTxt.Text = (Bridge.DataRate).ToString

            dataRateTxt.Enabled = True
            calibrateBtn.Enabled = True
            convertedValueTxt.Enabled = True

            Try
                bridgeValueTxt.Text = Bridge.bridges(bridgeCmb.SelectedIndex).Gain.ToString
            Catch ex As Phidgets.PhidgetException
                If ex.Type = Phidgets.PhidgetException.ErrorType.PHIDGET_ERR_UNKNOWNVAL Then
                    bridgeValueTxt.Text = "Unknown"
                    MessageBox.Show("i actuall happen")
                End If

            End Try
        End If
    End Sub

    Private Sub dataRateTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles dataRateTrk.Scroll
        Try
            Bridge.DataRate = dataRateTrk.Value * 8
            dataRateTxt.Text = (dataRateTrk.Value * 8).ToString
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show("Please ensure that the value is a multiple of 8 and between " + Bridge.DataRateMax.ToString + "-" + Bridge.DataRateMin.ToString, "Data Rate Invalid")
        End Try
    End Sub

    Dim value1, value2, value1Coor, value2Coor, slope, yInt As Double

    Private Sub calibrateBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles calibrateBtn.Click
        value1Txt.ReadOnly = False
        set1Btn.Enabled = True
        set2Btn.Enabled = True
        value2Txt.ReadOnly = True
    End Sub

    Private Sub set1Btn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles set1Btn.Click
        Try
            value1 = CType(bridgeValueTxt.Text.ToString, Double)
            value1Coor = CType(value1Txt.Text.ToString, Double)

            value2Txt.ReadOnly = False
            value1Txt.ReadOnly = True
            set1Btn.Enabled = False
            set2Btn.Enabled = True
        Catch ex As Exception
            MessageBox.Show("Please enter a valid Number", "Invalid Number")
        End Try
    End Sub

    Private Sub set2Btn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles set2Btn.Click
        Try

          value2 = CType(bridgeValueTxt.Text, Double)
            value2Coor = CType(value2Txt.Text, Double)

            'Calculate formula
            slope = (value2Coor - value1Coor) / (value2 - value1)
            yInt = value1Coor - (value1 * slope)
            formulaTxt.Text = "y = " + slope.ToString("F4") + "x + " + yInt.ToString("F4")

            value2Txt.ReadOnly = True
            set2Btn.Enabled = False
        Catch ex As Exception
            MessageBox.Show("Please enter a valid Number", "Invalid Number")
        End Try
    End Sub
End Class



