' - Analog full -
' In this example we display the phidget analog details, including the number of outputs it allows,
' and controls for the outputs.
'
' Please note that this example was designed to work with only one Phidget Analog connected. 
' Using two Phidgets at the same time concurrently would require separate Phidget objects.
'
' Copyright 2011 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Option Strict On
Option Explicit On

Public Class Form1

    Dim WithEvents Analog As Phidgets.Analog

    Public channelNumLabelArray() As Label = {}
    Public voltageTxtArray() As TextBox = {}
    Public enableChkArray() As CheckBox = {}
    Public voltageSldArray() As TrackBar = {}

    Public Sub New()

        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        GroupBox2.Visible = False

        Me.Size = New Size(Me.Size.Width, 300)
        Try
            Analog = New Phidgets.Analog
            Analog.open()
            attachedTxt.Text = Analog.Attached.ToString

        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.ToString())
        End Try
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If (Analog.Attached) Then
            RemoveHandler Analog.Attach, AddressOf Analog_Attach
            RemoveHandler Analog.Detach, AddressOf Analog_Detach
            RemoveHandler Analog.Error, AddressOf Analog_Error

            Application.DoEvents()
            Analog.close()
            Analog = Nothing

        End If
    End Sub

    Private Sub Analog_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles Analog.Attach

        Me.Size = New Size(Me.Size.Width, 555)

        DisplayAnalogInfo()
        DisplayChannelOutput()

    End Sub

    Private Sub Analog_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles Analog.Detach
        Dim i As Integer

        Me.Size = New Size(Me.Size.Width, 300)

        attachedTxt.Text = "False"
        nameTxt.Clear()
        serialTxt.Clear()
        versionTxt.Clear()
        channelNumTxt.Clear()

        GroupBox2.Visible = False

        For i = 0 To channelNumLabelArray.Length - 1
            GroupBox2.Controls.Remove(channelNumLabelArray(i))
        Next i

        For i = 0 To enableChkArray.Length - 1
            GroupBox2.Controls.Remove(enableChkArray(i))
        Next i

        For i = 0 To voltageSldArray.Length - 1
            GroupBox2.Controls.Remove(voltageSldArray(i))
        Next i

        For i = 0 To voltageTxtArray.Length - 1
            GroupBox2.Controls.Remove(voltageTxtArray(i))
        Next i

    End Sub

    Private Sub Analog_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles Analog.Error
        MessageBox.Show(e.Description)
    End Sub

    Private Sub DisplayAnalogInfo()
        attachedTxt.Text = Analog.Attached.ToString()
        nameTxt.Text = Analog.Name
        serialTxt.Text = Analog.SerialNumber.ToString()
        versionTxt.Text = Analog.Version.ToString()
        channelNumTxt.Text = Analog.outputs.Count.ToString()
    End Sub

    Private Sub DisplayChannelOutput()
        Dim I As Integer

        GroupBox2.Visible = True

        'Dynamically creates controls according to the number of analog output counts
        For I = 0 To Analog.outputs.Count - 1

            ReDim Preserve channelNumLabelArray(I)
            channelNumLabelArray(I) = New Label
            GroupBox2.Controls.Add(channelNumLabelArray(I))
            With channelNumLabelArray(I)
                .Enabled = True
                .Visible = True
                .Name = "channelNum" & I.ToString()
                .Text = "Channel " & I
                .SetBounds(21, 33 + I * 50, 60, 13)
                .Tag = I
            End With

            ReDim Preserve voltageTxtArray(I)
            voltageTxtArray(I) = New TextBox
            GroupBox2.Controls.Add(voltageTxtArray(I))
            With voltageTxtArray(I)
                .Enabled = True
                .Visible = True
                .Name = "voltageTxt" & I.ToString()
                .SetBounds(178, 55 + I * 50, 60, 13)
                .Tag = I
                .BackColor = Color.FromKnownColor(KnownColor.Control)
                .Text = Analog.outputs(I).Voltage.ToString
            End With

            ReDim Preserve enableChkArray(I)
            enableChkArray(I) = New CheckBox
            GroupBox2.Controls.Add(enableChkArray(I))
            With enableChkArray(I)
                .Enabled = True
                .Visible = True
                .Name = "enableChk" & I.ToString()
                .SetBounds(265, 55 + I * 50, 15, 15)
                .Tag = I
                .Checked = Analog.outputs(I).Enabled
                'Attaching the click handler 
                AddHandler enableChkArray(I).Click, AddressOf enableChkClick
            End With

            ReDim Preserve voltageSldArray(I)
            voltageSldArray(I) = New TrackBar
            GroupBox2.Controls.Add(voltageSldArray(I))
            With voltageSldArray(I)
                .Enabled = True
                .Visible = True
                .Name = "voltageSld" & I.ToString()
                .SetBounds(21, 55 + I * 50, 152, 30)
                .Tag = I
                .AutoSize = False
                .TickStyle = TickStyle.None
                .SetRange(CType(Analog.outputs(I).VoltageMin * 100, Integer), CType(Analog.outputs(I).VoltageMax * 100, Integer))
                .Value = CType(Analog.outputs(I).Voltage * 100, Integer)
                'Attaching the value changed handler
                AddHandler voltageSldArray(I).ValueChanged, AddressOf voltageSldValueChanged
            End With
        Next I
    End Sub

    'Value changeevent for the voltage slider. Sets the voltage and updates the voltageTxt
    Private Sub voltageSldValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim sld As TrackBar = DirectCast(sender, TrackBar)
        If (Analog.Attached) Then
            Analog.outputs(CType(sld.Tag, Integer)).Voltage = sld.Value / 100
        End If
        voltageTxtArray(CType(sld.Tag, Integer)).Text = (sld.Value / 100).ToString
    End Sub

    'Click event for the enable state checkbox. Sets the new enable state
    Private Sub enableChkClick(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim chk As CheckBox = DirectCast(sender, CheckBox)
        If (Analog.Attached) Then
            Analog.outputs(CType(chk.Tag, Integer)).Enabled = chk.Checked
        End If
    End Sub

End Class
