' - Servo full -
' This example simply displays the PhidgetServo information when it is attached and displays the servo positions with a slider
' for position manipulation
'
' Please note that this example was designed to work with only one Phidget Servo connected. 
' For an example using multiple Phidget Servos, please see a "multiple" example in the Servos Examples folder.
'
' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1

    Dim WithEvents phidgetServo As Phidgets.Servo
    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    'Initialization code
    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        phidgetServo = New Phidgets.Servo
        servoNumCombo.Enabled = False

        phidgetServo.open()
    End Sub

    'PhidgetServo attach event handling code
    Private Sub servo_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetServo.Attach

        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = sender.Name
        serialTxt.Text = sender.servos(0).PositionMin.ToString()

        'serialTxt.Text = sender.SerialNumber.ToString()
        versionTxt.Text = sender.Version.ToString()
        servosTxt.Text = sender.servos.Count.ToString()
        servoNumCombo.Enabled = True

        Dim i As Integer
        For i = 0 To sender.servos.Count - 1
            servoNumCombo.Items.Add(i)
            phidgetServo.servos(i).Position = 90

        Next i

        servoNumCombo.SelectedIndex = 0

        'Use a try-catch block around code where you are getting and displaying the servo position data
        'if the current position state has yet to be set, it will throw a PhidgetException for value not set
        'you can use this to test this and to display that the value is unknown
        Try
            positionTxt.Text = sender.servos(0).Position.ToString()
        Catch ex As Phidgets.PhidgetException
            positionTxt.Text = "Unknown"
        End Try
    End Sub

    'PhidgetServo detach event handling code
    Private Sub servo_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetServo.Detach
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = ""
        serialTxt.Text = ""
        versionTxt.Text = ""
        servosTxt.Text = ""
        servoNumCombo.Enabled = False
        servoNumCombo.Items.Clear()
        positionTxt.Text = ""
        positionTrk.Value = 0
    End Sub

    Private Sub servo_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetServo.Error
        MessageBox.Show(e.Description)
    End Sub

    'Servo position change event handling code
    Private Sub servo_PositionChange(ByVal sender As Object, ByVal e As Phidgets.Events.PositionChangeEventArgs) Handles phidgetServo.PositionChange
        Try
            positionTxt.Text = sender.servos(e.Index).Position.ToString()
        Catch ex As Phidgets.PhidgetException
            positionTxt.Text = "Unknown"
        End Try
    End Sub

    'Modify the servo position based on the value returned by the slider
    Private Sub positionTrk_Scroll(ByVal sender As Object, ByVal e As System.EventArgs) Handles positionTrk.Scroll
        Dim index As Integer
        index = servoNumCombo.SelectedIndex

        'A PhidgetException will be thrown if you try to set the position to any value NOT between -23 and 232
        Try

            phidgetServo.servos(index).Position = positionTrk.Value
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(positionTrk.Value.ToString())
            MessageBox.Show("position value out of bounds!")
        End Try

    End Sub

    'If using a 4-motor Phidget Servo, this code wi switch between the selected servos and display their position data
    Private Sub servoNumCombo_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles servoNumCombo.SelectedIndexChanged
        Dim index As Integer

        index = servoNumCombo.SelectedIndex
        positionTrk.SetRange(phidgetServo.servos(index).PositionMin + 1, phidgetServo.servos(index).PositionMax) 'the maximum bound of the phidget servo is 232, it's minimum bound is -23


        'Use a try-catch block around code where you are getting and displaying the servo position data
        'if the current position state has yet to be set, it will throw a PhidgetException for value not set
        'you can use this to test this and to display that the value is unknown
        Try
            positionTxt.Text = phidgetServo.servos(index).Position.ToString()
            positionTrk.Value = phidgetServo.servos(index).Position
        Catch ex As Phidgets.PhidgetException
            positionTxt.Text = "Unknown"
        End Try

    End Sub

    'When the application is terminating, close the Phidget.
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        RemoveHandler phidgetServo.Attach, AddressOf servo_Attach
        RemoveHandler phidgetServo.Detach, AddressOf servo_Detach
        RemoveHandler phidgetServo.Error, AddressOf servo_Error
        RemoveHandler phidgetServo.PositionChange, AddressOf servo_PositionChange
        Application.DoEvents()
        phidgetServo.close()
    End Sub

End Class
