' - PHSensor full -
' This example displays the connected Phidget PHSensor device's details as well as the current sensor readings
' being generated.  This example also demonstrates the ability to modify the sensor's sensitivity
' by setting it to a new double value in the provided textbox.
' 
' Please note that this example was designed to work with only one Phidget PHSensor connected. For an example using multiple 
' Phidget PHSensors, please see a "multiple" example in the PHSensor Examples folder.
'
' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1
    'Our LED object that will be used to interface with a connected Phidget LED board
    Dim WithEvents phidgetPH As Phidgets.PHSensor

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    'Initialize our PHSensor object and hook the event handlers
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'To reduce code complexity we assume that there is one PhidgetPHSensor
        'attached to the PC before the program is run.
        Try
            phidgetPH = New Phidgets.PHSensor
            phidgetPH.open()
        Catch ex As Exception
            MessageBox.Show(ex.ToString())
        End Try

    End Sub

    'PHSensor Attach event handler...We'll populate the fields in the GUI and enable the modify sensitivity textbox
    Private Sub phidgetPH_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetPH.Attach
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = sender.Name
        serialTxt.Text = sender.SerialNumber.ToString()
        versionTxt.Text = sender.Version.ToString()
        Try
            phTxt.Text = sender.sensor.PH.ToString()
        Catch ex As Exception
            phTxt.Text = "Unknown"
        End Try
        Try
            potentialTxt.Text = sender.sensor.Potential.ToString()
        Catch ex As Exception
            potentialTxt.Text = "Unknown"
        End Try
        Try
            sensitivityTxt.Text = sender.sensor.Sensitivity.ToString()
        Catch ex As Exception
            sensitivityTxt.Text = "Unknown"
        End Try
        sensitivityTxt.Enabled = True
    End Sub

    'PHSensor Detach event handler....Clear the fields and disable the modify sensitivity textbox so that
    'new sensity value can't be sent while there is no device attached, otherwise this would generate a PhidgetException
    Private Sub phidgetPH_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetPH.Detach
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = ""
        serialTxt.Text = ""
        versionTxt.Text = ""

        phTxt.Text = ""
        potentialTxt.Text = ""
        sensitivityTxt.Text = ""
        sensitivityTxt.Enabled = False

    End Sub

    'Error event handler...We will just display the error message in a popup messagebox
    Private Sub phidgetPH_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetPH.Error
        MessageBox.Show(e.Description)
    End Sub

    'PH Change event handler...We'll display the current PH reading from the sensor to the
    'specified textbox as they come in
    Private Sub phidgetPH_PHChange(ByVal sender As Object, ByVal e As Phidgets.Events.PHChangeEventArgs) Handles phidgetPH.PHChange
        Try
            phTxt.Text = e.PH.ToString()
            potentialTxt.Text = sender.sensor.Potential.ToString()
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.Description)
        End Try
    End Sub

    'When a new double value is entered into the textbox, we will update the sensitivity value in the sensor
    'If no PH sensor is attached when we try to update the sensitivity value, it will throw a PhidgetException,
    'so we will catch it and deal with it accordingly
    'Also, the sensitivity is a double value, so we should prevent and other values to be sent.  Since I am using the
    'Double.parse method, it will throw a FormatException if anything other than a double value is entered, so
    'we'll catch that and deal with it accordingly

    Private Sub sensitivityTxt_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles sensitivityTxt.TextChanged
        If sensitivityTxt.Text <> "" Then
            Try
                phidgetPH.sensor.Sensitivity = Double.Parse(sensitivityTxt.Text)
            Catch ex As Phidgets.PhidgetException
                MessageBox.Show(ex.Description)
            Catch ex As FormatException
                MessageBox.Show("Invalid sensitivity format entered - must be a decimal number")
            End Try
        End If

    End Sub

    'When the application is terminating, close the Phidget.
    Private Sub Form1_FormClosed(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        RemoveHandler phidgetPH.Attach, AddressOf phidgetPH_Attach
        RemoveHandler phidgetPH.Detach, AddressOf phidgetPH_Detach
        RemoveHandler phidgetPH.Error, AddressOf phidgetPH_Error
        RemoveHandler phidgetPH.PHChange, AddressOf phidgetPH_PHChange
        Application.DoEvents()


        phidgetPH.close()
    End Sub

End Class